//[okhttp](../../../../index.md)/[okhttp3](../../index.md)/[OkHttpClient](../index.md)/[Builder](index.md)/[retryOnConnectionFailure](retry-on-connection-failure.md)

# retryOnConnectionFailure

[jvm]\
fun [retryOnConnectionFailure](retry-on-connection-failure.md)(retryOnConnectionFailure: [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)): [OkHttpClient.Builder](index.md)

Configure this client to retry or not when a connectivity problem is encountered. By default, this client silently recovers from the following problems:

- 
   **Unreachable IP addresses.** If the URL's host has multiple IP addresses, failure to reach any individual IP address doesn't fail the overall request. This can increase availability of multi-homed services.
- 
   **Stale pooled connections.** The [ConnectionPool](../../-connection-pool/index.md) reuses sockets to decrease request latency, but these connections will occasionally time out.
- 
   **Unreachable proxy servers.** A [ProxySelector](https://docs.oracle.com/javase/8/docs/api/java/net/ProxySelector.html) can be used to attempt multiple proxy servers in sequence, eventually falling back to a direct connection.

Set this to false to avoid retrying requests when doing so is destructive. In this case the calling application should do its own recovery of connectivity failures.
