//[okhttp](../../../index.md)/[okhttp3](../index.md)/[RequestBody](index.md)/[isOneShot](is-one-shot.md)

# isOneShot

[common]\
expect open fun [isOneShot](is-one-shot.md)(): [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)

Returns true if this body expects at most one call to [writeTo](write-to.md) and can be transmitted at most once. This is typically used when writing the request body is destructive and it is not possible to recreate the request body after it has been sent.

This method returns false unless it is overridden by a subclass.

By default OkHttp will attempt to retransmit request bodies when the original request fails due to any of:

- 
   A stale connection. The request was made on a reused connection and that reused connection     has since been closed by the server.
- 
   A client timeout (HTTP 408).
- 
   A authorization challenge (HTTP 401 and 407) that is satisfied by the Authenticator.
- 
   A retryable server failure (HTTP 503 with a `Retry-After: 0` response header).
- 
   A misdirected request (HTTP 421) on a coalesced connection.

[jvm, nonJvm]\
[jvm, nonJvm]\
actual open fun [isOneShot](is-one-shot.md)(): [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)
