/*
 * Decompiled with CFR 0.152.
 */
package com.structurizr;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.structurizr.AbstractWorkspace;
import com.structurizr.WorkspaceValidationException;
import com.structurizr.documentation.Documentable;
import com.structurizr.documentation.Documentation;
import com.structurizr.model.Component;
import com.structurizr.model.Container;
import com.structurizr.model.ContainerInstance;
import com.structurizr.model.CustomElement;
import com.structurizr.model.DeploymentNode;
import com.structurizr.model.Element;
import com.structurizr.model.Model;
import com.structurizr.model.Person;
import com.structurizr.model.Relationship;
import com.structurizr.model.SoftwareSystem;
import com.structurizr.model.SoftwareSystemInstance;
import com.structurizr.view.ComponentView;
import com.structurizr.view.ContainerView;
import com.structurizr.view.DeploymentView;
import com.structurizr.view.DynamicView;
import com.structurizr.view.ImageView;
import com.structurizr.view.ModelView;
import com.structurizr.view.SystemContextView;
import com.structurizr.view.View;
import com.structurizr.view.ViewSet;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class Workspace
extends AbstractWorkspace
implements Documentable {
    private static final Log log = LogFactory.getLog(Workspace.class);
    private Model model = this.createModel();
    private ViewSet viewSet;
    private Documentation documentation;

    Workspace() {
    }

    public Workspace(String name) {
        this(name, "");
    }

    public Workspace(String name, String description) {
        super(name, description);
        this.model = this.createModel();
        this.viewSet = this.createViewSet();
        this.documentation = new Documentation();
    }

    public Model getModel() {
        return this.model;
    }

    void setModel(Model model) {
        this.model = model;
    }

    public ViewSet getViews() {
        return this.viewSet;
    }

    void setViews(ViewSet viewSet) {
        this.viewSet = viewSet;
    }

    private Model createModel() {
        try {
            Constructor constructor = Model.class.getDeclaredConstructor(new Class[0]);
            constructor.setAccessible(true);
            return (Model)constructor.newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private ViewSet createViewSet() {
        try {
            Constructor constructor = ViewSet.class.getDeclaredConstructor(Model.class);
            constructor.setAccessible(true);
            return (ViewSet)constructor.newInstance(this.model);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void hydrate() {
        if (this.viewSet == null) {
            this.viewSet = this.createViewSet();
        }
        this.hydrateModel();
        this.hydrateViewSet();
    }

    private void hydrateModel() {
        try {
            Method hydrateMethod = Model.class.getDeclaredMethod("hydrate", new Class[0]);
            hydrateMethod.setAccessible(true);
            hydrateMethod.invoke((Object)this.model, new Object[0]);
        }
        catch (InvocationTargetException ite) {
            if (ite.getCause() != null && ite.getCause() instanceof WorkspaceValidationException) {
                throw (WorkspaceValidationException)ite.getCause();
            }
            throw new RuntimeException(ite.getCause());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void hydrateViewSet() {
        try {
            Method hydrateMethod = ViewSet.class.getDeclaredMethod("hydrate", Model.class);
            hydrateMethod.setAccessible(true);
            hydrateMethod.invoke((Object)this.viewSet, this.model);
        }
        catch (InvocationTargetException ite) {
            if (ite.getCause() != null && ite.getCause() instanceof WorkspaceValidationException) {
                throw (WorkspaceValidationException)ite.getCause();
            }
            throw new RuntimeException(ite.getCause());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Documentation getDocumentation() {
        return this.documentation;
    }

    void setDocumentation(@Nonnull Documentation documentation) {
        this.documentation = documentation;
    }

    @JsonIgnore
    public boolean isEmpty() {
        return this.model.isEmpty() && this.viewSet.isEmpty() && this.documentation.isEmpty();
    }

    public void trim() {
        for (CustomElement element : this.model.getCustomElements()) {
            this.remove(element);
        }
        for (Person person : this.model.getPeople()) {
            this.remove(person);
        }
        for (SoftwareSystem softwareSystem : this.model.getSoftwareSystems()) {
            this.remove(softwareSystem);
        }
        for (DeploymentNode deploymentNode : this.model.getDeploymentNodes()) {
            this.remove(deploymentNode);
        }
    }

    void remove(CustomElement element) {
        if (!this.isElementAssociatedWithAnyViews(element)) {
            try {
                Method method = Model.class.getDeclaredMethod("remove", CustomElement.class);
                method.setAccessible(true);
                method.invoke((Object)this.model, element);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    void remove(Person person) {
        if (!this.isElementAssociatedWithAnyViews(person)) {
            try {
                Method method = Model.class.getDeclaredMethod("remove", Person.class);
                method.setAccessible(true);
                method.invoke((Object)this.model, person);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    void remove(SoftwareSystem softwareSystem) {
        Set softwareSystemInstances = this.model.getElements().stream().filter(e -> e instanceof SoftwareSystemInstance && ((SoftwareSystemInstance)e).getSoftwareSystem() == softwareSystem).map(e -> (SoftwareSystemInstance)e).collect(Collectors.toSet());
        for (SoftwareSystemInstance softwareSystemInstance : softwareSystemInstances) {
            this.remove(softwareSystemInstance);
        }
        for (Container container : softwareSystem.getContainers()) {
            this.remove(container);
        }
        boolean hasContainers = softwareSystem.hasContainers();
        boolean hasSoftwareSystemInstances = this.model.getElements().stream().anyMatch(e -> e instanceof SoftwareSystemInstance && ((SoftwareSystemInstance)e).getSoftwareSystem() == softwareSystem);
        if (!(hasContainers || hasSoftwareSystemInstances || this.isElementAssociatedWithAnyViews(softwareSystem))) {
            try {
                Method method = Model.class.getDeclaredMethod("remove", SoftwareSystem.class);
                method.setAccessible(true);
                method.invoke((Object)this.model, softwareSystem);
            }
            catch (Exception e2) {
                throw new RuntimeException(e2);
            }
        }
    }

    void remove(Container container) {
        for (Component component : container.getComponents()) {
            this.remove(component);
        }
        if (!this.isElementAssociatedWithAnyViews(container)) {
            Set containerInstances = this.model.getElements().stream().filter(e -> e instanceof ContainerInstance && ((ContainerInstance)e).getContainer() == container).map(e -> (ContainerInstance)e).collect(Collectors.toSet());
            for (ContainerInstance containerInstance : containerInstances) {
                this.remove(containerInstance);
            }
            boolean bl = container.hasComponents();
            boolean hasContainerInstances = this.model.getElements().stream().anyMatch(e -> e instanceof ContainerInstance && ((ContainerInstance)e).getContainer() == container);
            if (!(bl || hasContainerInstances || this.isElementAssociatedWithAnyViews(container))) {
                try {
                    Method method = Model.class.getDeclaredMethod("remove", Container.class);
                    method.setAccessible(true);
                    method.invoke((Object)this.model, container);
                }
                catch (Exception e2) {
                    throw new RuntimeException(e2);
                }
            }
        }
    }

    void remove(Component component) {
        if (!this.isElementAssociatedWithAnyViews(component)) {
            try {
                Method method = Model.class.getDeclaredMethod("remove", Component.class);
                method.setAccessible(true);
                method.invoke((Object)this.model, component);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    void remove(SoftwareSystemInstance softwareSystemInstance) {
        if (!this.isElementAssociatedWithAnyViews(softwareSystemInstance)) {
            try {
                Method method = Model.class.getDeclaredMethod("remove", SoftwareSystemInstance.class);
                method.setAccessible(true);
                method.invoke((Object)this.model, softwareSystemInstance);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    void remove(ContainerInstance containerInstance) {
        if (!this.isElementAssociatedWithAnyViews(containerInstance)) {
            try {
                Method method = Model.class.getDeclaredMethod("remove", ContainerInstance.class);
                method.setAccessible(true);
                method.invoke((Object)this.model, containerInstance);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    void remove(DeploymentNode deploymentNode) {
        if (deploymentNode.hasChildren()) {
            for (DeploymentNode child : deploymentNode.getChildren()) {
                this.remove(child);
            }
        }
        if (!(deploymentNode.hasChildren() || deploymentNode.hasSoftwareSystemInstances() || deploymentNode.hasContainerInstances())) {
            try {
                Method method = Model.class.getDeclaredMethod("remove", DeploymentNode.class);
                method.setAccessible(true);
                method.invoke((Object)this.model, deploymentNode);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    public void remove(Relationship relationship) {
        if (relationship == null) {
            throw new IllegalArgumentException("A relationship must be specified.");
        }
        for (View view : this.viewSet.getViews()) {
            ModelView modelView;
            if (!(view instanceof ModelView) || !(modelView = (ModelView)view).isRelationshipInView(relationship)) continue;
            modelView.remove(relationship);
        }
        try {
            Method method = Model.class.getDeclaredMethod("remove", Relationship.class);
            method.setAccessible(true);
            method.invoke((Object)this.model, relationship);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private boolean isElementAssociatedWithAnyViews(Element element) {
        boolean result = false;
        for (View view : this.viewSet.getViews()) {
            if (!(view instanceof ModelView)) continue;
            ModelView modelView = (ModelView)view;
            result |= modelView.isElementInView(element);
        }
        for (SystemContextView systemContextView : this.viewSet.getSystemContextViews()) {
            result |= systemContextView.getSoftwareSystem() == element;
        }
        for (ContainerView containerView : this.viewSet.getContainerViews()) {
            result |= containerView.getSoftwareSystem() == element;
        }
        for (ComponentView componentView : this.viewSet.getComponentViews()) {
            result |= componentView.getContainer() == element;
        }
        for (DynamicView dynamicView : this.viewSet.getDynamicViews()) {
            result |= dynamicView.getElement() == element;
        }
        for (DeploymentView deploymentView : this.viewSet.getDeploymentViews()) {
            result |= deploymentView.getSoftwareSystem() == element;
        }
        for (ImageView imageView : this.viewSet.getImageViews()) {
            result |= imageView.getElement() == element;
        }
        return result;
    }
}

