/*
 * Decompiled with CFR 0.152.
 */
package com.structurizr.export.plantuml;

import com.structurizr.export.IndentingWriter;
import com.structurizr.export.plantuml.PlantUMLStyle;
import com.structurizr.view.Border;
import com.structurizr.view.Shape;
import java.util.Base64;

class PlantUMLElementStyle
extends PlantUMLStyle {
    private final Shape shape;
    private int width;
    private final String background;
    private final String color;
    private final String stroke;
    private final int strokeWidth;
    private final String lineStyle;
    private final int fontSize;
    private final String icon;
    private final boolean shadow;

    PlantUMLElementStyle(String name, Shape shape, int width, String background, String color, String stroke, int strokeWidth, Border border, int fontSize, String icon, boolean shadow) {
        super(name);
        this.shape = shape;
        this.width = width;
        this.background = background;
        this.color = color;
        this.stroke = stroke;
        this.strokeWidth = strokeWidth;
        switch (border) {
            case Dotted: {
                this.lineStyle = strokeWidth + "-" + strokeWidth;
                break;
            }
            case Dashed: {
                this.lineStyle = strokeWidth * 5 + "-" + strokeWidth * 5;
                break;
            }
            default: {
                this.lineStyle = "0";
            }
        }
        this.fontSize = fontSize;
        this.icon = icon;
        this.shadow = shadow;
    }

    Shape getShape() {
        return this.shape;
    }

    int getFontSize() {
        return this.fontSize;
    }

    String getIcon() {
        return this.icon;
    }

    void setWidth(int width) {
        this.width = width;
    }

    @Override
    String getClassSelector() {
        return "Element-" + Base64.getEncoder().encodeToString(this.name.getBytes());
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PlantUMLElementStyle that = (PlantUMLElementStyle)o;
        return this.getClassSelector().equals(that.getClassSelector());
    }

    public String toString() {
        IndentingWriter writer = new IndentingWriter();
        writer.indent();
        writer.writeLine(String.format("// %s", this.name));
        writer.writeLine(String.format(".%s {", this.getClassSelector()));
        writer.indent();
        writer.writeLine(String.format("BackgroundColor: %s;", this.background));
        writer.writeLine(String.format("LineColor: %s;", this.stroke));
        writer.writeLine(String.format("LineStyle: %s;", this.lineStyle));
        writer.writeLine(String.format("LineThickness: %s;", this.strokeWidth));
        if (this.shape == Shape.RoundedBox) {
            writer.writeLine("RoundCorner: 20;");
        }
        writer.writeLine(String.format("FontColor: %s;", this.color));
        writer.writeLine(String.format("FontSize: %s;", this.fontSize));
        writer.writeLine("HorizontalAlignment: center;");
        writer.writeLine(String.format("Shadowing: %s;", this.shadow ? 10 : 0));
        writer.writeLine(String.format("MaximumWidth: %s;", this.width));
        writer.outdent();
        writer.writeLine("}");
        writer.outdent();
        writer.writeLine();
        return writer.toString();
    }
}

