/*
 * Decompiled with CFR 0.152.
 */
package com.structurizr.export.plantuml;

import com.structurizr.export.IndentingWriter;
import com.structurizr.export.plantuml.PlantUMLStyle;
import com.structurizr.view.LineStyle;
import java.util.Base64;

class PlantUMLRelationshipStyle
extends PlantUMLStyle {
    private final String color;
    private final String lineStyle;
    private final int thickness;
    private final int fontSize;

    PlantUMLRelationshipStyle(String name, String color, LineStyle lineStyle, int thickness, int fontSize) {
        super(name);
        this.color = color;
        this.thickness = thickness;
        this.fontSize = fontSize;
        switch (lineStyle) {
            case Dotted: {
                this.lineStyle = thickness + "-" + thickness;
                break;
            }
            case Dashed: {
                this.lineStyle = thickness * 5 + "-" + thickness * 5;
                break;
            }
            default: {
                this.lineStyle = "0";
            }
        }
    }

    @Override
    String getClassSelector() {
        return "Relationship-" + Base64.getEncoder().encodeToString(this.name.getBytes());
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PlantUMLRelationshipStyle that = (PlantUMLRelationshipStyle)o;
        return this.getClassSelector().equals(that.getClassSelector());
    }

    public String toString() {
        IndentingWriter writer = new IndentingWriter();
        writer.indent();
        writer.writeLine(String.format("// %s", this.name));
        writer.writeLine(String.format(".%s {", this.getClassSelector()));
        writer.indent();
        writer.writeLine(String.format("LineThickness: %s;", this.thickness));
        writer.writeLine(String.format("LineStyle: %s;", this.lineStyle));
        writer.writeLine(String.format("LineColor: %s;", this.color));
        writer.writeLine(String.format("FontColor: %s;", this.color));
        writer.writeLine(String.format("FontSize: %s;", this.fontSize));
        writer.outdent();
        writer.writeLine("}");
        writer.outdent();
        writer.writeLine();
        return writer.toString();
    }
}

