/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.util;

import com.sun.grizzly.util.ExpandJar;
import com.sun.grizzly.util.LoggerUtils;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.logging.Level;

public class ClassLoaderUtil {
    public static ClassLoader createClassloader(File libDir, ClassLoader cl) throws IOException {
        URLClassLoader urlClassloader = null;
        if (libDir.exists() && libDir.isDirectory()) {
            String[] jars = libDir.list(new FilenameFilter(){

                public boolean accept(File dir, String name) {
                    return name.endsWith(".jar") || name.endsWith(".zip");
                }
            });
            URL[] urls = new URL[jars.length];
            for (int i = 0; i < jars.length; ++i) {
                String path = new File(libDir.getName() + File.separator + jars[i]).getCanonicalFile().toURI().toURL().toString();
                urls[i] = new URL(path);
            }
            urlClassloader = new URLClassLoader(urls, cl);
        }
        return urlClassloader;
    }

    public static URLClassLoader createURLClassLoader(String dirPath) throws IOException {
        URL[] urls;
        String path;
        URL classesURL;
        URL appRoot;
        String separator;
        if (!(dirPath.endsWith(File.separator) || dirPath.endsWith(".war") || dirPath.endsWith(".jar"))) {
            dirPath = dirPath + File.separator;
        }
        String string = separator = System.getProperty("os.name").toLowerCase().startsWith("win") ? "/" : "//";
        if (dirPath != null && (dirPath.endsWith(".war") || dirPath.endsWith(".jar"))) {
            File file = new File(dirPath);
            appRoot = new URL("jar:file:" + separator + file.getCanonicalPath().replace('\\', '/') + "!/");
            classesURL = new URL("jar:file:" + separator + file.getCanonicalPath().replace('\\', '/') + "!/WEB-INF/classes/");
            path = ExpandJar.expand(appRoot);
        } else {
            path = dirPath;
            classesURL = new URL("file://" + path + "WEB-INF/classes/");
            appRoot = new URL("file://" + path);
        }
        String absolutePath = new File(path).getAbsolutePath();
        File libFiles = new File(absolutePath + File.separator + "WEB-INF" + File.separator + "lib");
        int arraySize = 4;
        if (libFiles.exists() && libFiles.isDirectory()) {
            urls = new URL[libFiles.listFiles().length + arraySize];
            for (int i = 0; i < libFiles.listFiles().length; ++i) {
                urls[i] = new URL("jar:file:" + separator + libFiles.listFiles()[i].toString().replace('\\', '/') + "!/");
            }
        } else {
            urls = new URL[arraySize];
        }
        urls[urls.length - 1] = classesURL;
        urls[urls.length - 2] = appRoot;
        urls[urls.length - 3] = new URL("file://" + path + "/WEB-INF/classes/");
        urls[urls.length - 4] = new URL("file://" + path);
        return new URLClassLoader(urls, Thread.currentThread().getContextClassLoader());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static URLClassLoader createURLClassLoader(String location, ClassLoader parent) throws IOException {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(parent);
        try {
            URLClassLoader uRLClassLoader = ClassLoaderUtil.createURLClassLoader(location);
            return uRLClassLoader;
        }
        finally {
            Thread.currentThread().setContextClassLoader(loader);
        }
    }

    public static Object load(String clazzName) {
        return ClassLoaderUtil.load(clazzName, Thread.currentThread().getContextClassLoader());
    }

    public static Object load(String clazzName, ClassLoader classLoader) {
        try {
            Class<?> className = Class.forName(clazzName, true, classLoader);
            return className.newInstance();
        }
        catch (Throwable t) {
            LoggerUtils.getLogger().log(Level.SEVERE, "Unable to load class " + clazzName, t);
            return null;
        }
    }
}

