/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly;

import com.sun.grizzly.BaseSelectionKeyHandler;
import com.sun.grizzly.CallbackHandler;
import com.sun.grizzly.ConnectorHandler;
import com.sun.grizzly.Controller;
import com.sun.grizzly.ReadController;
import com.sun.grizzly.SelectionKeyHandler;
import com.sun.grizzly.SelectorHandler;
import com.sun.grizzly.async.AsyncQueueDataProcessor;
import com.sun.grizzly.async.AsyncQueueReadUnit;
import com.sun.grizzly.async.AsyncQueueWriteUnit;
import com.sun.grizzly.async.AsyncReadCallbackHandler;
import com.sun.grizzly.async.AsyncReadCondition;
import com.sun.grizzly.async.AsyncWriteCallbackHandler;
import com.sun.grizzly.async.ByteBufferCloner;
import com.sun.grizzly.util.InputReader;
import com.sun.grizzly.util.OutputWriter;
import java.io.IOException;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.NotYetConnectedException;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.WritableByteChannel;
import java.util.concurrent.Future;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractConnectorHandler<E extends SelectorHandler, K extends CallbackHandler>
implements ConnectorHandler<E, K> {
    protected Controller.Protocol protocol;
    protected Controller controller;
    protected E selectorHandler;
    protected K callbackHandler;
    protected SelectableChannel underlyingChannel;
    protected volatile boolean isConnected;
    protected InputReader inputStream;

    @Override
    public Controller.Protocol protocol() {
        return this.protocol;
    }

    public void protocol(Controller.Protocol protocol) {
        this.protocol = protocol;
    }

    @Override
    public void setController(Controller controller) {
        this.controller = controller;
    }

    @Override
    public Controller getController() {
        return this.controller;
    }

    @Override
    public E getSelectorHandler() {
        return this.selectorHandler;
    }

    @Override
    public void connect(SocketAddress remoteAddress, K callbackHandler) throws IOException {
        this.connect(remoteAddress, (SocketAddress)null, callbackHandler);
    }

    @Override
    public void connect(SocketAddress remoteAddress) throws IOException {
        this.connect(remoteAddress, (K)null);
    }

    @Override
    public void connect(SocketAddress remoteAddress, K callbackHandler, E selectorHandler) throws IOException {
        this.connect(remoteAddress, null, callbackHandler, selectorHandler);
    }

    @Override
    public void connect(SocketAddress remoteAddress, SocketAddress localAddress, K callbackHandler) throws IOException {
        if (this.controller == null) {
            throw new IllegalStateException("Controller cannot be null");
        }
        if (this.protocol == null) {
            throw new IllegalStateException("Protocol cannot be null");
        }
        SelectorHandler selectorHandler = this.controller.getSelectorHandler(this.protocol);
        if (this.controller.getReadThreadsCount() > 0 && this.controller.multiReadThreadSelectorHandler.supportsClient(selectorHandler)) {
            if (this.controller.multiReadThreadSelectorHandler == null) {
                throw new IllegalStateException("ComplexSelectorHandler cannot be null");
            }
            ReadController auxController = this.controller.multiReadThreadSelectorHandler.nextController();
            SelectorHandler relativeSelectorHandler = auxController.getSelectorHandlerClone(selectorHandler);
            if (relativeSelectorHandler == null && (relativeSelectorHandler = auxController.getSelectorHandler(selectorHandler.protocol())) == null) {
                throw new IOException("Can not get correct SelectorHandler");
            }
            selectorHandler = relativeSelectorHandler;
        }
        this.connect(remoteAddress, localAddress, callbackHandler, selectorHandler);
    }

    public void setSelectorHandler(E selectorHandler) {
        this.selectorHandler = selectorHandler;
    }

    @Override
    public SelectableChannel getUnderlyingChannel() {
        return this.underlyingChannel;
    }

    public void setUnderlyingChannel(SelectableChannel underlyingChannel) {
        this.underlyingChannel = underlyingChannel;
    }

    @Override
    public K getCallbackHandler() {
        return this.callbackHandler;
    }

    @Override
    public void setCallbackHandler(K callbackHandler) {
        this.callbackHandler = callbackHandler;
    }

    @Override
    public boolean isConnected() {
        return this.isConnected && this.underlyingChannel != null && this.underlyingChannel.isOpen();
    }

    @Override
    public long read(ByteBuffer byteBuffer, boolean blocking) throws IOException {
        if (!this.isConnected) {
            throw new NotYetConnectedException();
        }
        SelectionKey key = this.selectorHandler.keyFor(this.underlyingChannel);
        int nRead = -1;
        if (blocking) {
            this.inputStream.setSelectionKey(key);
            try {
                nRead = this.inputStream.read(byteBuffer);
            }
            catch (IOException ex) {
                nRead = -1;
                throw ex;
            }
            finally {
                SelectionKeyHandler skh;
                if (nRead == -1 && (skh = this.selectorHandler.getSelectionKeyHandler()) instanceof BaseSelectionKeyHandler) {
                    ((BaseSelectionKeyHandler)skh).notifyRemotlyClose(key);
                }
            }
            return nRead;
        }
        if (this.callbackHandler == null) {
            throw new IllegalStateException("Non blocking read needs a CallbackHandler");
        }
        try {
            nRead = ((ReadableByteChannel)((Object)this.underlyingChannel)).read(byteBuffer);
        }
        catch (IOException ex) {
            nRead = -1;
            throw ex;
        }
        finally {
            SelectionKeyHandler skh;
            if (nRead == -1 && (skh = this.selectorHandler.getSelectionKeyHandler()) instanceof BaseSelectionKeyHandler) {
                ((BaseSelectionKeyHandler)skh).notifyRemotlyClose(key);
            }
        }
        if (nRead == 0) {
            this.selectorHandler.register(key, 1);
        }
        return nRead;
    }

    @Override
    public long write(ByteBuffer byteBuffer, boolean blocking) throws IOException {
        if (!this.isConnected) {
            throw new NotYetConnectedException();
        }
        if (blocking) {
            return OutputWriter.flushChannel(this.underlyingChannel, byteBuffer);
        }
        if (this.callbackHandler == null) {
            throw new IllegalStateException("Non blocking write needs a CallbackHandler");
        }
        SelectionKey key = this.selectorHandler.keyFor(this.underlyingChannel);
        int nWrite = 1;
        int totalWriteBytes = 0;
        try {
            while (nWrite > 0 && byteBuffer.hasRemaining()) {
                nWrite = ((WritableByteChannel)((Object)this.underlyingChannel)).write(byteBuffer);
                totalWriteBytes += nWrite;
            }
        }
        catch (IOException ex) {
            nWrite = -1;
            throw ex;
        }
        finally {
            SelectionKeyHandler skh;
            if (nWrite == -1 && (skh = this.selectorHandler.getSelectionKeyHandler()) instanceof BaseSelectionKeyHandler) {
                ((BaseSelectionKeyHandler)skh).notifyRemotlyClose(key);
            }
        }
        if (totalWriteBytes == 0 && byteBuffer.hasRemaining()) {
            this.selectorHandler.register(key, 4);
        }
        return totalWriteBytes;
    }

    @Override
    public Future<AsyncQueueReadUnit> readFromAsyncQueue(ByteBuffer buffer, AsyncReadCallbackHandler callbackHandler) throws IOException {
        return this.readFromAsyncQueue(buffer, callbackHandler, null);
    }

    @Override
    public Future<AsyncQueueReadUnit> readFromAsyncQueue(ByteBuffer buffer, AsyncReadCallbackHandler callbackHandler, AsyncReadCondition condition) throws IOException {
        return this.readFromAsyncQueue(buffer, callbackHandler, condition, null);
    }

    @Override
    public Future<AsyncQueueReadUnit> readFromAsyncQueue(ByteBuffer buffer, AsyncReadCallbackHandler callbackHandler, AsyncReadCondition condition, AsyncQueueDataProcessor readPostProcessor) throws IOException {
        return this.selectorHandler.getAsyncQueueReader().read(this.selectorHandler.keyFor(this.underlyingChannel), buffer, callbackHandler, condition, readPostProcessor);
    }

    @Override
    public Future<AsyncQueueWriteUnit> writeToAsyncQueue(ByteBuffer buffer) throws IOException {
        return this.writeToAsyncQueue(buffer, null);
    }

    @Override
    public Future<AsyncQueueWriteUnit> writeToAsyncQueue(ByteBuffer buffer, AsyncWriteCallbackHandler callbackHandler) throws IOException {
        return this.writeToAsyncQueue(buffer, callbackHandler, null);
    }

    @Override
    public Future<AsyncQueueWriteUnit> writeToAsyncQueue(ByteBuffer buffer, AsyncWriteCallbackHandler callbackHandler, AsyncQueueDataProcessor writePreProcessor) throws IOException {
        return this.writeToAsyncQueue(buffer, callbackHandler, writePreProcessor, null);
    }

    @Override
    public Future<AsyncQueueWriteUnit> writeToAsyncQueue(ByteBuffer buffer, AsyncWriteCallbackHandler callbackHandler, AsyncQueueDataProcessor writePreProcessor, ByteBufferCloner cloner) throws IOException {
        return this.selectorHandler.getAsyncQueueWriter().write(this.selectorHandler.keyFor(this.underlyingChannel), buffer, callbackHandler, writePreProcessor, cloner);
    }

    @Override
    public Future<AsyncQueueWriteUnit> writeToAsyncQueue(SocketAddress dstAddress, ByteBuffer buffer) throws IOException {
        return this.writeToAsyncQueue(dstAddress, buffer, null);
    }

    @Override
    public Future<AsyncQueueWriteUnit> writeToAsyncQueue(SocketAddress dstAddress, ByteBuffer buffer, AsyncWriteCallbackHandler callbackHandler) throws IOException {
        return this.writeToAsyncQueue(dstAddress, buffer, callbackHandler, null);
    }

    @Override
    public Future<AsyncQueueWriteUnit> writeToAsyncQueue(SocketAddress dstAddress, ByteBuffer buffer, AsyncWriteCallbackHandler callbackHandler, AsyncQueueDataProcessor writePreProcessor) throws IOException {
        return this.writeToAsyncQueue(dstAddress, buffer, callbackHandler, writePreProcessor, null);
    }

    @Override
    public Future<AsyncQueueWriteUnit> writeToAsyncQueue(SocketAddress dstAddress, ByteBuffer buffer, AsyncWriteCallbackHandler callbackHandler, AsyncQueueDataProcessor writePreProcessor, ByteBufferCloner cloner) throws IOException {
        return this.selectorHandler.getAsyncQueueWriter().write(this.selectorHandler.keyFor(this.underlyingChannel), dstAddress, buffer, callbackHandler, writePreProcessor, cloner);
    }
}

