/*
 * Decompiled with CFR 0.152.
 */
package com.sun.istack.maven;

import com.sun.codemodel.JClass;
import com.sun.codemodel.JClassAlreadyExistsException;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JFieldVar;
import com.sun.codemodel.JInvocation;
import com.sun.codemodel.JMethod;
import com.sun.codemodel.JPackage;
import com.sun.codemodel.JType;
import com.sun.istack.maven.NameConverter;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Properties;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.shared.model.fileset.FileSet;
import org.apache.maven.shared.model.fileset.util.FileSetManager;

public class ResourceGenMojo
extends AbstractMojo {
    private File destDir;
    private FileSet resources;
    private String localizationUtilitiesPkgName;

    public void execute() throws MojoExecutionException {
        if (this.resources == null) {
            throw new MojoExecutionException("No resource file is specified");
        }
        if (this.destDir == null) {
            throw new MojoExecutionException("No destdir attribute is specified");
        }
        if (this.localizationUtilitiesPkgName == null) {
            this.localizationUtilitiesPkgName = "com.sun.istack.localization";
        }
        if (!this.destDir.exists()) {
            this.destDir.mkdirs();
        }
        FileSetManager fileSetManager = new FileSetManager();
        String[] includedFiles = fileSetManager.getIncludedFiles(this.resources);
        System.out.println("Resources:");
        for (String s : includedFiles) {
            System.out.println(s);
        }
        JCodeModel cm = new JCodeModel();
        for (String value : includedFiles) {
            JClass lable_class;
            JClass l_class;
            JClass lmf_class;
            JDefinedClass clazz;
            File res = null == this.resources.getDirectory() ? new File(value) : new File(this.resources.getDirectory(), value);
            if (res.getName().contains("_")) continue;
            String className = this.getClassName(res);
            String bundleName = value.substring(0, value.lastIndexOf(46)).replace('/', '.').replace('\\', '.');
            String dirName = bundleName.substring(0, bundleName.lastIndexOf(46));
            File destFile = new File(new File(this.destDir, dirName.replace('.', '/')), className + ".java");
            if (destFile.exists() && destFile.lastModified() >= res.lastModified()) {
                System.out.println("Skipping " + res);
                continue;
            }
            System.out.println("Processing " + res);
            JPackage pkg = cm._package(dirName);
            Properties props = new Properties();
            try {
                FileInputStream in = new FileInputStream(res);
                props.load(in);
                in.close();
            }
            catch (IOException e) {
                throw new MojoExecutionException(e.getMessage(), (Exception)e);
            }
            try {
                clazz = pkg._class(9, className);
            }
            catch (JClassAlreadyExistsException e) {
                throw new MojoExecutionException("Name conflict " + className);
            }
            clazz.javadoc().add((Object)"Defines string formatting method for each constant in the resource file");
            try {
                lmf_class = cm.parseType(this.addLocalizationUtilityPackageName("LocalizableMessageFactory")).boxify();
                l_class = cm.parseType(this.addLocalizationUtilityPackageName("Localizer")).boxify();
                lable_class = cm.parseType(this.addLocalizationUtilityPackageName("Localizable")).boxify();
            }
            catch (ClassNotFoundException e) {
                throw new MojoExecutionException(e.getMessage(), (Exception)e);
            }
            JFieldVar $msgFactory = clazz.field(28, (JType)lmf_class, "messageFactory", (JExpression)JExpr._new((JClass)lmf_class).arg(JExpr.lit((String)bundleName)));
            JFieldVar $localizer = clazz.field(28, (JType)l_class, "localizer", (JExpression)JExpr._new((JClass)l_class));
            for (Object key : props.keySet()) {
                String methodBaseName = NameConverter.smart.toConstantName(key.toString());
                JMethod method = clazz.method(17, (JType)lable_class, "localizable" + methodBaseName);
                int countArgs = this.countArgs(props.getProperty(key.toString()));
                JInvocation format = $msgFactory.invoke("getMessage").arg(JExpr.lit((String)key.toString()));
                for (int i = 0; i < countArgs; ++i) {
                    format.arg((JExpression)method.param(Object.class, "arg" + i));
                }
                method.body()._return((JExpression)format);
                JMethod method2 = clazz.method(17, String.class, methodBaseName);
                method2.javadoc().add(props.get(key));
                JInvocation localize = JExpr.invoke((JMethod)method);
                for (int i = 0; i < countArgs; ++i) {
                    localize.arg((JExpression)method2.param(Object.class, "arg" + i));
                }
                method2.body()._return((JExpression)$localizer.invoke("localize").arg((JExpression)localize));
            }
        }
        try {
            cm.build(this.destDir);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to generate code", (Exception)e);
        }
    }

    private String addLocalizationUtilityPackageName(String className) {
        return String.format("%s.%s", this.localizationUtilitiesPkgName, className);
    }

    private int countArgs(String value) {
        String r2;
        String r1;
        ArrayList<String> x = new ArrayList<String>();
        do {
            r1 = MessageFormat.format(value, x.toArray());
            x.add("xxxx");
        } while (!r1.equals(r2 = MessageFormat.format(value, x.toArray())));
        return x.size() - 1;
    }

    private String getClassName(File res) {
        String name = res.getName();
        int suffixIndex = name.lastIndexOf(46);
        name = name.substring(0, suffixIndex);
        return NameConverter.smart.toClassName(name) + "Messages";
    }
}

