/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xalan.internal.extensions;

import com.sun.org.apache.xalan.internal.extensions.ExtensionHandler;
import com.sun.org.apache.xalan.internal.extensions.ExtensionHandlerJavaClass;
import com.sun.org.apache.xalan.internal.extensions.XPathFunctionImpl;
import com.sun.org.apache.xalan.internal.res.XSLMessages;
import javax.xml.namespace.QName;
import javax.xml.xpath.XPathFunction;
import javax.xml.xpath.XPathFunctionResolver;

public class XPathFunctionResolverImpl
implements XPathFunctionResolver {
    public XPathFunction resolveFunction(QName qname, int arity) {
        int lastSlash;
        if (qname == null) {
            throw new NullPointerException(XSLMessages.createMessage("ER_XPATH_RESOLVER_NULL_QNAME", null));
        }
        if (arity < 0) {
            throw new IllegalArgumentException(XSLMessages.createMessage("ER_XPATH_RESOLVER_NEGATIVE_ARITY", null));
        }
        String uri = qname.getNamespaceURI();
        if (uri == null || uri.length() == 0) {
            return null;
        }
        String className = null;
        String methodName = null;
        if (uri.startsWith("http://exslt.org")) {
            className = this.getEXSLTClassName(uri);
            methodName = qname.getLocalPart();
        } else if (!uri.equals("http://xml.apache.org/xalan/java") && -1 != (lastSlash = className.lastIndexOf("/"))) {
            className = className.substring(lastSlash + 1);
        }
        String localPart = qname.getLocalPart();
        int lastDotIndex = localPart.lastIndexOf(46);
        if (lastDotIndex > 0) {
            className = className != null ? className + "." + localPart.substring(0, lastDotIndex) : localPart.substring(0, lastDotIndex);
            methodName = localPart.substring(lastDotIndex + 1);
        } else {
            methodName = localPart;
        }
        if (null == className || className.trim().length() == 0 || null == methodName || methodName.trim().length() == 0) {
            return null;
        }
        ExtensionHandlerJavaClass handler = null;
        try {
            ExtensionHandler.getClassForName(className);
            handler = new ExtensionHandlerJavaClass(uri, "javaclass", className);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
        return new XPathFunctionImpl(handler, methodName);
    }

    private String getEXSLTClassName(String uri) {
        if (uri.equals("http://exslt.org/math")) {
            return "com.sun.org.apache.xalan.internal.lib.ExsltMath";
        }
        if (uri.equals("http://exslt.org/sets")) {
            return "com.sun.org.apache.xalan.internal.lib.ExsltSets";
        }
        if (uri.equals("http://exslt.org/strings")) {
            return "com.sun.org.apache.xalan.internal.lib.ExsltStrings";
        }
        if (uri.equals("http://exslt.org/dates-and-times")) {
            return "com.sun.org.apache.xalan.internal.lib.ExsltDatetime";
        }
        if (uri.equals("http://exslt.org/dynamic")) {
            return "com.sun.org.apache.xalan.internal.lib.ExsltDynamic";
        }
        if (uri.equals("http://exslt.org/common")) {
            return "com.sun.org.apache.xalan.internal.lib.ExsltCommon";
        }
        return null;
    }
}

