/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xalan.internal.transformer;

import com.sun.org.apache.xalan.internal.res.XSLMessages;
import com.sun.org.apache.xalan.internal.templates.KeyDeclaration;
import com.sun.org.apache.xalan.internal.transformer.KeyIterator;
import com.sun.org.apache.xml.internal.dtm.DTM;
import com.sun.org.apache.xml.internal.dtm.DTMAxisTraverser;
import com.sun.org.apache.xml.internal.dtm.DTMIterator;
import com.sun.org.apache.xml.internal.utils.QName;
import com.sun.org.apache.xml.internal.utils.WrappedRuntimeException;
import com.sun.org.apache.xml.internal.utils.XMLString;
import com.sun.org.apache.xpath.internal.XPathContext;
import com.sun.org.apache.xpath.internal.axes.ChildTestIterator;
import com.sun.org.apache.xpath.internal.objects.XNodeSet;
import com.sun.org.apache.xpath.internal.objects.XObject;
import java.util.Vector;
import javax.xml.transform.TransformerException;

public class KeyRefIterator
extends ChildTestIterator {
    static final long serialVersionUID = 3837456451659435102L;
    DTMIterator m_keysNodes;
    protected XMLString m_ref;
    protected QName m_name;
    protected Vector m_keyDeclarations;

    public KeyRefIterator(QName name, XMLString ref, Vector keyDecls, DTMIterator ki) {
        super((DTMAxisTraverser)null);
        this.m_name = name;
        this.m_ref = ref;
        this.m_keyDeclarations = keyDecls;
        this.m_keysNodes = ki;
        this.setWhatToShow(-1);
    }

    protected int getNextNode() {
        int next;
        while (-1 != (next = this.m_keysNodes.nextNode()) && 1 != this.filterNode(next)) {
        }
        this.m_lastFetched = next;
        return next;
    }

    public short filterNode(int testNode) {
        boolean foundKey = false;
        Vector keys = this.m_keyDeclarations;
        QName name = this.m_name;
        KeyIterator ki = (KeyIterator)((XNodeSet)this.m_keysNodes).getContainedIter();
        XPathContext xctxt = ki.getXPathContext();
        if (null == xctxt) {
            this.assertion(false, "xctxt can not be null here!");
        }
        try {
            XMLString lookupKey = this.m_ref;
            int nDeclarations = keys.size();
            for (int i = 0; i < nDeclarations; ++i) {
                int useNode;
                KeyDeclaration kd = (KeyDeclaration)keys.elementAt(i);
                if (!kd.getName().equals(name)) continue;
                foundKey = true;
                XObject xuse = kd.getUse().execute(xctxt, testNode, ki.getPrefixResolver());
                if (xuse.getType() != 4) {
                    XMLString exprResult = xuse.xstr();
                    if (!lookupKey.equals(exprResult)) continue;
                    return 1;
                }
                DTMIterator nl = ((XNodeSet)xuse).iterRaw();
                while (-1 != (useNode = nl.nextNode())) {
                    DTM dtm = this.getDTM(useNode);
                    XMLString exprResult = dtm.getStringValue(useNode);
                    if (null == exprResult || !lookupKey.equals(exprResult)) continue;
                    return 1;
                }
            }
        }
        catch (TransformerException te) {
            throw new WrappedRuntimeException(te);
        }
        if (!foundKey) {
            throw new RuntimeException(XSLMessages.createMessage("ER_NO_XSLKEY_DECLARATION", new Object[]{name.getLocalName()}));
        }
        return 2;
    }
}

