/*
 * Decompiled with CFR 0.152.
 */
package com.theoryinpractise.clojure;

import com.theoryinpractise.clojure.AbstractClojureCompilerMojo;
import com.theoryinpractise.clojure.ExecutionMode;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.maven.plugin.MojoExecutionException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClojureReplMojo
extends AbstractClojureCompilerMojo {
    private String replScript;
    private static final Pattern JLINE = Pattern.compile("^.*/jline-[^/]+.jar$");

    boolean isJLineAvailable(List<String> elements) {
        if (elements != null) {
            for (String e : elements) {
                Matcher m = JLINE.matcher(e);
                if (!m.matches()) continue;
                return true;
            }
        }
        return false;
    }

    public void execute() throws MojoExecutionException {
        ArrayList<String> args = new ArrayList<String>();
        String mainClass = "clojure.main";
        if (this.isJLineAvailable(this.classpathElements)) {
            this.getLog().info((CharSequence)"Enabling JLine support");
            args.add("clojure.main");
            mainClass = "jline.ConsoleRunner";
        }
        if (this.replScript != null && new File(this.replScript).exists()) {
            args.add("-i");
            args.add(this.replScript);
            args.add("-r");
        }
        this.callClojureWith(ExecutionMode.INTERACTIVE, this.getSourceDirectories(AbstractClojureCompilerMojo.SourceDirectory.TEST, AbstractClojureCompilerMojo.SourceDirectory.COMPILE), this.outputDirectory, this.getRunWithClasspathElements(), mainClass, args.toArray(new String[args.size()]));
    }
}

