/*
 * Decompiled with CFR 0.152.
 */
package com.theoryinpractise.clojure;

import com.theoryinpractise.clojure.AbstractClojureCompilerMojo;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.maven.plugin.MojoExecutionException;

public class ClojureRunMojo
extends AbstractClojureCompilerMojo {
    private String script;
    private String[] scripts;
    private String mainClass;
    private String args;

    private static String mergeScripts(String script, String[] scripts) throws MojoExecutionException {
        if (script == null || script.trim().equals("")) {
            throw new MojoExecutionException("<script> is undefined");
        }
        if (scripts == null) {
            return script;
        }
        if (scripts.length == 0) {
            throw new MojoExecutionException("<scripts> is defined but has no <script> entries");
        }
        ArrayList<String> paths = new ArrayList<String>();
        paths.add(script);
        paths.addAll(Arrays.asList(scripts));
        for (String scriptFile : paths) {
            if (scriptFile == null || scriptFile.trim().equals("")) {
                throw new MojoExecutionException("<script> entry cannot be empty");
            }
            if (new File(scriptFile).exists()) continue;
            throw new MojoExecutionException(scriptFile + " cannot be found");
        }
        try {
            File testFile = File.createTempFile("run", ".clj");
            FileWriter writer = new FileWriter(testFile);
            for (String scriptFile : paths) {
                writer.write("(load-file \"" + scriptFile + "\")");
                writer.write(System.getProperty("line.separator"));
            }
            writer.close();
            return testFile.getPath();
        }
        catch (IOException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
    }

    public void execute() throws MojoExecutionException {
        if (this.script != null && this.mainClass != null) {
            throw new MojoExecutionException("Specify either 'script' or 'mainClass - not both.");
        }
        if (this.script == null && this.mainClass == null) {
            throw new MojoExecutionException("Specify either 'script' or 'mainClass'.");
        }
        try {
            if (this.script != null) {
                String path = ClojureRunMojo.mergeScripts(this.script, this.scripts);
                ArrayList<String> clojureArguments = new ArrayList<String>();
                clojureArguments.add(path);
                if (this.args != null) {
                    clojureArguments.addAll(Arrays.asList(this.args.split(" ")));
                }
                this.getLog().debug((CharSequence)("Running clojure:run against " + path));
                this.callClojureWith(this.getSourceDirectories(AbstractClojureCompilerMojo.SourceDirectory.COMPILE), this.outputDirectory, this.getRunWithClasspathElements(), "clojure.main", clojureArguments.toArray(new String[clojureArguments.size()]));
            } else if (this.mainClass != null) {
                this.callClojureWith(this.getSourceDirectories(AbstractClojureCompilerMojo.SourceDirectory.COMPILE), this.outputDirectory, this.getRunWithClasspathElements(), this.mainClass, this.args == null ? new String[]{} : this.args.split(" "));
            }
        }
        catch (MojoExecutionException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MojoExecutionException(e.getMessage(), e);
        }
    }
}

