/*
 * Decompiled with CFR 0.152.
 */
package parquet.avro;

import java.util.Map;
import org.apache.avro.Schema;
import org.apache.avro.generic.IndexedRecord;
import org.apache.hadoop.conf.Configuration;
import parquet.avro.AvroRecordMaterializer;
import parquet.avro.AvroSchemaConverter;
import parquet.hadoop.api.ReadSupport;
import parquet.io.api.RecordMaterializer;
import parquet.schema.MessageType;
import parquet.schema.Type;

public class AvroReadSupport<T extends IndexedRecord>
extends ReadSupport<T> {
    public static String AVRO_REQUESTED_PROJECTION = "parquet.avro.projection";

    public static void setRequestedProjection(Configuration configuration, Schema requestedProjection) {
        configuration.set(AVRO_REQUESTED_PROJECTION, requestedProjection.toString());
    }

    public ReadSupport.ReadContext init(Configuration configuration, Map<String, String> keyValueMetaData, MessageType fileSchema) {
        String requestedProjectionString = configuration.get(AVRO_REQUESTED_PROJECTION);
        if (requestedProjectionString != null) {
            Schema avroRequestedProjection = new Schema.Parser().parse(requestedProjectionString);
            MessageType requestedProjection = new AvroSchemaConverter().convert(avroRequestedProjection);
            fileSchema.checkContains((Type)requestedProjection);
            return new ReadSupport.ReadContext(requestedProjection);
        }
        return new ReadSupport.ReadContext(fileSchema);
    }

    public RecordMaterializer<T> prepareForRead(Configuration configuration, Map<String, String> keyValueMetaData, MessageType fileSchema, ReadSupport.ReadContext readContext) {
        Schema avroSchema = new Schema.Parser().parse(keyValueMetaData.get("avro.schema"));
        return new AvroRecordMaterializer(readContext.getRequestedSchema(), avroSchema);
    }
}

