/*
 * Decompiled with CFR 0.152.
 */
package parquet.avro;

import java.util.ArrayList;
import java.util.List;
import org.apache.avro.Schema;
import parquet.schema.ConversionPatterns;
import parquet.schema.GroupType;
import parquet.schema.MessageType;
import parquet.schema.OriginalType;
import parquet.schema.PrimitiveType;
import parquet.schema.Type;

public class AvroSchemaConverter {
    public static Schema getNonNull(Schema schema) {
        if (schema.getType().equals((Object)Schema.Type.UNION)) {
            List schemas = schema.getTypes();
            if (schemas.size() == 2) {
                if (((Schema)schemas.get(0)).getType().equals((Object)Schema.Type.NULL)) {
                    return (Schema)schemas.get(1);
                }
                if (((Schema)schemas.get(1)).getType().equals((Object)Schema.Type.NULL)) {
                    return (Schema)schemas.get(0);
                }
                return schema;
            }
            return schema;
        }
        return schema;
    }

    public MessageType convert(Schema avroSchema) {
        if (!avroSchema.getType().equals((Object)Schema.Type.RECORD)) {
            throw new IllegalArgumentException("Avro schema must be a record.");
        }
        return new MessageType(avroSchema.getFullName(), this.convertFields(avroSchema.getFields()));
    }

    private List<Type> convertFields(List<Schema.Field> fields) {
        ArrayList<Type> types = new ArrayList<Type>();
        for (Schema.Field field : fields) {
            if (field.schema().getType().equals((Object)Schema.Type.NULL)) continue;
            types.add(this.convertField(field));
        }
        return types;
    }

    private Type convertField(String fieldName, Schema schema) {
        return this.convertField(fieldName, schema, Type.Repetition.REQUIRED);
    }

    private Type convertField(String fieldName, Schema schema, Type.Repetition repetition) {
        Schema.Type type = schema.getType();
        if (type.equals((Object)Schema.Type.BOOLEAN)) {
            return this.primitive(fieldName, PrimitiveType.PrimitiveTypeName.BOOLEAN, repetition);
        }
        if (type.equals((Object)Schema.Type.INT)) {
            return this.primitive(fieldName, PrimitiveType.PrimitiveTypeName.INT32, repetition);
        }
        if (type.equals((Object)Schema.Type.LONG)) {
            return this.primitive(fieldName, PrimitiveType.PrimitiveTypeName.INT64, repetition);
        }
        if (type.equals((Object)Schema.Type.FLOAT)) {
            return this.primitive(fieldName, PrimitiveType.PrimitiveTypeName.FLOAT, repetition);
        }
        if (type.equals((Object)Schema.Type.DOUBLE)) {
            return this.primitive(fieldName, PrimitiveType.PrimitiveTypeName.DOUBLE, repetition);
        }
        if (type.equals((Object)Schema.Type.BYTES)) {
            return this.primitive(fieldName, PrimitiveType.PrimitiveTypeName.BINARY, repetition);
        }
        if (type.equals((Object)Schema.Type.STRING)) {
            return this.primitive(fieldName, PrimitiveType.PrimitiveTypeName.BINARY, repetition, OriginalType.UTF8);
        }
        if (type.equals((Object)Schema.Type.RECORD)) {
            return new GroupType(repetition, fieldName, this.convertFields(schema.getFields()));
        }
        if (type.equals((Object)Schema.Type.ENUM)) {
            return this.primitive(fieldName, PrimitiveType.PrimitiveTypeName.BINARY, repetition, OriginalType.ENUM);
        }
        if (type.equals((Object)Schema.Type.ARRAY)) {
            return ConversionPatterns.listType((Type.Repetition)repetition, (String)fieldName, (Type)this.convertField("array", schema.getElementType(), Type.Repetition.REPEATED));
        }
        if (type.equals((Object)Schema.Type.MAP)) {
            Type valType = this.convertField("value", schema.getValueType());
            return ConversionPatterns.stringKeyMapType((Type.Repetition)repetition, (String)fieldName, (Type)valType);
        }
        if (type.equals((Object)Schema.Type.FIXED)) {
            return this.primitive(fieldName, PrimitiveType.PrimitiveTypeName.FIXED_LEN_BYTE_ARRAY, repetition, schema.getFixedSize(), null);
        }
        if (type.equals((Object)Schema.Type.UNION)) {
            return this.convertUnion(fieldName, schema, repetition);
        }
        throw new UnsupportedOperationException("Cannot convert Avro type " + type);
    }

    private Type convertUnion(String fieldName, Schema schema, Type.Repetition repetition) {
        ArrayList<Schema> nonNullSchemas = new ArrayList<Schema>(schema.getTypes().size());
        for (Schema childSchema : schema.getTypes()) {
            if (childSchema.getType().equals((Object)Schema.Type.NULL)) {
                repetition = Type.Repetition.OPTIONAL;
                continue;
            }
            nonNullSchemas.add(childSchema);
        }
        switch (nonNullSchemas.size()) {
            case 0: {
                throw new UnsupportedOperationException("Cannot convert Avro union of only nulls");
            }
            case 1: {
                return this.convertField(fieldName, (Schema)nonNullSchemas.get(0), Type.Repetition.OPTIONAL);
            }
        }
        ArrayList<Type> unionTypes = new ArrayList<Type>(nonNullSchemas.size());
        int index = 0;
        for (Schema childSchema : nonNullSchemas) {
            unionTypes.add(this.convertField("member" + index++, childSchema, Type.Repetition.OPTIONAL));
        }
        return new GroupType(repetition, fieldName, unionTypes);
    }

    private Type convertField(Schema.Field field) {
        return this.convertField(field.name(), field.schema());
    }

    private PrimitiveType primitive(String name, PrimitiveType.PrimitiveTypeName primitive, Type.Repetition repetition, int typeLength, OriginalType originalType) {
        return new PrimitiveType(repetition, primitive, typeLength, name, originalType);
    }

    private PrimitiveType primitive(String name, PrimitiveType.PrimitiveTypeName primitive, Type.Repetition repetition, OriginalType originalType) {
        return new PrimitiveType(repetition, primitive, name, originalType);
    }

    private PrimitiveType primitive(String name, PrimitiveType.PrimitiveTypeName primitive, Type.Repetition repetition) {
        return new PrimitiveType(repetition, primitive, name, null);
    }
}

