/*
 * Decompiled with CFR 0.152.
 */
package parquet.avro;

import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericFixed;
import org.apache.avro.generic.IndexedRecord;
import org.apache.avro.util.Utf8;
import org.apache.hadoop.conf.Configuration;
import parquet.avro.AvroSchemaConverter;
import parquet.hadoop.api.WriteSupport;
import parquet.io.api.Binary;
import parquet.io.api.RecordConsumer;
import parquet.schema.GroupType;
import parquet.schema.MessageType;
import parquet.schema.Type;

public class AvroWriteSupport
extends WriteSupport<IndexedRecord> {
    private RecordConsumer recordConsumer;
    private MessageType rootSchema;
    private Schema rootAvroSchema;

    public AvroWriteSupport() {
    }

    public AvroWriteSupport(MessageType schema, Schema avroSchema) {
        this.rootSchema = schema;
        this.rootAvroSchema = avroSchema;
    }

    public static void setSchema(Configuration configuration, Schema schema) {
        configuration.set("parquet.avro.schema", schema.toString());
    }

    public WriteSupport.WriteContext init(Configuration configuration) {
        if (this.rootAvroSchema == null) {
            this.rootAvroSchema = new Schema.Parser().parse(configuration.get("parquet.avro.schema"));
            this.rootSchema = new AvroSchemaConverter().convert(this.rootAvroSchema);
        }
        HashMap<String, String> extraMetaData = new HashMap<String, String>();
        extraMetaData.put("avro.schema", this.rootAvroSchema.toString());
        return new WriteSupport.WriteContext(this.rootSchema, extraMetaData);
    }

    public void prepareForWrite(RecordConsumer recordConsumer) {
        this.recordConsumer = recordConsumer;
    }

    public void write(IndexedRecord record) {
        this.recordConsumer.startMessage();
        this.writeRecordFields((GroupType)this.rootSchema, this.rootAvroSchema, record);
        this.recordConsumer.endMessage();
    }

    private void writeRecord(GroupType schema, Schema avroSchema, IndexedRecord record) {
        this.recordConsumer.startGroup();
        this.writeRecordFields(schema, avroSchema, record);
        this.recordConsumer.endGroup();
    }

    private void writeRecordFields(GroupType schema, Schema avroSchema, IndexedRecord record) {
        List fields = schema.getFields();
        List avroFields = avroSchema.getFields();
        int index = 0;
        for (int avroIndex = 0; avroIndex < avroFields.size(); ++avroIndex) {
            Schema.Field avroField = (Schema.Field)avroFields.get(avroIndex);
            if (avroField.schema().getType().equals((Object)Schema.Type.NULL)) continue;
            Type fieldType = (Type)fields.get(index);
            Object value = record.get(avroIndex);
            if (value != null) {
                this.recordConsumer.startField(fieldType.getName(), index);
                this.writeValue(fieldType, avroField.schema(), value);
                this.recordConsumer.endField(fieldType.getName(), index);
            } else if (fieldType.isRepetition(Type.Repetition.REQUIRED)) {
                throw new RuntimeException("Null-value for required field: " + avroField.name());
            }
            ++index;
        }
    }

    private <T> void writeArray(GroupType schema, Schema avroSchema, Iterable<T> array) {
        this.recordConsumer.startGroup();
        if (array.iterator().hasNext()) {
            this.recordConsumer.startField("array", 0);
            for (T elt : array) {
                this.writeValue(schema.getType(0), avroSchema.getElementType(), elt);
            }
            this.recordConsumer.endField("array", 0);
        }
        this.recordConsumer.endGroup();
    }

    private <V> void writeMap(GroupType schema, Schema avroSchema, Map<CharSequence, V> map) {
        GroupType innerGroup = schema.getType(0).asGroupType();
        Type keyType = innerGroup.getType(0);
        Type valueType = innerGroup.getType(1);
        Schema keySchema = Schema.create((Schema.Type)Schema.Type.STRING);
        this.recordConsumer.startGroup();
        if (map.size() > 0) {
            this.recordConsumer.startField("map", 0);
            this.recordConsumer.startGroup();
            this.recordConsumer.startField("key", 0);
            for (CharSequence key : map.keySet()) {
                this.writeValue(keyType, keySchema, key);
            }
            this.recordConsumer.endField("key", 0);
            this.recordConsumer.startField("value", 1);
            for (CharSequence value : map.values()) {
                this.writeValue(valueType, avroSchema.getValueType(), value);
            }
            this.recordConsumer.endField("value", 1);
            this.recordConsumer.endGroup();
            this.recordConsumer.endField("map", 0);
        }
        this.recordConsumer.endGroup();
    }

    private void writeUnion(GroupType parquetSchema, Schema avroSchema, Object value) {
        this.recordConsumer.startGroup();
        int avroIndex = GenericData.get().resolveUnion(avroSchema, value);
        GroupType parquetGroup = parquetSchema.asGroupType();
        int parquetIndex = avroIndex;
        for (int i = 0; i < avroIndex; ++i) {
            if (!((Schema)avroSchema.getTypes().get(i)).getType().equals((Object)Schema.Type.NULL)) continue;
            --parquetIndex;
        }
        String memberName = "member" + parquetIndex;
        this.recordConsumer.startField(memberName, parquetIndex);
        this.writeValue(parquetGroup.getType(parquetIndex), (Schema)avroSchema.getTypes().get(avroIndex), value);
        this.recordConsumer.endField(memberName, parquetIndex);
        this.recordConsumer.endGroup();
    }

    private void writeValue(Type type, Schema avroSchema, Object value) {
        Schema nonNullAvroSchema = AvroSchemaConverter.getNonNull(avroSchema);
        Schema.Type avroType = nonNullAvroSchema.getType();
        if (avroType.equals((Object)Schema.Type.BOOLEAN)) {
            this.recordConsumer.addBoolean(((Boolean)value).booleanValue());
        } else if (avroType.equals((Object)Schema.Type.INT)) {
            this.recordConsumer.addInteger(((Number)value).intValue());
        } else if (avroType.equals((Object)Schema.Type.LONG)) {
            this.recordConsumer.addLong(((Number)value).longValue());
        } else if (avroType.equals((Object)Schema.Type.FLOAT)) {
            this.recordConsumer.addFloat(((Number)value).floatValue());
        } else if (avroType.equals((Object)Schema.Type.DOUBLE)) {
            this.recordConsumer.addDouble(((Number)value).doubleValue());
        } else if (avroType.equals((Object)Schema.Type.BYTES)) {
            this.recordConsumer.addBinary(Binary.fromByteBuffer((ByteBuffer)((ByteBuffer)value)));
        } else if (avroType.equals((Object)Schema.Type.STRING)) {
            this.recordConsumer.addBinary(this.fromAvroString(value));
        } else if (avroType.equals((Object)Schema.Type.RECORD)) {
            this.writeRecord((GroupType)type, nonNullAvroSchema, (IndexedRecord)value);
        } else if (avroType.equals((Object)Schema.Type.ENUM)) {
            this.recordConsumer.addBinary(Binary.fromString((String)value.toString()));
        } else if (avroType.equals((Object)Schema.Type.ARRAY)) {
            this.writeArray((GroupType)type, nonNullAvroSchema, (Iterable)value);
        } else if (avroType.equals((Object)Schema.Type.MAP)) {
            this.writeMap((GroupType)type, nonNullAvroSchema, (Map)value);
        } else if (avroType.equals((Object)Schema.Type.UNION)) {
            this.writeUnion((GroupType)type, nonNullAvroSchema, value);
        } else if (avroType.equals((Object)Schema.Type.FIXED)) {
            this.recordConsumer.addBinary(Binary.fromByteArray((byte[])((GenericFixed)value).bytes()));
        }
    }

    private Binary fromAvroString(Object value) {
        if (value instanceof Utf8) {
            Utf8 utf8 = (Utf8)value;
            return Binary.fromByteArray((byte[])utf8.getBytes(), (int)0, (int)utf8.getByteLength());
        }
        return Binary.fromString((String)value.toString());
    }
}

