/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk;

import com.unboundid.ldap.sdk.AsyncTimeoutTimerTask;
import com.unboundid.ldap.sdk.LDAPConnection;
import com.unboundid.ldap.sdk.LDAPMessages;
import com.unboundid.ldap.sdk.LDAPResult;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.util.Debug;
import com.unboundid.util.NotMutable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import java.io.Serializable;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class AsyncRequestID
implements Serializable,
Future<LDAPResult> {
    private static final long serialVersionUID = 8244005138437962030L;
    private final ArrayBlockingQueue<LDAPResult> resultQueue;
    private final AtomicBoolean cancelRequested;
    private final AtomicReference<LDAPResult> result;
    private final int messageID;
    private final LDAPConnection connection;
    private volatile AsyncTimeoutTimerTask timerTask;

    AsyncRequestID(int messageID, LDAPConnection connection) {
        this.messageID = messageID;
        this.connection = connection;
        this.resultQueue = new ArrayBlockingQueue(1);
        this.cancelRequested = new AtomicBoolean(false);
        this.result = new AtomicReference();
        this.timerTask = null;
    }

    public int getMessageID() {
        return this.messageID;
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        if (this.isDone()) {
            return false;
        }
        try {
            this.cancelRequested.set(true);
            this.result.compareAndSet(null, new LDAPResult(this.messageID, ResultCode.USER_CANCELED, LDAPMessages.INFO_ASYNC_REQUEST_USER_CANCELED.get(), null, StaticUtils.NO_STRINGS, StaticUtils.NO_CONTROLS));
            this.connection.abandon(this);
        }
        catch (Exception e) {
            Debug.debugException(e);
        }
        return true;
    }

    @Override
    public boolean isCancelled() {
        return this.cancelRequested.get();
    }

    @Override
    public boolean isDone() {
        if (this.cancelRequested.get()) {
            return true;
        }
        if (this.result.get() != null) {
            return true;
        }
        LDAPResult newResult = this.resultQueue.poll();
        if (newResult != null) {
            this.result.set(newResult);
            return true;
        }
        return false;
    }

    @Override
    public LDAPResult get() throws InterruptedException {
        long maxWaitTime = this.connection.getConnectionOptions().getResponseTimeoutMillis();
        try {
            return this.get(maxWaitTime, TimeUnit.MILLISECONDS);
        }
        catch (TimeoutException te) {
            Debug.debugException(te);
            return new LDAPResult(this.messageID, ResultCode.TIMEOUT, te.getMessage(), null, StaticUtils.NO_STRINGS, StaticUtils.NO_CONTROLS);
        }
    }

    @Override
    public LDAPResult get(long timeout, TimeUnit timeUnit) throws InterruptedException, TimeoutException {
        LDAPResult newResult = this.resultQueue.poll();
        if (newResult != null) {
            this.result.set(newResult);
            return newResult;
        }
        LDAPResult previousResult = this.result.get();
        if (previousResult != null) {
            return previousResult;
        }
        LDAPResult resultAfterWaiting = this.resultQueue.poll(timeout, timeUnit);
        if (resultAfterWaiting == null) {
            long timeoutMillis = timeUnit.toMillis(timeout);
            throw new TimeoutException(LDAPMessages.WARN_ASYNC_REQUEST_GET_TIMEOUT.get(timeoutMillis));
        }
        this.result.set(resultAfterWaiting);
        return resultAfterWaiting;
    }

    void setTimerTask(AsyncTimeoutTimerTask timerTask) {
        this.timerTask = timerTask;
    }

    void setResult(LDAPResult result) {
        this.resultQueue.offer(result);
        AsyncTimeoutTimerTask t = this.timerTask;
        if (t != null) {
            t.cancel();
            this.connection.getTimer().purge();
            this.timerTask = null;
        }
    }

    public int hashCode() {
        return this.messageID;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o == this) {
            return true;
        }
        if (o instanceof AsyncRequestID) {
            return ((AsyncRequestID)o).messageID == this.messageID;
        }
        return false;
    }

    public String toString() {
        return "AsyncRequestID(messageID=" + this.messageID + ')';
    }
}

