/*
 * Decompiled with CFR 0.152.
 */
package com.vladmihalcea.flexypool.adaptor;

import com.vladmihalcea.flexypool.adaptor.AbstractPoolAdapter;
import com.vladmihalcea.flexypool.adaptor.PoolAdapter;
import com.vladmihalcea.flexypool.adaptor.PoolAdapterFactory;
import com.vladmihalcea.flexypool.common.ConfigurationProperties;
import com.vladmihalcea.flexypool.metric.Metrics;
import com.zaxxer.hikari.HikariDataSource;
import java.sql.SQLTimeoutException;
import java.sql.SQLTransientConnectionException;
import java.util.regex.Pattern;

public class HikariCPPoolAdapter
extends AbstractPoolAdapter<HikariDataSource> {
    public static final String SQL_TRANSIENT_CONNECTION_EXCEPTION_CLASS_NAME = SQLTransientConnectionException.class.getName();
    public static final String ACQUISITION_TIMEOUT_MESSAGE = "Timeout of .*?ms encountered waiting for connection\\.";
    public static final PoolAdapterFactory<HikariDataSource> FACTORY = new PoolAdapterFactory<HikariDataSource>(){

        public PoolAdapter<HikariDataSource> newInstance(ConfigurationProperties<HikariDataSource, Metrics, PoolAdapter<HikariDataSource>> configurationProperties) {
            return new HikariCPPoolAdapter(configurationProperties);
        }
    };

    public HikariCPPoolAdapter(ConfigurationProperties<HikariDataSource, Metrics, PoolAdapter<HikariDataSource>> configurationProperties) {
        super(configurationProperties);
    }

    public int getMaxPoolSize() {
        return ((HikariDataSource)this.getTargetDataSource()).getMaximumPoolSize();
    }

    public void setMaxPoolSize(int maxPoolSize) {
        ((HikariDataSource)this.getTargetDataSource()).setMaximumPoolSize(maxPoolSize);
    }

    protected boolean isTimeoutAcquisitionException(Exception e) {
        return e instanceof SQLTimeoutException || SQL_TRANSIENT_CONNECTION_EXCEPTION_CLASS_NAME.equals(e.getClass().getName()) || e.getMessage() != null && Pattern.matches(ACQUISITION_TIMEOUT_MESSAGE, e.getMessage());
    }
}

