/*
 * Decompiled with CFR 0.152.
 */
package com.schooner.MemCached;

import java.io.UnsupportedEncodingException;
import java.util.Date;

public class NativeHandler {
    public static final boolean isHandled(Object object) {
        return object instanceof Byte || object instanceof Boolean || object instanceof Integer || object instanceof Long || object instanceof Character || object instanceof String || object instanceof StringBuffer || object instanceof Float || object instanceof Short || object instanceof Double || object instanceof Date || object instanceof StringBuilder || object instanceof byte[];
    }

    public static final boolean isHandled(int n) {
        return (n & 1) == 1 || (n & 0x2000) == 8192 || (n & 4) == 4 || (n & 0x4000) == 16384 || (n & 0x10) == 16 || (n & 0x20) == 32 || (n & 0x40) == 64 || (n & 0x80) == 128 || (n & 0x100) == 256 || (n & 0x200) == 512 || (n & 0x400) == 1024 || (n & 0x800) == 2048 || (n & 0x1000) == 4096;
    }

    public static final int getMarkerFlag(Object object) {
        if (object instanceof Byte) {
            return 1;
        }
        if (object instanceof Boolean) {
            return 8192;
        }
        if (object instanceof Integer) {
            return 4;
        }
        if (object instanceof Long) {
            return 16384;
        }
        if (object instanceof Character) {
            return 16;
        }
        if (object instanceof String) {
            return 32;
        }
        if (object instanceof StringBuffer) {
            return 64;
        }
        if (object instanceof Float) {
            return 128;
        }
        if (object instanceof Short) {
            return 256;
        }
        if (object instanceof Double) {
            return 512;
        }
        if (object instanceof Date) {
            return 1024;
        }
        if (object instanceof StringBuilder) {
            return 2048;
        }
        if (object instanceof byte[]) {
            return 4096;
        }
        return 0;
    }

    public static byte[] encode(Object object) throws UnsupportedEncodingException {
        if (object instanceof Byte) {
            return NativeHandler.encode((Byte)object);
        }
        if (object instanceof Boolean) {
            return NativeHandler.encode((Boolean)object);
        }
        if (object instanceof Integer) {
            return NativeHandler.encode((Integer)object);
        }
        if (object instanceof Long) {
            return NativeHandler.encode((Long)object);
        }
        if (object instanceof Character) {
            return NativeHandler.encode((Character)object);
        }
        if (object instanceof String) {
            return NativeHandler.encode((String)object);
        }
        if (object instanceof StringBuffer) {
            return NativeHandler.encode((StringBuffer)object);
        }
        if (object instanceof Float) {
            return NativeHandler.encode(((Float)object).floatValue());
        }
        if (object instanceof Short) {
            return NativeHandler.encode((Short)object);
        }
        if (object instanceof Double) {
            return NativeHandler.encode((Double)object);
        }
        if (object instanceof Date) {
            return NativeHandler.encode((Date)object);
        }
        if (object instanceof StringBuilder) {
            return NativeHandler.encode((StringBuilder)object);
        }
        if (object instanceof byte[]) {
            return NativeHandler.encode((byte[])object);
        }
        return null;
    }

    protected static byte[] encode(Byte by) {
        byte[] byArray = new byte[]{by};
        return byArray;
    }

    protected static byte[] encode(Boolean bl) {
        byte[] byArray = new byte[]{bl != false ? (byte)1 : 0};
        return byArray;
    }

    protected static byte[] encode(int n) {
        return NativeHandler.getBytes(n);
    }

    protected static byte[] encode(long l) throws UnsupportedEncodingException {
        return NativeHandler.getBytes(l);
    }

    protected static byte[] encode(Date date) {
        return NativeHandler.getBytes(date.getTime());
    }

    protected static byte[] encode(Character c) {
        return NativeHandler.encode((int)c.charValue());
    }

    protected static byte[] encode(String string) throws UnsupportedEncodingException {
        return string.getBytes("UTF-8");
    }

    protected static byte[] encode(StringBuffer stringBuffer) throws UnsupportedEncodingException {
        return NativeHandler.encode(stringBuffer.toString());
    }

    protected static byte[] encode(float f) throws UnsupportedEncodingException {
        return NativeHandler.encode(Float.floatToIntBits(f));
    }

    protected static byte[] encode(Short s) throws UnsupportedEncodingException {
        return NativeHandler.encode((int)s.shortValue());
    }

    protected static byte[] encode(double d) throws UnsupportedEncodingException {
        return NativeHandler.encode(Double.doubleToLongBits(d));
    }

    protected static byte[] encode(StringBuilder stringBuilder) throws UnsupportedEncodingException {
        return NativeHandler.encode(stringBuilder.toString());
    }

    protected static byte[] encode(byte[] byArray) {
        return byArray;
    }

    protected static byte[] getBytes(long l) {
        byte[] byArray = new byte[]{(byte)(l >> 56 & 0xFFL), (byte)(l >> 48 & 0xFFL), (byte)(l >> 40 & 0xFFL), (byte)(l >> 32 & 0xFFL), (byte)(l >> 24 & 0xFFL), (byte)(l >> 16 & 0xFFL), (byte)(l >> 8 & 0xFFL), (byte)(l >> 0 & 0xFFL)};
        return byArray;
    }

    protected static byte[] getBytes(int n) {
        byte[] byArray = new byte[]{(byte)(n >> 24 & 0xFF), (byte)(n >> 16 & 0xFF), (byte)(n >> 8 & 0xFF), (byte)(n >> 0 & 0xFF)};
        return byArray;
    }

    public static Object decode(byte[] byArray, int n) throws UnsupportedEncodingException {
        if (byArray.length < 1) {
            return null;
        }
        if ((n & 1) == 1) {
            return NativeHandler.decodeByte(byArray);
        }
        if ((n & 0x2000) == 8192) {
            return NativeHandler.decodeBoolean(byArray);
        }
        if ((n & 4) == 4) {
            return NativeHandler.decodeInteger(byArray);
        }
        if ((n & 0x4000) == 16384) {
            return NativeHandler.decodeLong(byArray);
        }
        if ((n & 0x10) == 16) {
            return NativeHandler.decodeCharacter(byArray);
        }
        if ((n & 0x20) == 32) {
            return NativeHandler.decodeString(byArray);
        }
        if ((n & 0x40) == 64) {
            return NativeHandler.decodeStringBuffer(byArray);
        }
        if ((n & 0x80) == 128) {
            return NativeHandler.decodeFloat(byArray);
        }
        if ((n & 0x100) == 256) {
            return NativeHandler.decodeShort(byArray);
        }
        if ((n & 0x200) == 512) {
            return NativeHandler.decodeDouble(byArray);
        }
        if ((n & 0x400) == 1024) {
            return NativeHandler.decodeDate(byArray);
        }
        if ((n & 0x800) == 2048) {
            return NativeHandler.decodeStringBuilder(byArray);
        }
        if ((n & 0x1000) == 4096) {
            return NativeHandler.decodeByteArr(byArray);
        }
        return null;
    }

    protected static Byte decodeByte(byte[] byArray) {
        return new Byte(byArray[0]);
    }

    protected static Boolean decodeBoolean(byte[] byArray) {
        boolean bl = byArray[0] == 1;
        return bl ? Boolean.TRUE : Boolean.FALSE;
    }

    protected static Integer decodeInteger(byte[] byArray) {
        return new Integer(NativeHandler.toInt(byArray));
    }

    protected static Long decodeLong(byte[] byArray) throws UnsupportedEncodingException {
        return new Long(NativeHandler.toLong(byArray));
    }

    protected static Character decodeCharacter(byte[] byArray) {
        return new Character((char)NativeHandler.decodeInteger(byArray).intValue());
    }

    protected static String decodeString(byte[] byArray) throws UnsupportedEncodingException {
        return new String(byArray, "UTF-8");
    }

    protected static StringBuffer decodeStringBuffer(byte[] byArray) throws UnsupportedEncodingException {
        return new StringBuffer(NativeHandler.decodeString(byArray));
    }

    protected static Float decodeFloat(byte[] byArray) throws UnsupportedEncodingException {
        Integer n = NativeHandler.decodeInteger(byArray);
        return new Float(Float.intBitsToFloat(n));
    }

    protected static Short decodeShort(byte[] byArray) throws UnsupportedEncodingException {
        return new Short((short)NativeHandler.decodeInteger(byArray).intValue());
    }

    protected static Double decodeDouble(byte[] byArray) throws UnsupportedEncodingException {
        Long l = NativeHandler.decodeLong(byArray);
        return new Double(Double.longBitsToDouble(l));
    }

    protected static Date decodeDate(byte[] byArray) {
        return new Date(NativeHandler.toLong(byArray));
    }

    protected static StringBuilder decodeStringBuilder(byte[] byArray) throws UnsupportedEncodingException {
        return new StringBuilder(NativeHandler.decodeString(byArray));
    }

    protected static byte[] decodeByteArr(byte[] byArray) {
        return byArray;
    }

    protected static int toInt(byte[] byArray) {
        return ((byArray[3] & 0xFF) << 32) + ((byArray[2] & 0xFF) << 40) + ((byArray[1] & 0xFF) << 48) + ((byArray[0] & 0xFF) << 56);
    }

    protected static long toLong(byte[] byArray) {
        return ((long)byArray[7] & 0xFFL) + (((long)byArray[6] & 0xFFL) << 8) + (((long)byArray[5] & 0xFFL) << 16) + (((long)byArray[4] & 0xFFL) << 24) + (((long)byArray[3] & 0xFFL) << 32) + (((long)byArray[2] & 0xFFL) << 40) + (((long)byArray[1] & 0xFFL) << 48) + (((long)byArray[0] & 0xFFL) << 56);
    }
}

