/*
 * Decompiled with CFR 0.152.
 */
package com.wordnik.swagger.models.properties;

import com.wordnik.swagger.models.properties.AbstractProperty;
import com.wordnik.swagger.models.properties.BooleanProperty;
import com.wordnik.swagger.models.properties.DateProperty;
import com.wordnik.swagger.models.properties.DateTimeProperty;
import com.wordnik.swagger.models.properties.DecimalProperty;
import com.wordnik.swagger.models.properties.DoubleProperty;
import com.wordnik.swagger.models.properties.EmailProperty;
import com.wordnik.swagger.models.properties.FileProperty;
import com.wordnik.swagger.models.properties.FloatProperty;
import com.wordnik.swagger.models.properties.IntegerProperty;
import com.wordnik.swagger.models.properties.LongProperty;
import com.wordnik.swagger.models.properties.ObjectProperty;
import com.wordnik.swagger.models.properties.Property;
import com.wordnik.swagger.models.properties.RefProperty;
import com.wordnik.swagger.models.properties.StringProperty;
import com.wordnik.swagger.models.properties.UUIDProperty;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertyBuilder {
    static Logger LOGGER = LoggerFactory.getLogger(PropertyBuilder.class);

    public static Property build(String type, String format, Map<String, Object> args) {
        if (args == null) {
            args = new HashMap<String, Object>();
        }
        List _enum = (List)args.get("enum");
        String title = (String)args.get("title");
        String description = (String)args.get("description");
        String _default = (String)args.get("default");
        String pattern = (String)args.get("pattern");
        String discriminator = (String)args.get("discriminator");
        Integer minItems = (Integer)args.get("minItems");
        Integer maxItems = (Integer)args.get("maxItems");
        Integer minProperties = (Integer)args.get("minProperties");
        Integer maxProperties = (Integer)args.get("maxProperties");
        Integer minLength = (Integer)args.get("minLength");
        Integer maxLength = (Integer)args.get("maxLength");
        Double minimum = (Double)args.get("minimum");
        Double maximum = (Double)args.get("maximum");
        Double exclusiveMinimum = (Double)args.get("exclusiveMinimum");
        Double exclusiveMaximum = (Double)args.get("exclusiveMaximum");
        Boolean uniqueItems = (Boolean)args.get("uniqueItems");
        AbstractProperty property = null;
        if (BooleanProperty.isType(type, format)) {
            property = new BooleanProperty();
        }
        if (DateProperty.isType(type, format)) {
            property = new DateProperty();
        }
        if (DateTimeProperty.isType(type, format)) {
            property = new DateTimeProperty();
        }
        if (DoubleProperty.isType(type, format)) {
            property = new DoubleProperty().minimum(minimum).maximum(maximum).exclusiveMinimum(exclusiveMinimum).exclusiveMaximum(exclusiveMinimum);
        }
        if (FloatProperty.isType(type, format)) {
            property = new FloatProperty().minimum(minimum).maximum(maximum).exclusiveMinimum(exclusiveMinimum).exclusiveMaximum(exclusiveMinimum);
        }
        if (FileProperty.isType(type, format)) {
            property = new FileProperty();
        }
        if (DecimalProperty.isType(type, format)) {
            property = new DecimalProperty().minimum(minimum).maximum(maximum).exclusiveMinimum(exclusiveMinimum).exclusiveMaximum(exclusiveMinimum);
        }
        if (IntegerProperty.isType(type, format)) {
            property = new IntegerProperty().minimum(minimum).maximum(maximum).exclusiveMinimum(exclusiveMinimum).exclusiveMaximum(exclusiveMinimum);
        }
        if (LongProperty.isType(type, format)) {
            property = new LongProperty().minimum(minimum).maximum(maximum).exclusiveMinimum(exclusiveMinimum).exclusiveMaximum(exclusiveMinimum);
        }
        if (RefProperty.isType(type, format)) {
            property = new RefProperty();
        }
        if (EmailProperty.isType(type, format)) {
            property = new EmailProperty().minLength(minLength).maxLength(maxLength).pattern(pattern)._enum(_enum);
        }
        if (StringProperty.isType(type, format)) {
            property = new StringProperty().minLength(minLength).maxLength(maxLength).pattern(pattern)._enum(_enum);
        }
        if (UUIDProperty.isType(type, format)) {
            property = new UUIDProperty().minLength(minLength).maxLength(maxLength).pattern(pattern);
        }
        if (property != null) {
            property.title(title).description(description);
            String example = (String)args.get("example");
            if (example != null) {
                property.setExample(example);
            }
        }
        if ("integer".equals(type) && format == null) {
            LOGGER.debug("no format specified for integer type, falling back to int32");
            property = new IntegerProperty().minimum(minimum).maximum(maximum).exclusiveMinimum(exclusiveMinimum).exclusiveMaximum(exclusiveMinimum);
        }
        if ("object".equals(type) && format == null) {
            LOGGER.debug("no format specified for object type, falling back to object");
            property = new ObjectProperty();
        }
        if (property == null) {
            LOGGER.debug("no property for " + type + ", " + format);
        }
        return property;
    }
}

