/*
 * Decompiled with CFR 0.152.
 */
package com.zaxxer.hikari.proxy;

import com.zaxxer.hikari.pool.HikariPool;
import com.zaxxer.hikari.pool.PoolBagEntry;
import com.zaxxer.hikari.proxy.IHikariConnectionProxy;
import com.zaxxer.hikari.proxy.ProxyFactory;
import com.zaxxer.hikari.util.FastList;
import com.zaxxer.hikari.util.LeakTask;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Wrapper;
import java.util.HashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ConnectionProxy
implements IHikariConnectionProxy {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConnectionProxy.class);
    private static final Set<String> SQL_ERRORS = new HashSet<String>();
    protected final Connection delegate;
    private final HikariPool parentPool;
    private final PoolBagEntry bagEntry;
    private final LeakTask leakTask;
    private FastList<Statement> openStatements;
    private boolean forceClose;
    private boolean isAnythingDirty;
    private boolean isAutoCommitDirty;
    private boolean isCatalogDirty;
    private boolean isClosed;
    private boolean isReadOnlyDirty;
    private boolean isTransactionIsolationDirty;

    protected ConnectionProxy(HikariPool pool, PoolBagEntry bagEntry, LeakTask leakTask) {
        this.parentPool = pool;
        this.bagEntry = bagEntry;
        this.delegate = bagEntry.connection;
        this.leakTask = leakTask;
        this.openStatements = new FastList(Statement.class, 16);
    }

    public String toString() {
        return String.format("%s(%s) wrapping %s", this.getClass().getSimpleName(), System.identityHashCode(this), this.delegate);
    }

    @Override
    public PoolBagEntry getPoolBagEntry() {
        return this.bagEntry;
    }

    @Override
    public final SQLException checkException(SQLException sqle) {
        String sqlState = sqle.getSQLState();
        if (sqlState != null) {
            this.forceClose |= sqlState.startsWith("08") | SQL_ERRORS.contains(sqlState);
            if (this.forceClose) {
                LOGGER.warn(String.format("Connection %s (%s) marked as broken because of SQLSTATE(%s), ErrorCode(%d).", this.delegate.toString(), this.parentPool.toString(), sqlState, sqle.getErrorCode()), (Throwable)sqle);
            } else if (sqle.getNextException() instanceof SQLException) {
                this.checkException(sqle.getNextException());
            }
        }
        return sqle;
    }

    @Override
    public final void untrackStatement(Statement statement) {
        if (!this.isClosed) {
            this.openStatements.remove(statement);
        }
    }

    protected final void checkClosed() throws SQLException {
        if (this.isClosed) {
            throw new SQLException("Connection is closed");
        }
    }

    private <T extends Statement> T trackStatement(T statement) {
        this.openStatements.add(statement);
        return statement;
    }

    private final void resetConnectionState() throws SQLException {
        if (this.isReadOnlyDirty) {
            this.delegate.setReadOnly(this.parentPool.isReadOnly);
        }
        if (this.isAutoCommitDirty) {
            this.delegate.setAutoCommit(this.parentPool.isAutoCommit);
        }
        if (this.isTransactionIsolationDirty) {
            this.delegate.setTransactionIsolation(this.parentPool.transactionIsolation);
        }
        if (this.isCatalogDirty && this.parentPool.catalog != null) {
            this.delegate.setCatalog(this.parentPool.catalog);
        }
    }

    @Override
    public final void close() throws SQLException {
        if (!this.isClosed) {
            this.isClosed = true;
            this.leakTask.cancel();
            int size = this.openStatements.size();
            if (size > 0) {
                for (int i = 0; i < size; ++i) {
                    try {
                        this.openStatements.get(i).close();
                        continue;
                    }
                    catch (SQLException e) {
                        this.checkException(e);
                    }
                }
            }
            try {
                if (!this.delegate.getAutoCommit()) {
                    this.delegate.rollback();
                }
                if (this.isAnythingDirty) {
                    this.resetConnectionState();
                }
                this.delegate.clearWarnings();
            }
            catch (SQLException e) {
                throw this.checkException(e);
            }
            finally {
                this.parentPool.releaseConnection(this.bagEntry, this.forceClose);
            }
        }
    }

    @Override
    public final boolean isClosed() throws SQLException {
        return this.isClosed;
    }

    @Override
    public final Statement createStatement() throws SQLException {
        this.checkClosed();
        try {
            Statement proxyStatement = ProxyFactory.getProxyStatement(this, this.delegate.createStatement());
            return this.trackStatement(proxyStatement);
        }
        catch (SQLException e) {
            throw this.checkException(e);
        }
    }

    @Override
    public final Statement createStatement(int resultSetType, int concurrency) throws SQLException {
        this.checkClosed();
        try {
            Statement proxyStatement = ProxyFactory.getProxyStatement(this, this.delegate.createStatement(resultSetType, concurrency));
            return this.trackStatement(proxyStatement);
        }
        catch (SQLException e) {
            throw this.checkException(e);
        }
    }

    @Override
    public final Statement createStatement(int resultSetType, int concurrency, int holdability) throws SQLException {
        this.checkClosed();
        try {
            Statement proxyStatement = ProxyFactory.getProxyStatement(this, this.delegate.createStatement(resultSetType, concurrency, holdability));
            return this.trackStatement(proxyStatement);
        }
        catch (SQLException e) {
            throw this.checkException(e);
        }
    }

    @Override
    public final CallableStatement prepareCall(String sql) throws SQLException {
        this.checkClosed();
        try {
            CallableStatement pcs = ProxyFactory.getProxyCallableStatement(this, this.delegate.prepareCall(sql));
            return this.trackStatement(pcs);
        }
        catch (SQLException e) {
            throw this.checkException(e);
        }
    }

    @Override
    public final CallableStatement prepareCall(String sql, int resultSetType, int concurrency) throws SQLException {
        this.checkClosed();
        try {
            CallableStatement pcs = ProxyFactory.getProxyCallableStatement(this, this.delegate.prepareCall(sql, resultSetType, concurrency));
            return this.trackStatement(pcs);
        }
        catch (SQLException e) {
            throw this.checkException(e);
        }
    }

    @Override
    public final CallableStatement prepareCall(String sql, int resultSetType, int concurrency, int holdability) throws SQLException {
        this.checkClosed();
        try {
            CallableStatement pcs = ProxyFactory.getProxyCallableStatement(this, this.delegate.prepareCall(sql, resultSetType, concurrency, holdability));
            return this.trackStatement(pcs);
        }
        catch (SQLException e) {
            throw this.checkException(e);
        }
    }

    @Override
    public final PreparedStatement prepareStatement(String sql) throws SQLException {
        this.checkClosed();
        try {
            PreparedStatement proxyPreparedStatement = ProxyFactory.getProxyPreparedStatement(this, this.delegate.prepareStatement(sql));
            return this.trackStatement(proxyPreparedStatement);
        }
        catch (SQLException e) {
            throw this.checkException(e);
        }
    }

    @Override
    public final PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        this.checkClosed();
        try {
            PreparedStatement proxyPreparedStatement = ProxyFactory.getProxyPreparedStatement(this, this.delegate.prepareStatement(sql, autoGeneratedKeys));
            return this.trackStatement(proxyPreparedStatement);
        }
        catch (SQLException e) {
            throw this.checkException(e);
        }
    }

    @Override
    public final PreparedStatement prepareStatement(String sql, int resultSetType, int concurrency) throws SQLException {
        this.checkClosed();
        try {
            PreparedStatement proxyPreparedStatement = ProxyFactory.getProxyPreparedStatement(this, this.delegate.prepareStatement(sql, resultSetType, concurrency));
            return this.trackStatement(proxyPreparedStatement);
        }
        catch (SQLException e) {
            throw this.checkException(e);
        }
    }

    @Override
    public final PreparedStatement prepareStatement(String sql, int resultSetType, int concurrency, int holdability) throws SQLException {
        this.checkClosed();
        try {
            PreparedStatement proxyPreparedStatement = ProxyFactory.getProxyPreparedStatement(this, this.delegate.prepareStatement(sql, resultSetType, concurrency, holdability));
            return this.trackStatement(proxyPreparedStatement);
        }
        catch (SQLException e) {
            throw this.checkException(e);
        }
    }

    @Override
    public final PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        this.checkClosed();
        try {
            PreparedStatement proxyPreparedStatement = ProxyFactory.getProxyPreparedStatement(this, this.delegate.prepareStatement(sql, columnIndexes));
            return this.trackStatement(proxyPreparedStatement);
        }
        catch (SQLException e) {
            throw this.checkException(e);
        }
    }

    @Override
    public final PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        this.checkClosed();
        try {
            PreparedStatement proxyPreparedStatement = ProxyFactory.getProxyPreparedStatement(this, this.delegate.prepareStatement(sql, columnNames));
            return this.trackStatement(proxyPreparedStatement);
        }
        catch (SQLException e) {
            throw this.checkException(e);
        }
    }

    @Override
    public final boolean isValid(int timeout) throws SQLException {
        if (this.isClosed) {
            return false;
        }
        try {
            return this.delegate.isValid(timeout);
        }
        catch (SQLException e) {
            throw this.checkException(e);
        }
    }

    @Override
    public final void setAutoCommit(boolean autoCommit) throws SQLException {
        this.checkClosed();
        try {
            this.delegate.setAutoCommit(autoCommit);
            this.isAnythingDirty = true;
            this.isAutoCommitDirty = autoCommit != this.parentPool.isAutoCommit;
        }
        catch (SQLException e) {
            throw this.checkException(e);
        }
    }

    @Override
    public final void setReadOnly(boolean readOnly) throws SQLException {
        this.checkClosed();
        try {
            this.delegate.setReadOnly(readOnly);
            this.isAnythingDirty = true;
            this.isReadOnlyDirty = readOnly != this.parentPool.isReadOnly;
        }
        catch (SQLException e) {
            throw this.checkException(e);
        }
    }

    @Override
    public final void setTransactionIsolation(int level) throws SQLException {
        this.checkClosed();
        try {
            this.delegate.setTransactionIsolation(level);
            this.isAnythingDirty = true;
            this.isTransactionIsolationDirty = level != this.parentPool.transactionIsolation;
        }
        catch (SQLException e) {
            throw this.checkException(e);
        }
    }

    @Override
    public final void setCatalog(String catalog) throws SQLException {
        this.checkClosed();
        try {
            this.delegate.setCatalog(catalog);
            this.isAnythingDirty = true;
            this.isCatalogDirty = catalog != null && !catalog.equals(this.parentPool.catalog) || catalog == null && this.parentPool.catalog != null;
        }
        catch (SQLException e) {
            throw this.checkException(e);
        }
    }

    @Override
    public final boolean isWrapperFor(Class<?> iface) throws SQLException {
        return iface.isInstance(this.delegate) || this.delegate instanceof Wrapper && this.delegate.isWrapperFor(iface);
    }

    @Override
    public final <T> T unwrap(Class<T> iface) throws SQLException {
        if (iface.isInstance(this.delegate)) {
            return (T)this.delegate;
        }
        if (this.delegate instanceof Wrapper) {
            return this.delegate.unwrap(iface);
        }
        throw new SQLException("Wrapped connection is not an instance of " + iface);
    }

    static {
        SQL_ERRORS.add("57P01");
        SQL_ERRORS.add("57P02");
        SQL_ERRORS.add("57P03");
        SQL_ERRORS.add("01002");
        SQL_ERRORS.add("JZ0C0");
        SQL_ERRORS.add("JZ0C1");
    }
}

