/*
 * Decompiled with CFR 0.152.
 */
package com.zaxxer.hikari.proxy;

import com.zaxxer.hikari.proxy.CallableStatementProxy;
import com.zaxxer.hikari.proxy.ConnectionProxy;
import com.zaxxer.hikari.proxy.PreparedStatementProxy;
import com.zaxxer.hikari.proxy.ResultSetProxy;
import com.zaxxer.hikari.proxy.StatementProxy;
import com.zaxxer.hikari.util.ClassLoaderUtils;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.HashSet;
import java.util.Set;
import javassist.ClassPath;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtMethod;
import javassist.CtNewMethod;
import javassist.LoaderClassPath;
import javassist.NotFoundException;

public final class JavassistProxyFactory {
    private ClassPool classPool = new ClassPool();

    public static void initialize() {
    }

    private JavassistProxyFactory() throws Exception {
        this.classPool.importPackage("java.sql");
        this.classPool.appendClassPath((ClassPath)new LoaderClassPath(this.getClass().getClassLoader()));
        String methodBody = "{ checkClosed(); try { return delegate.method($$); } catch (SQLException e) { throw checkException(e); } }";
        this.generateProxyClass(Connection.class, ConnectionProxy.class, methodBody);
        methodBody = "{ try { return delegate.method($$); } catch (SQLException e) { throw checkException(e); } }";
        this.generateProxyClass(Statement.class, StatementProxy.class, methodBody);
        this.generateProxyClass(ResultSet.class, ResultSetProxy.class, methodBody);
        methodBody = "{ try { return ((cast) delegate).method($$); } catch (SQLException e) { throw checkException(e); } }";
        this.generateProxyClass(PreparedStatement.class, PreparedStatementProxy.class, methodBody);
        this.generateProxyClass(CallableStatement.class, CallableStatementProxy.class, methodBody);
    }

    private void modifyProxyFactory() throws Exception {
        String packageName = JavassistProxyFactory.class.getPackage().getName();
        CtClass proxyCt = this.classPool.getCtClass("com.zaxxer.hikari.proxy.ProxyFactory");
        block14: for (CtMethod method : proxyCt.getMethods()) {
            switch (method.getName()) {
                case "getProxyConnection": {
                    method.setBody("{return new " + packageName + ".ConnectionJavassistProxy($$);}");
                    continue block14;
                }
                case "getProxyStatement": {
                    method.setBody("{return new " + packageName + ".StatementJavassistProxy($$);}");
                    continue block14;
                }
                case "getProxyPreparedStatement": {
                    method.setBody("{return new " + packageName + ".PreparedStatementJavassistProxy($$);}");
                    continue block14;
                }
                case "getProxyCallableStatement": {
                    method.setBody("{return new " + packageName + ".CallableStatementJavassistProxy($$);}");
                    continue block14;
                }
                case "getProxyResultSet": {
                    method.setBody("{return new " + packageName + ".ResultSetJavassistProxy($$);}");
                }
            }
        }
        proxyCt.toClass(this.classPool.getClassLoader(), this.getClass().getProtectionDomain());
    }

    private <T> Class<T> generateProxyClass(Class<T> primaryInterface, Class<?> superClass, String methodBody) throws Exception {
        String superClassName = superClass.getName();
        CtClass superClassCt = this.classPool.getCtClass(superClassName);
        CtClass targetCt = this.classPool.makeClass(superClassName.replace("Proxy", "JavassistProxy"), superClassCt);
        targetCt.setModifiers(16);
        HashSet<String> superSigs = new HashSet<String>();
        for (CtMethod method : superClassCt.getMethods()) {
            if ((method.getModifiers() & 0x10) != 16) continue;
            superSigs.add(method.getName() + method.getSignature());
        }
        HashSet<String> methods = new HashSet<String>();
        Set<Class<?>> interfaces = ClassLoaderUtils.getAllInterfaces(primaryInterface);
        for (Class<?> intf : interfaces) {
            CtClass intfCt = this.classPool.getCtClass(intf.getName());
            targetCt.addInterface(intfCt);
            for (CtMethod intfMethod : intfCt.getDeclaredMethods()) {
                String signature = intfMethod.getName() + intfMethod.getSignature();
                if (superSigs.contains(signature) || methods.contains(signature)) continue;
                methods.add(signature);
                CtMethod method = CtNewMethod.copy((CtMethod)intfMethod, (CtClass)targetCt, null);
                String modifiedBody = methodBody;
                CtMethod superMethod = superClassCt.getMethod(intfMethod.getName(), intfMethod.getSignature());
                if ((superMethod.getModifiers() & 0x400) != 1024) {
                    modifiedBody = modifiedBody.replace("((cast) ", "");
                    modifiedBody = modifiedBody.replace("delegate", "super");
                    modifiedBody = modifiedBody.replace("super)", "super");
                }
                modifiedBody = modifiedBody.replace("cast", primaryInterface.getName());
                modifiedBody = this.isThrowsSqlException(intfMethod) ? modifiedBody.replace("method", method.getName()) : "{ return ((cast) delegate).method($$); }".replace("method", method.getName()).replace("cast", primaryInterface.getName());
                if (method.getReturnType() == CtClass.voidType) {
                    modifiedBody = modifiedBody.replace("return", "");
                }
                method.setBody(modifiedBody);
                targetCt.addMethod(method);
            }
        }
        return targetCt.toClass(this.classPool.getClassLoader(), this.getClass().getProtectionDomain());
    }

    private boolean isThrowsSqlException(CtMethod method) {
        try {
            for (CtClass clazz : method.getExceptionTypes()) {
                if (!clazz.getSimpleName().equals("SQLException")) continue;
                return true;
            }
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        return false;
    }

    static {
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(JavassistProxyFactory.class.getClassLoader());
            JavassistProxyFactory proxyFactoryFactory = new JavassistProxyFactory();
            proxyFactoryFactory.modifyProxyFactory();
        }
        catch (Exception e) {
            throw new RuntimeException("Fatal exception during proxy generation", e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(contextClassLoader);
        }
    }
}

