/*
 * Decompiled with CFR 0.152.
 */
package cucumber.table.xstream;

import cucumber.runtime.xstream.converters.ErrorWriter;
import cucumber.runtime.xstream.io.AbstractReader;
import java.util.Iterator;
import java.util.List;

public class ListOfListOfSingleValueReader
extends AbstractReader {
    private int depth = 0;
    private Iterator<List<String>> rowIterator;
    private Iterator<String> cellIterator;
    private String cell;
    private final Class elementType;

    public ListOfListOfSingleValueReader(Class elementType, List<List<String>> rows) {
        this.elementType = elementType;
        this.rowIterator = rows.iterator();
    }

    @Override
    public boolean hasMoreChildren() {
        switch (this.depth) {
            case 0: {
                return this.rowIterator.hasNext();
            }
            case 1: {
                return this.cellIterator.hasNext();
            }
            case 2: {
                return false;
            }
        }
        throw new IllegalStateException("Depth is " + this.depth);
    }

    @Override
    public void moveDown() {
        ++this.depth;
        switch (this.depth) {
            case 1: {
                this.cellIterator = this.rowIterator.next().iterator();
                break;
            }
            case 2: {
                this.cell = this.cellIterator.next();
                break;
            }
            default: {
                throw new IllegalStateException("Depth is " + this.depth);
            }
        }
    }

    @Override
    public void moveUp() {
        --this.depth;
    }

    @Override
    public String getNodeName() {
        switch (this.depth) {
            case 0: 
            case 1: {
                return "list";
            }
            case 2: {
                return this.elementType.getName();
            }
        }
        throw new IllegalStateException("Depth is " + this.depth);
    }

    @Override
    public String getValue() {
        return this.cell;
    }

    @Override
    public String getAttribute(String name) {
        return null;
    }

    @Override
    public String getAttribute(int index) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getAttributeCount() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getAttributeName(int index) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Iterator getAttributeNames() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void appendErrors(ErrorWriter errorWriter) {
    }

    @Override
    public void close() {
        throw new UnsupportedOperationException();
    }
}

