/*
 * Decompiled with CFR 0.152.
 */
package cucumber.runtime.java;

import cucumber.runtime.CucumberException;
import cucumber.runtime.HookDefinition;
import cucumber.runtime.MethodFormat;
import cucumber.runtime.ScenarioResult;
import cucumber.runtime.Utils;
import cucumber.runtime.java.ObjectFactory;
import gherkin.TagExpression;
import gherkin.formatter.model.Tag;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;

public class JavaHookDefinition
implements HookDefinition {
    private final Method method;
    private final int timeout;
    private final TagExpression tagExpression;
    private final int order;
    private final ObjectFactory objectFactory;

    public JavaHookDefinition(Method method, String[] tagExpressions, int order, int timeout, ObjectFactory objectFactory) {
        this.method = method;
        this.timeout = timeout;
        this.tagExpression = new TagExpression(Arrays.asList(tagExpressions));
        this.order = order;
        this.objectFactory = objectFactory;
    }

    Method getMethod() {
        return this.method;
    }

    public String getLocation(boolean detail) {
        MethodFormat format = detail ? MethodFormat.FULL : MethodFormat.SHORT;
        return format.format(this.method);
    }

    public void execute(ScenarioResult scenarioResult) throws Throwable {
        Object[] args;
        switch (this.method.getParameterTypes().length) {
            case 0: {
                args = new Object[]{};
                break;
            }
            case 1: {
                if (!ScenarioResult.class.equals(this.method.getParameterTypes()[0])) {
                    throw new CucumberException("When a hook declares an argument it must be of type " + ScenarioResult.class.getName() + ". " + this.method.toString());
                }
                args = new Object[]{scenarioResult};
                break;
            }
            default: {
                throw new CucumberException("Hooks must declare 0 or 1 arguments. " + this.method.toString());
            }
        }
        Utils.invoke(this.objectFactory.getInstance(this.method.getDeclaringClass()), (Method)this.method, (int)this.timeout, (Object[])args);
    }

    public boolean matches(Collection<Tag> tags) {
        return this.tagExpression.eval(tags);
    }

    public int getOrder() {
        return this.order;
    }
}

