/*
 * Decompiled with CFR 0.152.
 */
package cucumber.runtime.java;

import cucumber.runtime.JdkPatternArgumentMatcher;
import cucumber.runtime.MethodFormat;
import cucumber.runtime.ParameterType;
import cucumber.runtime.StepDefinition;
import cucumber.runtime.Utils;
import cucumber.runtime.java.ObjectFactory;
import gherkin.I18n;
import gherkin.formatter.Argument;
import gherkin.formatter.model.Step;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.List;
import java.util.regex.Pattern;

class JavaStepDefinition
implements StepDefinition {
    private final Method method;
    private final Pattern pattern;
    private final int timeout;
    private final JdkPatternArgumentMatcher argumentMatcher;
    private final ObjectFactory objectFactory;
    private List<ParameterType> parameterTypes;

    public JavaStepDefinition(Method method, Pattern pattern, int timeout, ObjectFactory objectFactory) {
        this.method = method;
        this.parameterTypes = ParameterType.fromMethod((Method)method);
        this.pattern = pattern;
        this.argumentMatcher = new JdkPatternArgumentMatcher(pattern);
        this.timeout = timeout;
        this.objectFactory = objectFactory;
    }

    public void execute(I18n i18n, Object[] args) throws Throwable {
        Utils.invoke(this.objectFactory.getInstance(this.method.getDeclaringClass()), (Method)this.method, (int)this.timeout, (Object[])args);
    }

    public List<Argument> matchedArguments(Step step) {
        return this.argumentMatcher.argumentsFrom(step.getName());
    }

    public String getLocation(boolean detail) {
        MethodFormat format = detail ? MethodFormat.FULL : MethodFormat.SHORT;
        return format.format(this.method);
    }

    public Integer getParameterCount() {
        return this.parameterTypes.size();
    }

    public ParameterType getParameterType(int n, Type argumentType) {
        return this.parameterTypes.get(n);
    }

    public boolean isDefinedAt(StackTraceElement e) {
        return e.getClassName().equals(this.method.getDeclaringClass().getName()) && e.getMethodName().equals(this.method.getName());
    }

    public String getPattern() {
        return this.pattern.pattern();
    }
}

