/*
 * Decompiled with CFR 0.152.
 */
package gherkin.formatter;

import gherkin.formatter.Filter;
import gherkin.formatter.model.ExamplesTableRow;
import gherkin.formatter.model.Range;
import gherkin.formatter.model.Tag;
import java.util.ArrayList;
import java.util.List;

public class LineFilter
implements Filter {
    private final List<Integer> lines;

    public LineFilter(List<Integer> lines) {
        this.lines = this.toIntegers(lines);
    }

    private List<Integer> toIntegers(List<?> lines) {
        ArrayList<Integer> result = new ArrayList<Integer>(lines.size());
        for (Object line : lines) {
            if (line instanceof Number) {
                result.add(((Number)line).intValue());
                continue;
            }
            throw new IllegalArgumentException("Not a list of numbers: " + lines);
        }
        return result;
    }

    @Override
    public boolean eval(List<Tag> tags, List<String> names, List<Range> ranges) {
        for (Range range : ranges) {
            if (range == null) continue;
            for (Integer line : this.lines) {
                if (!range.isInclude(line)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public List<ExamplesTableRow> filterTableBodyRows(List<ExamplesTableRow> exampleRows) {
        ArrayList<ExamplesTableRow> result = new ArrayList<ExamplesTableRow>();
        for (ExamplesTableRow row : exampleRows) {
            if (result.isEmpty()) {
                result.add(row);
                continue;
            }
            for (Integer line : this.lines) {
                if (!row.getLine().equals(line)) continue;
                result.add(row);
            }
        }
        return result;
    }
}

