/*
 * Decompiled with CFR 0.152.
 */
package io.activej.async;

import io.activej.async.function.AsyncFunction;
import io.activej.common.function.FunctionEx;
import io.activej.promise.Promise;
import io.activej.promise.SettablePromise;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;

public final class AsyncBuffer<A, R> {
    private final AsyncFunction<A, R> executor;
    private final Supplier<A> bufferSupplier;
    private int activeCalls;
    private A buffer;
    private SettablePromise<R> bufferedPromise;

    public AsyncBuffer(AsyncFunction<A, R> executor, Supplier<A> bufferSupplier) {
        this.executor = executor;
        this.bufferSupplier = bufferSupplier;
    }

    public <V> Promise<R> add(BiConsumer<A, V> argumentAccumulator, V argument) {
        if (this.bufferedPromise == null) {
            this.buffer = this.bufferSupplier.get();
            this.bufferedPromise = new SettablePromise();
        }
        argumentAccumulator.accept(this.buffer, argument);
        return this.bufferedPromise;
    }

    public <V, T> Promise<T> add(BiConsumer<A, V> argumentAccumulator, FunctionEx<R, T> resultExtractor, V argument) {
        return this.add(argumentAccumulator, argument).map(resultExtractor);
    }

    public Promise<Void> flush() {
        if (this.bufferedPromise == null) {
            return Promise.complete();
        }
        A buffer = this.buffer;
        SettablePromise<R> bufferedPromise = this.bufferedPromise;
        this.buffer = null;
        this.bufferedPromise = null;
        ++this.activeCalls;
        return this.executor.apply(buffer).whenComplete((v, e) -> {
            --this.activeCalls;
            bufferedPromise.trySet((R)v, (Exception)e);
        }).toVoid();
    }

    public boolean isActive() {
        return this.activeCalls != 0;
    }

    public int getActiveCalls() {
        return this.activeCalls;
    }

    public boolean isBuffered() {
        return this.bufferedPromise != null;
    }

    public A getBuffer() {
        return this.buffer;
    }

    public Promise<R> getBufferedPromise() {
        return this.bufferedPromise;
    }

    public void cancelBufferedPromise(@NotNull Exception e) {
        if (this.bufferedPromise != null) {
            SettablePromise<R> bufferedPromise = this.bufferedPromise;
            this.bufferedPromise = null;
            this.buffer = null;
            bufferedPromise.trySetException(e);
        }
    }
}

