/*
 * Decompiled with CFR 0.152.
 */
package io.activej.async.function;

import io.activej.common.exception.FatalErrorHandlers;
import io.activej.common.function.BiFunctionEx;
import io.activej.promise.Promise;
import org.jetbrains.annotations.NotNull;

@FunctionalInterface
public interface AsyncBiFunction<T, U, R> {
    public Promise<R> apply(T var1, U var2);

    @NotNull
    public static <T, U, R> AsyncBiFunction<T, U, R> of(@NotNull BiFunctionEx<? super T, ? super U, ? extends R> function) {
        return (t, u) -> {
            try {
                return Promise.of(function.apply(t, u));
            }
            catch (Exception e) {
                FatalErrorHandlers.handleError((Throwable)e, (Object)function);
                return Promise.ofException(e);
            }
        };
    }
}

