/*
 * Decompiled with CFR 0.152.
 */
package io.activej.async.function;

import io.activej.async.function.AsyncBiFunction;
import io.activej.async.process.AsyncExecutor;
import io.activej.async.process.AsyncExecutors;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public final class AsyncBiFunctions {
    @Contract(pure=true)
    @NotNull
    public static <T, U, R> AsyncBiFunction<T, U, R> buffer(@NotNull AsyncBiFunction<T, U, R> actual) {
        return AsyncBiFunctions.buffer(1, Integer.MAX_VALUE, actual);
    }

    @Contract(pure=true)
    @NotNull
    public static <T, U, R> AsyncBiFunction<T, U, R> buffer(int maxParallelCalls, int maxBufferedCalls, @NotNull AsyncBiFunction<T, U, R> asyncFunction) {
        return AsyncBiFunctions.ofExecutor(AsyncExecutors.buffered(maxParallelCalls, maxBufferedCalls), asyncFunction);
    }

    @Contract(pure=true)
    @NotNull
    public static <T, U, R> AsyncBiFunction<T, U, R> ofExecutor(@NotNull AsyncExecutor asyncExecutor, @NotNull AsyncBiFunction<T, U, R> function) {
        return (t, u) -> asyncExecutor.execute(() -> function.apply(t, u));
    }
}

