/*
 * Decompiled with CFR 0.152.
 */
package io.activej.async.function;

import io.activej.common.exception.FatalErrorHandlers;
import io.activej.common.function.BiPredicateEx;
import io.activej.promise.Promise;
import org.jetbrains.annotations.NotNull;

@FunctionalInterface
public interface AsyncBiPredicate<T, U> {
    public Promise<Boolean> test(T var1, U var2);

    @NotNull
    public static <T, U> AsyncBiPredicate<T, U> of(@NotNull BiPredicateEx<? super T, ? super U> predicate) {
        return (t, u) -> {
            try {
                return Promise.of(predicate.test(t, u));
            }
            catch (Exception e) {
                FatalErrorHandlers.handleError((Throwable)e, (Object)predicate);
                return Promise.ofException(e);
            }
        };
    }

    public static <T, U> AsyncBiPredicate<T, U> alwaysTrue() {
        return (t, u) -> Promise.of(Boolean.TRUE);
    }

    public static <T, U> AsyncBiPredicate<T, U> alwaysFalse() {
        return (t, u) -> Promise.of(Boolean.FALSE);
    }

    public static <T, U> AsyncBiPredicate<T, U> not(AsyncBiPredicate<? super T, ? super U> predicate) {
        return predicate.negate();
    }

    default public AsyncBiPredicate<T, U> negate() {
        return (t, u) -> this.test(t, u).map(b -> b == false);
    }

    default public AsyncBiPredicate<T, U> and(AsyncBiPredicate<? super T, ? super U> other) {
        return (t, u) -> this.test(t, u).combine(other.test(t, u), (b1, b2) -> b1 != false && b2 != false);
    }

    default public AsyncBiPredicate<T, U> or(AsyncBiPredicate<? super T, ? super U> other) {
        return (t, u) -> this.test(t, u).combine(other.test(t, u), (b1, b2) -> b1 != false || b2 != false);
    }
}

