/*
 * Decompiled with CFR 0.152.
 */
package io.activej.async.function;

import io.activej.common.exception.FatalErrorHandlers;
import io.activej.common.function.FunctionEx;
import io.activej.promise.Promise;
import org.jetbrains.annotations.NotNull;

@FunctionalInterface
public interface AsyncFunction<T, R> {
    public Promise<R> apply(T var1);

    @NotNull
    public static <T, R> AsyncFunction<T, R> of(@NotNull FunctionEx<? super T, ? extends R> function) {
        return value -> {
            try {
                return Promise.of(function.apply(value));
            }
            catch (Exception e) {
                FatalErrorHandlers.handleError((Throwable)e, (Object)function);
                return Promise.ofException(e);
            }
        };
    }
}

