/*
 * Decompiled with CFR 0.152.
 */
package io.activej.async.function;

import io.activej.async.function.AsyncFunction;
import io.activej.async.process.AsyncExecutor;
import io.activej.async.process.AsyncExecutors;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public final class AsyncFunctions {
    @Contract(pure=true)
    @NotNull
    public static <T, R> AsyncFunction<T, R> buffer(@NotNull AsyncFunction<T, R> actual) {
        return AsyncFunctions.buffer(1, Integer.MAX_VALUE, actual);
    }

    @Contract(pure=true)
    @NotNull
    public static <T, R> AsyncFunction<T, R> buffer(int maxParallelCalls, int maxBufferedCalls, @NotNull AsyncFunction<T, R> asyncFunction) {
        return AsyncFunctions.ofExecutor(AsyncExecutors.buffered(maxParallelCalls, maxBufferedCalls), asyncFunction);
    }

    @Contract(pure=true)
    @NotNull
    public static <T, R> AsyncFunction<T, R> ofExecutor(@NotNull AsyncExecutor asyncExecutor, @NotNull AsyncFunction<T, R> function) {
        return t -> asyncExecutor.execute(() -> function.apply(t));
    }
}

