/*
 * Decompiled with CFR 0.152.
 */
package io.activej.promise;

import io.activej.async.callback.Callback;
import io.activej.common.ApplicationSettings;
import io.activej.common.Checks;
import io.activej.common.collection.Try;
import io.activej.common.exception.FatalErrorHandlers;
import io.activej.common.function.BiConsumerEx;
import io.activej.common.function.BiFunctionEx;
import io.activej.common.function.ConsumerEx;
import io.activej.common.function.FunctionEx;
import io.activej.common.function.RunnableEx;
import io.activej.common.function.SupplierEx;
import io.activej.common.recycle.Recyclers;
import io.activej.eventloop.Eventloop;
import io.activej.eventloop.util.RunnableWithContext;
import io.activej.promise.NextPromise;
import io.activej.promise.Promise;
import io.activej.promise.SettablePromise;
import io.activej.promise.SimpleCallback;
import java.util.Arrays;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import org.jetbrains.annotations.Async;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class AbstractPromise<T>
implements Promise<T> {
    private static final boolean CHECK;
    private static final Object PROMISE_NOT_SET;
    private static final boolean RESET_CALLBACKS;
    protected T result = PROMISE_NOT_SET;
    @Nullable
    protected Exception exception;
    @Nullable
    protected Callback<? super T> next;
    private static final Object NO_RESULT;
    private static final String INDENT = "\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*";
    private static final Pattern PACKAGE_NAME_AND_LAMBDA_PART;

    AbstractPromise() {
    }

    public void reset() {
        this.result = PROMISE_NOT_SET;
        this.exception = null;
        this.next = null;
    }

    public void resetCallbacks() {
        this.next = null;
    }

    @Override
    public final boolean isComplete() {
        return this.result != PROMISE_NOT_SET;
    }

    @Override
    public final boolean isResult() {
        return this.result != PROMISE_NOT_SET && this.exception == null;
    }

    @Override
    public final boolean isException() {
        return this.exception != null;
    }

    @Override
    public T getResult() {
        return this.result != PROMISE_NOT_SET ? (T)this.result : null;
    }

    @Override
    public Exception getException() {
        return this.exception;
    }

    @Override
    public Try<T> getTry() {
        if (this.isResult()) {
            return Try.of(this.result);
        }
        if (this.isException()) {
            return Try.ofException((Exception)this.exception);
        }
        return null;
    }

    protected void complete(@Nullable T value, @Nullable Exception e) {
        if (CHECK) {
            Checks.checkState((!this.isComplete() ? 1 : 0) != 0, (Object)"Promise has already been completed");
        }
        if (e == null) {
            this.complete(value);
        } else {
            this.completeExceptionally(e);
        }
    }

    @Async.Execute
    protected void complete(@Nullable T value) {
        if (CHECK) {
            Checks.checkState((!this.isComplete() ? 1 : 0) != 0, (Object)"Promise has already been completed");
        }
        this.result = value;
        if (this.next != null) {
            this.next.accept(value, null);
            if (RESET_CALLBACKS) {
                this.next = null;
            }
        }
    }

    @Async.Execute
    protected void completeExceptionally(@Nullable Exception e) {
        if (CHECK) {
            Checks.checkState((!this.isComplete() ? 1 : 0) != 0, (Object)"Promise has already been completed");
        }
        this.result = null;
        this.exception = e;
        if (this.next != null) {
            this.next.accept(null, e);
            if (RESET_CALLBACKS) {
                this.next = null;
            }
        }
    }

    protected boolean tryComplete(@Nullable T value, @Nullable Exception e) {
        if (!this.isComplete()) {
            this.complete(value, e);
            return true;
        }
        return false;
    }

    protected boolean tryComplete(@Nullable T value) {
        if (!this.isComplete()) {
            this.complete(value);
            return true;
        }
        return false;
    }

    protected boolean tryCompleteExceptionally(@NotNull Exception e) {
        if (!this.isComplete()) {
            this.completeExceptionally(e);
            return true;
        }
        return false;
    }

    @Override
    @NotNull
    public <U> Promise<U> next(@Async.Schedule @NotNull NextPromise<T, U> promise) {
        if (this.isComplete()) {
            promise.accept(this.result, this.exception);
            return promise;
        }
        this.subscribe(promise);
        return promise;
    }

    @Async.Schedule
    protected void subscribe(@NotNull Callback<? super T> callback) {
        if (CHECK) {
            Checks.checkState((!this.isComplete() ? 1 : 0) != 0, (Object)"Promise has already been completed");
        }
        if (this.next == null) {
            this.next = callback;
        } else if (this.next instanceof CallbackList) {
            ((CallbackList)this.next).add(callback);
        } else {
            this.next = new CallbackList<T>(this.next, callback);
        }
    }

    @Override
    @NotNull
    public <U> Promise<U> map(final @NotNull FunctionEx<? super T, ? extends U> fn) {
        if (this.isComplete()) {
            try {
                return this.isResult() ? Promise.of(fn.apply(this.result)) : this;
            }
            catch (Exception ex) {
                FatalErrorHandlers.handleError((Throwable)ex, (Object)this);
                return Promise.ofException(ex);
            }
        }
        NextPromise resultPromise = new NextPromise<T, U>(){

            public void accept(T result, @Nullable Exception e) {
                if (e == null) {
                    Object newResult;
                    try {
                        newResult = fn.apply(result);
                    }
                    catch (Exception ex) {
                        FatalErrorHandlers.handleError((Throwable)ex, (Object)this);
                        this.completeExceptionally(ex);
                        return;
                    }
                    this.complete(newResult);
                } else {
                    this.completeExceptionally(e);
                }
            }

            @Override
            public String describe() {
                return ".map(" + AbstractPromise.formatToString(fn) + ')';
            }
        };
        this.subscribe(resultPromise);
        return resultPromise;
    }

    @Override
    @NotNull
    public <U> Promise<U> mapIfElse(final @NotNull Predicate<? super T> predicate, final @NotNull FunctionEx<? super T, ? extends U> fn, final @NotNull FunctionEx<? super T, ? extends U> fnElse) {
        if (this.isComplete()) {
            try {
                return this.isResult() ? Promise.of(predicate.test(this.result) ? fn.apply(this.result) : fnElse.apply(this.result)) : this;
            }
            catch (Exception ex) {
                FatalErrorHandlers.handleError((Throwable)ex, (Object)this);
                return Promise.ofException(ex);
            }
        }
        NextPromise resultPromise = new NextPromise<T, U>(){

            public void accept(T result, @Nullable Exception e) {
                if (e == null) {
                    Object newResult;
                    try {
                        newResult = predicate.test(result) ? fn.apply(result) : fnElse.apply(result);
                    }
                    catch (Exception ex) {
                        FatalErrorHandlers.handleError((Throwable)ex, (Object)this);
                        this.completeExceptionally(ex);
                        return;
                    }
                    this.complete(newResult);
                } else {
                    this.completeExceptionally(e);
                }
            }

            @Override
            public String describe() {
                return ".mapWhen(" + AbstractPromise.formatToString(predicate) + ", " + AbstractPromise.formatToString(fn) + ", " + AbstractPromise.formatToString(fnElse) + ')';
            }
        };
        this.subscribe(resultPromise);
        return resultPromise;
    }

    @Override
    @NotNull
    public Promise<T> mapIf(final @NotNull Predicate<? super T> predicate, final @NotNull FunctionEx<? super T, ? extends T> fn) {
        if (this.isComplete()) {
            try {
                return this.isResult() ? Promise.of(predicate.test(this.result) ? fn.apply(this.result) : this.result) : this;
            }
            catch (Exception ex) {
                FatalErrorHandlers.handleError((Throwable)ex, (Object)this);
                return Promise.ofException(ex);
            }
        }
        NextPromise resultPromise = new NextPromise<T, T>(){

            public void accept(T result, @Nullable Exception e) {
                if (e == null) {
                    Object newResult;
                    try {
                        newResult = predicate.test(result) ? fn.apply(result) : result;
                    }
                    catch (Exception ex) {
                        FatalErrorHandlers.handleError((Throwable)ex, (Object)this);
                        this.completeExceptionally(ex);
                        return;
                    }
                    this.complete(newResult);
                } else {
                    this.completeExceptionally(e);
                }
            }

            @Override
            public String describe() {
                return ".mapWhen(" + AbstractPromise.formatToString(predicate) + ", " + AbstractPromise.formatToString(fn) + ", " + ')';
            }
        };
        this.subscribe(resultPromise);
        return resultPromise;
    }

    @Override
    @NotNull
    public Promise<T> mapIfNull(final @NotNull SupplierEx<? extends T> supplier) {
        if (this.isComplete()) {
            try {
                return this.isResult() ? Promise.of(this.result == null ? supplier.get() : this.result) : this;
            }
            catch (Exception ex) {
                FatalErrorHandlers.handleError((Throwable)ex, (Object)this);
                return Promise.ofException(ex);
            }
        }
        NextPromise resultPromise = new NextPromise<T, T>(){

            public void accept(T result, @Nullable Exception e) {
                if (e == null) {
                    Object newResult;
                    try {
                        newResult = result == null ? supplier.get() : result;
                    }
                    catch (Exception ex) {
                        FatalErrorHandlers.handleError((Throwable)ex, (Object)this);
                        this.completeExceptionally(ex);
                        return;
                    }
                    this.complete(newResult);
                } else {
                    this.completeExceptionally(e);
                }
            }

            @Override
            public String describe() {
                return ".mapWhenNull(" + AbstractPromise.formatToString(supplier) + ", " + ')';
            }
        };
        this.subscribe(resultPromise);
        return resultPromise;
    }

    @Override
    @NotNull
    public <U> Promise<U> mapIfNonNull(final @NotNull @NotNull FunctionEx<? super @NotNull T, ? extends U> fn) {
        if (this.isComplete()) {
            try {
                return this.isResult() ? Promise.of(Objects.nonNull(this.result) ? fn.apply(this.result) : null) : this;
            }
            catch (Exception ex) {
                FatalErrorHandlers.handleError((Throwable)ex, (Object)this);
                return Promise.ofException(ex);
            }
        }
        NextPromise resultPromise = new NextPromise<T, U>(){

            public void accept(T result, @Nullable Exception e) {
                if (e == null) {
                    Object newResult;
                    try {
                        newResult = result != null ? fn.apply(result) : null;
                    }
                    catch (Exception ex) {
                        FatalErrorHandlers.handleError((Throwable)ex, (Object)this);
                        this.completeExceptionally(ex);
                        return;
                    }
                    this.complete(newResult);
                } else {
                    this.completeExceptionally(e);
                }
            }

            @Override
            public String describe() {
                return ".mapWhenNonNull(, " + AbstractPromise.formatToString(fn) + ", " + ')';
            }
        };
        this.subscribe(resultPromise);
        return resultPromise;
    }

    @Override
    @NotNull
    public <U> Promise<U> map(final @NotNull BiFunctionEx<? super T, Exception, ? extends U> fn) {
        if (this.isComplete()) {
            try {
                return Promise.of(fn.apply(this.result, (Object)this.exception));
            }
            catch (Exception ex) {
                FatalErrorHandlers.handleError((Throwable)ex, (Object)this);
                return Promise.ofException(ex);
            }
        }
        NextPromise resultPromise = new NextPromise<T, U>(){

            public void accept(T result, Exception e) {
                Object newResult;
                try {
                    newResult = fn.apply(result, (Object)e);
                }
                catch (Exception ex) {
                    FatalErrorHandlers.handleError((Throwable)ex, (Object)this);
                    this.completeExceptionally(ex);
                    return;
                }
                this.complete(newResult);
            }

            @Override
            public String describe() {
                return ".map(" + AbstractPromise.formatToString(fn) + ')';
            }
        };
        this.subscribe(resultPromise);
        return resultPromise;
    }

    @Override
    @NotNull
    public <U> Promise<U> map(final @NotNull FunctionEx<? super T, ? extends U> fn, final @NotNull @NotNull FunctionEx<@NotNull Exception, ? extends U> exceptionFn) {
        if (this.isComplete()) {
            try {
                return Promise.of(this.exception == null ? fn.apply(this.result) : exceptionFn.apply((Object)this.exception));
            }
            catch (Exception ex) {
                FatalErrorHandlers.handleError((Throwable)ex, (Object)this);
                return Promise.ofException(ex);
            }
        }
        NextPromise resultPromise = new NextPromise<T, U>(){

            public void accept(T result, Exception e) {
                Object newResult;
                try {
                    newResult = e == null ? fn.apply(result) : exceptionFn.apply((Object)e);
                }
                catch (Exception ex) {
                    FatalErrorHandlers.handleError((Throwable)ex, (Object)this);
                    this.completeExceptionally(ex);
                    return;
                }
                this.complete(newResult);
            }

            @Override
            public String describe() {
                return ".map(" + AbstractPromise.formatToString(fn) + ", " + AbstractPromise.formatToString(exceptionFn) + ')';
            }
        };
        this.subscribe(resultPromise);
        return resultPromise;
    }

    @Override
    @NotNull
    public Promise<T> mapException(final @NotNull @NotNull FunctionEx<@NotNull Exception, @NotNull Exception> exceptionFn) {
        if (this.isComplete()) {
            try {
                return this.exception == null ? this : Promise.ofException((Exception)exceptionFn.apply((Object)this.exception));
            }
            catch (Exception ex) {
                FatalErrorHandlers.handleError((Throwable)ex, (Object)this);
                return Promise.ofException(ex);
            }
        }
        NextPromise resultPromise = new NextPromise<T, T>(){

            public void accept(T result, @Nullable Exception e) {
                if (e == null) {
                    this.complete(result);
                } else {
                    try {
                        e = (Exception)exceptionFn.apply((Object)e);
                    }
                    catch (Exception ex) {
                        FatalErrorHandlers.handleError((Throwable)ex, (Object)this);
                        this.completeExceptionally(ex);
                        return;
                    }
                    this.completeExceptionally(e);
                }
            }

            @Override
            public String describe() {
                return ".mapException(" + AbstractPromise.formatToString(exceptionFn) + ')';
            }
        };
        this.subscribe(resultPromise);
        return resultPromise;
    }

    @Override
    @NotNull
    public Promise<T> mapException(final @NotNull Predicate<Exception> predicate, final @NotNull @NotNull FunctionEx<@NotNull Exception, @NotNull Exception> exceptionFn) {
        if (this.isComplete()) {
            try {
                return this.exception == null ? this : (predicate.test(this.exception) ? Promise.ofException((Exception)exceptionFn.apply((Object)this.exception)) : this);
            }
            catch (Exception ex) {
                FatalErrorHandlers.handleError((Throwable)ex, (Object)this);
                return Promise.ofException(ex);
            }
        }
        NextPromise resultPromise = new NextPromise<T, T>(){

            public void accept(T result, @Nullable Exception e) {
                if (e == null) {
                    this.complete(result);
                } else {
                    try {
                        e = predicate.test(e) ? (Exception)exceptionFn.apply((Object)e) : e;
                    }
                    catch (Exception ex) {
                        FatalErrorHandlers.handleError((Throwable)ex, (Object)this);
                        this.completeExceptionally(ex);
                        return;
                    }
                    this.completeExceptionally(e);
                }
            }

            @Override
            public String describe() {
                return ".mapException(" + AbstractPromise.formatToString(predicate) + ", " + AbstractPromise.formatToString(exceptionFn) + ')';
            }
        };
        this.subscribe(resultPromise);
        return resultPromise;
    }

    @Override
    @NotNull
    public <E extends Exception> Promise<T> mapException(final @NotNull Class<E> clazz, final @NotNull @NotNull FunctionEx<? super @NotNull E, ? extends @NotNull Exception> exceptionFn) {
        if (this.isComplete()) {
            try {
                return this.exception == null ? this : (clazz.isAssignableFrom(this.exception.getClass()) ? Promise.ofException((Exception)exceptionFn.apply((Object)this.exception)) : this);
            }
            catch (Exception ex) {
                FatalErrorHandlers.handleError((Throwable)ex, (Object)this);
                return Promise.ofException(ex);
            }
        }
        NextPromise resultPromise = new NextPromise<T, T>(){

            public void accept(T result, @Nullable Exception e) {
                if (e == null) {
                    this.complete(result);
                } else {
                    try {
                        e = clazz.isAssignableFrom(e.getClass()) ? (Exception)exceptionFn.apply((Object)e) : e;
                    }
                    catch (Exception ex) {
                        FatalErrorHandlers.handleError((Throwable)ex, (Object)this);
                        this.completeExceptionally(ex);
                        return;
                    }
                    this.completeExceptionally(e);
                }
            }

            @Override
            public String describe() {
                return ".mapException(" + clazz.getName() + ", " + AbstractPromise.formatToString(exceptionFn) + ')';
            }
        };
        this.subscribe(resultPromise);
        return resultPromise;
    }

    @Override
    @NotNull
    public <U> Promise<U> then(final @NotNull SupplierEx<Promise<? extends U>> fn) {
        if (this.isComplete()) {
            try {
                return this.isResult() ? (Promise)fn.get() : this;
            }
            catch (Exception ex) {
                FatalErrorHandlers.handleError((Throwable)ex, (Object)this);
                return Promise.ofException(ex);
            }
        }
        NextPromise resultPromise = new NextPromise<T, U>(){

            public void accept(T result, @Nullable Exception e) {
                if (e == null) {
                    Promise promise;
                    try {
                        promise = (Promise)fn.get();
                    }
                    catch (Exception ex) {
                        FatalErrorHandlers.handleError((Throwable)ex, (Object)this);
                        this.completeExceptionally(ex);
                        return;
                    }
                    promise.run(this::complete);
                } else {
                    this.completeExceptionally(e);
                }
            }

            @Override
            public String describe() {
                return ".then(" + AbstractPromise.formatToString(fn) + ')';
            }
        };
        this.subscribe(resultPromise);
        return resultPromise;
    }

    @Override
    @NotNull
    public <U> Promise<U> then(final @NotNull FunctionEx<? super T, Promise<? extends U>> fn) {
        if (this.isComplete()) {
            try {
                return this.isResult() ? (Promise)fn.apply(this.result) : this;
            }
            catch (Exception ex) {
                FatalErrorHandlers.handleError((Throwable)ex, (Object)this);
                return Promise.ofException(ex);
            }
        }
        NextPromise resultPromise = new NextPromise<T, U>(){

            public void accept(T result, @Nullable Exception e) {
                if (e == null) {
                    Promise promise;
                    try {
                        promise = (Promise)fn.apply(result);
                    }
                    catch (Exception ex) {
                        FatalErrorHandlers.handleError((Throwable)ex, (Object)this);
                        this.completeExceptionally(ex);
                        return;
                    }
                    promise.run(this::complete);
                } else {
                    this.completeExceptionally(e);
                }
            }

            @Override
            public String describe() {
                return ".then(" + AbstractPromise.formatToString(fn) + ')';
            }
        };
        this.subscribe(resultPromise);
        return resultPromise;
    }

    @Override
    @NotNull
    public <U> Promise<U> thenIfElse(final @NotNull Predicate<? super T> predicate, final @NotNull FunctionEx<? super T, Promise<? extends U>> fn, final @NotNull FunctionEx<? super T, Promise<? extends U>> fnElse) {
        if (this.isComplete()) {
            try {
                return this.isResult() ? (predicate.test(this.result) ? (Promise)fn.apply(this.result) : (Promise)fnElse.apply(this.result)) : this;
            }
            catch (Exception ex) {
                FatalErrorHandlers.handleError((Throwable)ex, (Object)this);
                return Promise.ofException(ex);
            }
        }
        NextPromise resultPromise = new NextPromise<T, U>(){

            public void accept(T result, @Nullable Exception e) {
                if (e == null) {
                    Promise promise;
                    try {
                        promise = predicate.test(result) ? (Promise)fn.apply(result) : (Promise)fnElse.apply(result);
                    }
                    catch (Exception ex) {
                        FatalErrorHandlers.handleError((Throwable)ex, (Object)this);
                        this.completeExceptionally(ex);
                        return;
                    }
                    promise.run(this::complete);
                } else {
                    this.completeExceptionally(e);
                }
            }

            @Override
            public String describe() {
                return ".thenWhen(" + AbstractPromise.formatToString(predicate) + ", " + AbstractPromise.formatToString(fn) + ", " + AbstractPromise.formatToString(fnElse) + ')';
            }
        };
        this.subscribe(resultPromise);
        return resultPromise;
    }

    @Override
    @NotNull
    public Promise<T> thenIf(final @NotNull Predicate<? super T> predicate, final @NotNull FunctionEx<? super T, Promise<? extends T>> fn) {
        if (this.isComplete()) {
            try {
                return this.isResult() ? (predicate.test(this.result) ? (Promise)fn.apply(this.result) : this) : this;
            }
            catch (Exception ex) {
                FatalErrorHandlers.handleError((Throwable)ex, (Object)this);
                return Promise.ofException(ex);
            }
        }
        NextPromise resultPromise = new NextPromise<T, T>(){

            public void accept(T result, @Nullable Exception e) {
                if (e == null) {
                    if (predicate.test(result)) {
                        Promise promise;
                        try {
                            promise = (Promise)fn.apply(result);
                        }
                        catch (Exception ex) {
                            FatalErrorHandlers.handleError((Throwable)ex, (Object)this);
                            this.completeExceptionally(ex);
                            return;
                        }
                        promise.run(this::complete);
                    } else {
                        this.complete(result);
                    }
                } else {
                    this.completeExceptionally(e);
                }
            }

            @Override
            public String describe() {
                return ".thenWhen(" + AbstractPromise.formatToString(predicate) + ", " + AbstractPromise.formatToString(fn) + ')';
            }
        };
        this.subscribe(resultPromise);
        return resultPromise;
    }

    @Override
    @NotNull
    public Promise<T> thenIfNull(final @NotNull SupplierEx<Promise<? extends T>> supplier) {
        if (this.isComplete()) {
            try {
                return this.isResult() ? (this.result == null ? (Promise)supplier.get() : this) : this;
            }
            catch (Exception ex) {
                FatalErrorHandlers.handleError((Throwable)ex, (Object)this);
                return Promise.ofException(ex);
            }
        }
        NextPromise resultPromise = new NextPromise<T, T>(){

            public void accept(T result, @Nullable Exception e) {
                if (e == null) {
                    if (result == null) {
                        Promise promise;
                        try {
                            promise = (Promise)supplier.get();
                        }
                        catch (Exception ex) {
                            FatalErrorHandlers.handleError((Throwable)ex, (Object)this);
                            this.completeExceptionally(ex);
                            return;
                        }
                        promise.run(this::complete);
                    } else {
                        this.complete(result);
                    }
                } else {
                    this.completeExceptionally(e);
                }
            }

            @Override
            public String describe() {
                return ".thenWhenNull(, " + AbstractPromise.formatToString(supplier) + ", " + ')';
            }
        };
        this.subscribe(resultPromise);
        return resultPromise;
    }

    @Override
    @NotNull
    public <U> Promise<U> thenIfNonNull(final @NotNull @NotNull FunctionEx<? super @NotNull T, Promise<? extends U>> fn) {
        if (this.isComplete()) {
            try {
                return this.isResult() ? (this.result != null ? (Promise)fn.apply(this.result) : this) : this;
            }
            catch (Exception ex) {
                FatalErrorHandlers.handleError((Throwable)ex, (Object)this);
                return Promise.ofException(ex);
            }
        }
        NextPromise resultPromise = new NextPromise<T, U>(){

            public void accept(T result, @Nullable Exception e) {
                if (e == null) {
                    if (result != null) {
                        Promise promise;
                        try {
                            promise = (Promise)fn.apply(result);
                        }
                        catch (Exception ex) {
                            FatalErrorHandlers.handleError((Throwable)ex, (Object)this);
                            this.completeExceptionally(ex);
                            return;
                        }
                        promise.run(this::complete);
                    } else {
                        this.complete(null);
                    }
                } else {
                    this.completeExceptionally(e);
                }
            }

            @Override
            public String describe() {
                return ".thenWhenNonNull(" + AbstractPromise.formatToString(fn) + ')';
            }
        };
        this.subscribe(resultPromise);
        return resultPromise;
    }

    @Override
    @NotNull
    public <U> Promise<U> then(final @NotNull BiFunctionEx<? super T, Exception, Promise<? extends U>> fn) {
        if (this.isComplete()) {
            try {
                return (Promise)fn.apply(this.result, (Object)this.exception);
            }
            catch (Exception ex) {
                FatalErrorHandlers.handleError((Throwable)ex, (Object)this);
                return Promise.ofException(ex);
            }
        }
        NextPromise resultPromise = new NextPromise<T, U>(){

            public void accept(T result, @Nullable Exception e) {
                if (e == null) {
                    Promise promise;
                    try {
                        promise = (Promise)fn.apply(result, null);
                    }
                    catch (Exception ex) {
                        FatalErrorHandlers.handleError((Throwable)ex, (Object)this);
                        this.completeExceptionally(ex);
                        return;
                    }
                    promise.run(this::complete);
                } else {
                    Promise promise;
                    try {
                        promise = (Promise)fn.apply(null, (Object)e);
                    }
                    catch (Exception ex) {
                        FatalErrorHandlers.handleError((Throwable)ex, (Object)this);
                        this.completeExceptionally(ex);
                        return;
                    }
                    promise.run(this::complete);
                }
            }

            @Override
            public String describe() {
                return ".then(" + AbstractPromise.formatToString(fn) + ')';
            }
        };
        this.subscribe(resultPromise);
        return resultPromise;
    }

    @Override
    @NotNull
    public <U> Promise<U> then(final @NotNull FunctionEx<? super T, Promise<? extends U>> fn, final @NotNull @NotNull FunctionEx<@NotNull Exception, Promise<? extends U>> exceptionFn) {
        if (this.isComplete()) {
            try {
                return this.exception == null ? (Promise)fn.apply(this.result) : (Promise)exceptionFn.apply((Object)this.exception);
            }
            catch (Exception ex) {
                FatalErrorHandlers.handleError((Throwable)ex, (Object)this);
                return Promise.ofException(ex);
            }
        }
        NextPromise resultPromise = new NextPromise<T, U>(){

            public void accept(T result, @Nullable Exception e) {
                if (e == null) {
                    Promise promise;
                    try {
                        promise = (Promise)fn.apply(result);
                    }
                    catch (Exception ex) {
                        FatalErrorHandlers.handleError((Throwable)ex, (Object)this);
                        this.completeExceptionally(ex);
                        return;
                    }
                    promise.run(this::complete);
                } else {
                    Promise promise;
                    try {
                        promise = (Promise)exceptionFn.apply((Object)e);
                    }
                    catch (Exception ex) {
                        FatalErrorHandlers.handleError((Throwable)ex, (Object)this);
                        this.completeExceptionally(ex);
                        return;
                    }
                    promise.run(this::complete);
                }
            }

            @Override
            public String describe() {
                return ".then(" + AbstractPromise.formatToString(fn) + ", " + AbstractPromise.formatToString(exceptionFn) + ')';
            }
        };
        this.subscribe(resultPromise);
        return resultPromise;
    }

    @Override
    @NotNull
    public Promise<T> when(final @NotNull BiPredicate<? super T, @Nullable Exception> predicate, final @NotNull BiConsumerEx<? super T, Exception> fn) {
        if (this.isComplete()) {
            try {
                if (predicate.test(this.result, this.exception)) {
                    fn.accept(this.result, (Object)this.exception);
                }
                return this;
            }
            catch (Exception ex) {
                FatalErrorHandlers.handleError((Throwable)ex, (Object)this);
                return Promise.ofException(ex);
            }
        }
        NextPromise resultPromise = new NextPromise<T, T>(){

            public void accept(T result, @Nullable Exception e) {
                try {
                    if (predicate.test(result, e)) {
                        fn.accept(result, (Object)e);
                    }
                }
                catch (Exception ex) {
                    FatalErrorHandlers.handleError((Throwable)ex, (Object)this);
                    this.completeExceptionally(ex);
                    return;
                }
                this.complete(result, e);
            }

            @Override
            public String describe() {
                return ".when(" + AbstractPromise.formatToString(predicate) + ", " + AbstractPromise.formatToString(fn) + ')';
            }
        };
        this.subscribe(resultPromise);
        return resultPromise;
    }

    @Override
    @NotNull
    public Promise<T> when(final @NotNull BiPredicate<? super T, @Nullable Exception> predicate, final @Nullable ConsumerEx<? super T> fn, final @Nullable ConsumerEx<@NotNull Exception> exceptionFn) {
        if (this.isComplete()) {
            try {
                if (predicate.test(this.result, this.exception)) {
                    if (this.exception == null) {
                        fn.accept(this.result);
                    } else {
                        exceptionFn.accept((Object)this.exception);
                    }
                }
                return this;
            }
            catch (Exception ex) {
                FatalErrorHandlers.handleError((Throwable)ex, (Object)this);
                return Promise.ofException(ex);
            }
        }
        NextPromise resultPromise = new NextPromise<T, T>(){

            public void accept(T result, @Nullable Exception e) {
                try {
                    if (predicate.test(result, e)) {
                        if (e == null) {
                            fn.accept(result);
                        } else {
                            exceptionFn.accept((Object)e);
                        }
                    }
                }
                catch (Exception ex) {
                    FatalErrorHandlers.handleError((Throwable)ex, (Object)this);
                    this.completeExceptionally(ex);
                    return;
                }
                this.complete(result, e);
            }

            @Override
            public String describe() {
                return ".when(" + AbstractPromise.formatToString(predicate) + ", " + (fn != null ? AbstractPromise.formatToString(fn) : null) + ", " + (exceptionFn != null ? AbstractPromise.formatToString(exceptionFn) : null) + ')';
            }
        };
        this.subscribe(resultPromise);
        return resultPromise;
    }

    @Override
    @NotNull
    public Promise<T> when(final @NotNull BiPredicate<? super T, @Nullable Exception> predicate, final @NotNull RunnableEx action) {
        if (this.isComplete()) {
            try {
                if (predicate.test(this.result, this.exception)) {
                    action.run();
                }
                return this;
            }
            catch (Exception ex) {
                FatalErrorHandlers.handleError((Throwable)ex, (Object)this);
                return Promise.ofException(ex);
            }
        }
        NextPromise resultPromise = new NextPromise<T, T>(){

            public void accept(T result, @Nullable Exception e) {
                try {
                    if (predicate.test(result, e)) {
                        action.run();
                    }
                }
                catch (Exception ex) {
                    FatalErrorHandlers.handleError((Throwable)ex, (Object)this);
                    this.completeExceptionally(ex);
                    return;
                }
                this.complete(result, e);
            }

            @Override
            public String describe() {
                return ".when(" + AbstractPromise.formatToString(predicate) + ", " + AbstractPromise.formatToString(action) + ')';
            }
        };
        this.subscribe(resultPromise);
        return resultPromise;
    }

    @Override
    @NotNull
    public Promise<T> whenComplete(final @NotNull BiConsumerEx<? super T, Exception> fn) {
        if (this.isComplete()) {
            try {
                fn.accept(this.result, (Object)this.exception);
            }
            catch (Exception ex) {
                FatalErrorHandlers.handleError((Throwable)ex, (Object)this);
                return Promise.ofException(ex);
            }
            return this;
        }
        NextPromise resultPromise = new NextPromise<T, T>(){

            public void accept(T result, @Nullable Exception e) {
                try {
                    fn.accept(result, (Object)e);
                }
                catch (Exception ex) {
                    FatalErrorHandlers.handleError((Throwable)ex, (Object)this);
                    this.completeExceptionally(ex);
                    return;
                }
                this.complete(result, e);
            }

            @Override
            public String describe() {
                return ".whenComplete(" + AbstractPromise.formatToString(fn) + ')';
            }
        };
        this.subscribe(resultPromise);
        return resultPromise;
    }

    @Override
    @NotNull
    public Promise<T> whenComplete(final @NotNull ConsumerEx<? super T> fn, final @NotNull @NotNull ConsumerEx<@NotNull Exception> exceptionFn) {
        if (this.isComplete()) {
            try {
                if (this.exception == null) {
                    fn.accept(this.result);
                } else {
                    exceptionFn.accept((Object)this.exception);
                }
            }
            catch (Exception ex) {
                FatalErrorHandlers.handleError((Throwable)ex, (Object)this);
                return Promise.ofException(ex);
            }
            return this;
        }
        NextPromise resultPromise = new NextPromise<T, T>(){

            public void accept(T result, @Nullable Exception e) {
                try {
                    if (e == null) {
                        fn.accept(result);
                    } else {
                        exceptionFn.accept((Object)e);
                    }
                }
                catch (Exception ex) {
                    FatalErrorHandlers.handleError((Throwable)ex, (Object)this);
                    this.completeExceptionally(ex);
                    return;
                }
                this.complete(result, e);
            }

            @Override
            public String describe() {
                return ".whenComplete(" + AbstractPromise.formatToString(fn) + ", " + AbstractPromise.formatToString(exceptionFn) + ')';
            }
        };
        this.subscribe(resultPromise);
        return resultPromise;
    }

    @Override
    @NotNull
    public Promise<T> whenComplete(final @NotNull RunnableEx action) {
        if (this.isComplete()) {
            try {
                action.run();
            }
            catch (Exception ex) {
                FatalErrorHandlers.handleError((Throwable)ex, (Object)this);
                return Promise.ofException(ex);
            }
            return this;
        }
        NextPromise resultPromise = new NextPromise<T, T>(){

            public void accept(T result, @Nullable Exception e) {
                try {
                    action.run();
                }
                catch (Exception ex) {
                    FatalErrorHandlers.handleError((Throwable)ex, (Object)this);
                    this.completeExceptionally(ex);
                    return;
                }
                this.complete(result, e);
            }

            @Override
            public String describe() {
                return ".whenComplete(" + AbstractPromise.formatToString(action) + ')';
            }
        };
        this.subscribe(resultPromise);
        return resultPromise;
    }

    @Override
    @NotNull
    public Promise<T> whenResult(final ConsumerEx<? super T> fn) {
        if (this.isComplete()) {
            if (this.isResult()) {
                try {
                    fn.accept(this.result);
                }
                catch (Exception ex) {
                    FatalErrorHandlers.handleError((Throwable)ex, (Object)this);
                    return Promise.ofException(ex);
                }
            }
            return this;
        }
        NextPromise resultPromise = new NextPromise<T, T>(){

            public void accept(T result, @Nullable Exception e) {
                if (e == null) {
                    try {
                        fn.accept(result);
                    }
                    catch (Exception ex) {
                        FatalErrorHandlers.handleError((Throwable)ex, (Object)this);
                        this.completeExceptionally(ex);
                        return;
                    }
                    this.complete(result);
                } else {
                    this.completeExceptionally(e);
                }
            }

            @Override
            public String describe() {
                return ".whenResult(" + AbstractPromise.formatToString(fn) + ')';
            }
        };
        this.subscribe(resultPromise);
        return resultPromise;
    }

    @Override
    @NotNull
    public Promise<T> whenResult(final @NotNull Predicate<? super T> predicate, final ConsumerEx<? super T> fn) {
        if (this.isComplete()) {
            try {
                if (this.exception == null && predicate.test(this.result)) {
                    fn.accept(this.result);
                }
                return this;
            }
            catch (Exception ex) {
                FatalErrorHandlers.handleError((Throwable)ex, (Object)this);
                return Promise.ofException(ex);
            }
        }
        NextPromise resultPromise = new NextPromise<T, T>(){

            public void accept(T result, @Nullable Exception e) {
                try {
                    if (e == null && predicate.test(result)) {
                        fn.accept(result);
                    }
                }
                catch (Exception ex) {
                    FatalErrorHandlers.handleError((Throwable)ex, (Object)this);
                    this.completeExceptionally(ex);
                    return;
                }
                this.complete(result, e);
            }

            @Override
            public String describe() {
                return ".whenResult(" + AbstractPromise.formatToString(predicate) + ", " + AbstractPromise.formatToString(fn) + ')';
            }
        };
        this.subscribe(resultPromise);
        return resultPromise;
    }

    @Override
    @NotNull
    public Promise<T> whenResult(final @NotNull RunnableEx action) {
        if (this.isComplete()) {
            if (this.isResult()) {
                try {
                    action.run();
                }
                catch (Exception ex) {
                    FatalErrorHandlers.handleError((Throwable)ex, (Object)this);
                    return Promise.ofException(ex);
                }
            }
            return this;
        }
        NextPromise resultPromise = new NextPromise<T, T>(){

            public void accept(T result, @Nullable Exception e) {
                if (e == null) {
                    try {
                        action.run();
                    }
                    catch (Exception ex) {
                        FatalErrorHandlers.handleError((Throwable)ex, (Object)this);
                        this.completeExceptionally(ex);
                        return;
                    }
                    this.complete(result);
                } else {
                    this.completeExceptionally(e);
                }
            }

            @Override
            public String describe() {
                return ".whenResult(" + AbstractPromise.formatToString(action) + ')';
            }
        };
        this.subscribe(resultPromise);
        return resultPromise;
    }

    @Override
    @NotNull
    public Promise<T> whenResult(final @NotNull Predicate<? super T> predicate, final @NotNull RunnableEx action) {
        if (this.isComplete()) {
            try {
                if (this.exception == null && predicate.test(this.result)) {
                    action.run();
                }
                return this;
            }
            catch (Exception ex) {
                FatalErrorHandlers.handleError((Throwable)ex, (Object)this);
                return Promise.ofException(ex);
            }
        }
        NextPromise resultPromise = new NextPromise<T, T>(){

            public void accept(T result, @Nullable Exception e) {
                try {
                    if (e == null && predicate.test(result)) {
                        action.run();
                    }
                }
                catch (Exception ex) {
                    FatalErrorHandlers.handleError((Throwable)ex, (Object)this);
                    this.completeExceptionally(ex);
                    return;
                }
                this.complete(result, e);
            }

            @Override
            public String describe() {
                return ".whenResult(" + AbstractPromise.formatToString(predicate) + ", " + AbstractPromise.formatToString(action) + ')';
            }
        };
        this.subscribe(resultPromise);
        return resultPromise;
    }

    @Override
    @NotNull
    public Promise<T> whenException(final @NotNull ConsumerEx<Exception> fn) {
        if (this.isComplete()) {
            if (this.isException()) {
                try {
                    fn.accept((Object)this.exception);
                }
                catch (Exception ex) {
                    FatalErrorHandlers.handleError((Throwable)ex, (Object)this);
                    return Promise.ofException(ex);
                }
            }
            return this;
        }
        NextPromise resultPromise = new NextPromise<T, T>(){

            public void accept(T result, @Nullable Exception e) {
                if (e == null) {
                    this.complete(result);
                } else {
                    try {
                        fn.accept((Object)e);
                    }
                    catch (Exception ex) {
                        FatalErrorHandlers.handleError((Throwable)ex, (Object)this);
                        this.completeExceptionally(ex);
                        return;
                    }
                    this.completeExceptionally(e);
                }
            }

            @Override
            public String describe() {
                return ".whenException(" + AbstractPromise.formatToString(fn) + ')';
            }
        };
        this.subscribe(resultPromise);
        return resultPromise;
    }

    @Override
    @NotNull
    public Promise<T> whenException(final @NotNull Predicate<Exception> predicate, final @NotNull @NotNull ConsumerEx<@NotNull Exception> fn) {
        if (this.isComplete()) {
            try {
                if (this.exception != null && predicate.test(this.exception)) {
                    fn.accept((Object)this.exception);
                }
                return this;
            }
            catch (Exception ex) {
                FatalErrorHandlers.handleError((Throwable)ex, (Object)this);
                return Promise.ofException(ex);
            }
        }
        NextPromise resultPromise = new NextPromise<T, T>(){

            public void accept(T result, @Nullable Exception e) {
                try {
                    if (e != null && predicate.test(e)) {
                        fn.accept((Object)e);
                    }
                }
                catch (Exception ex) {
                    FatalErrorHandlers.handleError((Throwable)ex, (Object)this);
                    this.completeExceptionally(ex);
                    return;
                }
                this.complete(result, e);
            }

            @Override
            public String describe() {
                return ".whenException(" + AbstractPromise.formatToString(predicate) + ", " + AbstractPromise.formatToString(fn) + ')';
            }
        };
        this.subscribe(resultPromise);
        return resultPromise;
    }

    @Override
    @NotNull
    public <E extends Exception> Promise<T> whenException(final @NotNull Class<E> clazz, final @NotNull @NotNull ConsumerEx<? super @NotNull E> fn) {
        if (this.isComplete()) {
            try {
                if (this.exception != null && clazz.isAssignableFrom(this.exception.getClass())) {
                    fn.accept((Object)this.exception);
                }
                return this;
            }
            catch (Exception ex) {
                FatalErrorHandlers.handleError((Throwable)ex, (Object)this);
                return Promise.ofException(ex);
            }
        }
        NextPromise resultPromise = new NextPromise<T, T>(){

            public void accept(T result1, @Nullable Exception e) {
                try {
                    if (e != null && clazz.isAssignableFrom(e.getClass())) {
                        fn.accept((Object)e);
                    }
                }
                catch (Exception ex) {
                    FatalErrorHandlers.handleError((Throwable)ex, (Object)this);
                    this.completeExceptionally(ex);
                    return;
                }
                this.complete(result1, e);
            }

            @Override
            public String describe() {
                return ".whenException(" + clazz.getName() + ", " + AbstractPromise.formatToString(fn) + ')';
            }
        };
        this.subscribe(resultPromise);
        return resultPromise;
    }

    @Override
    @NotNull
    public Promise<T> whenException(final @NotNull RunnableEx action) {
        if (this.isComplete()) {
            if (this.isException()) {
                try {
                    action.run();
                }
                catch (Exception ex) {
                    FatalErrorHandlers.handleError((Throwable)ex, (Object)this);
                    return Promise.ofException(ex);
                }
            }
            return this;
        }
        NextPromise resultPromise = new NextPromise<T, T>(){

            public void accept(T result, @Nullable Exception e) {
                if (e == null) {
                    this.complete(result);
                } else {
                    try {
                        action.run();
                    }
                    catch (Exception ex) {
                        FatalErrorHandlers.handleError((Throwable)ex, (Object)this);
                        this.completeExceptionally(ex);
                        return;
                    }
                    this.completeExceptionally(e);
                }
            }

            @Override
            public String describe() {
                return ".whenException(" + AbstractPromise.formatToString(action) + ')';
            }
        };
        this.subscribe(resultPromise);
        return resultPromise;
    }

    @Override
    @NotNull
    public Promise<T> whenException(final @NotNull Predicate<Exception> predicate, final @NotNull RunnableEx action) {
        if (this.isComplete()) {
            try {
                if (this.exception != null && predicate.test(this.exception)) {
                    action.run();
                }
                return this;
            }
            catch (Exception ex) {
                FatalErrorHandlers.handleError((Throwable)ex, (Object)this);
                return Promise.ofException(ex);
            }
        }
        NextPromise resultPromise = new NextPromise<T, T>(){

            public void accept(T result, @Nullable Exception e) {
                try {
                    if (e != null && predicate.test(e)) {
                        action.run();
                    }
                }
                catch (Exception ex) {
                    FatalErrorHandlers.handleError((Throwable)ex, (Object)this);
                    this.completeExceptionally(ex);
                    return;
                }
                this.complete(result, e);
            }

            @Override
            public String describe() {
                return ".whenException(" + AbstractPromise.formatToString(predicate) + ", " + AbstractPromise.formatToString(action) + ')';
            }
        };
        this.subscribe(resultPromise);
        return resultPromise;
    }

    @Override
    @NotNull
    public Promise<T> whenException(final @NotNull Class<? extends Exception> clazz, final @NotNull RunnableEx action) {
        if (this.isComplete()) {
            try {
                if (this.exception != null && clazz.isAssignableFrom(this.exception.getClass())) {
                    action.run();
                }
                return this;
            }
            catch (Exception ex) {
                FatalErrorHandlers.handleError((Throwable)ex, (Object)this);
                return Promise.ofException(ex);
            }
        }
        NextPromise resultPromise = new NextPromise<T, T>(){

            public void accept(T result, @Nullable Exception e) {
                try {
                    if (e != null && clazz.isAssignableFrom(e.getClass())) {
                        action.run();
                    }
                }
                catch (Exception ex) {
                    FatalErrorHandlers.handleError((Throwable)ex, (Object)this);
                    this.completeExceptionally(ex);
                    return;
                }
                this.complete(result, e);
            }

            @Override
            public String describe() {
                return ".whenException(" + clazz.getName() + ", " + AbstractPromise.formatToString(action) + ')';
            }
        };
        this.subscribe(resultPromise);
        return resultPromise;
    }

    @Override
    @NotNull
    public Promise<T> async() {
        if (this.isComplete()) {
            SettablePromise promise = new SettablePromise();
            Eventloop.getCurrentEventloop().post(RunnableWithContext.wrapContext(promise, (Runnable)(this.exception == null ? () -> promise.set(this.result) : () -> promise.setException(this.exception))));
            return promise;
        }
        return this;
    }

    @Override
    @NotNull
    public <U, V> Promise<V> combine(@NotNull Promise<? extends U> other, @NotNull BiFunctionEx<? super T, ? super U, ? extends V> fn) {
        if (this.isComplete()) {
            if (this.isResult()) {
                return other.map(otherResult -> fn.apply(this.getResult(), otherResult)).whenException(() -> Recyclers.recycle(this.getResult()));
            }
            other.whenResult(Recyclers::recycle);
            return this;
        }
        if (other.isComplete()) {
            if (other.isResult()) {
                return this.map(result -> fn.apply(result, other.getResult())).whenException(() -> Recyclers.recycle(other.getResult()));
            }
            this.whenResult(Recyclers::recycle);
            return other;
        }
        PromiseCombine<? super T, ? extends V, ? super U> resultPromise = new PromiseCombine<T, V, U>(fn);
        other.run(resultPromise::acceptOther);
        this.subscribe(resultPromise);
        return resultPromise;
    }

    @Override
    @NotNull
    public Promise<Void> both(@NotNull Promise<?> other) {
        if (this.isComplete()) {
            if (this.isResult()) {
                Recyclers.recycle(this.getResult());
                return other.map(AbstractPromise::recycleToVoid);
            }
            other.whenResult(Recyclers::recycle);
            return this;
        }
        if (other.isComplete()) {
            if (other.isResult()) {
                Recyclers.recycle(other.getResult());
                return this.map(AbstractPromise::recycleToVoid);
            }
            this.whenResult(Recyclers::recycle);
            return other;
        }
        PromiseBoth resultPromise = new PromiseBoth();
        other.run(resultPromise);
        this.subscribe(resultPromise);
        return resultPromise;
    }

    @Nullable
    protected static Void recycleToVoid(Object item) {
        Recyclers.recycle((Object)item);
        return null;
    }

    @Override
    @NotNull
    public Promise<T> either(@NotNull Promise<? extends T> other) {
        if (this.isComplete()) {
            if (this.isResult()) {
                other.whenResult(Recyclers::recycle);
                return this;
            }
            return other;
        }
        if (other.isComplete()) {
            if (other.isResult()) {
                this.whenResult(Recyclers::recycle);
                return other;
            }
            return this;
        }
        EitherPromise resultPromise = new EitherPromise();
        other.run(resultPromise);
        this.subscribe(resultPromise);
        return resultPromise;
    }

    @Override
    @NotNull
    public Promise<Try<T>> toTry() {
        if (this.isComplete()) {
            return Promise.of(this.isResult() ? Try.of(this.result) : Try.ofException((Exception)this.exception));
        }
        NextPromise resultPromise = new NextPromise<T, Try<T>>(){

            public void accept(T result, @Nullable Exception e) {
                if (e == null) {
                    this.complete(Try.of(result));
                } else {
                    this.complete(Try.ofException((Exception)e));
                }
            }

            @Override
            public String describe() {
                return ".toTry()";
            }
        };
        this.subscribe(resultPromise);
        return resultPromise;
    }

    @Override
    @NotNull
    public Promise<Void> toVoid() {
        if (this.isComplete()) {
            return this.isResult() ? Promise.complete() : this;
        }
        NextPromise resultPromise = new NextPromise<T, Void>(){

            public void accept(T result, @Nullable Exception e) {
                if (e == null) {
                    this.complete(null);
                } else {
                    this.completeExceptionally(e);
                }
            }

            @Override
            public String describe() {
                return ".toVoid()";
            }
        };
        this.subscribe(resultPromise);
        return resultPromise;
    }

    @Override
    public void run(@NotNull Callback<? super T> callback) {
        if (this.isComplete()) {
            callback.accept(this.result, this.exception);
            return;
        }
        this.subscribe(callback);
    }

    @Override
    @NotNull
    public CompletableFuture<T> toCompletableFuture() {
        if (this.isComplete()) {
            if (this.isResult()) {
                return CompletableFuture.completedFuture(this.result);
            }
            CompletableFuture future = new CompletableFuture();
            future.completeExceptionally(this.exception);
            return future;
        }
        final CompletableFuture future = new CompletableFuture();
        this.subscribe(new SimpleCallback<T>(){

            public void accept(T result, @Nullable Exception e) {
                if (e == null) {
                    future.complete(result);
                } else {
                    future.completeExceptionally(e);
                }
            }

            public String toString() {
                return ".toCompletableFuture()";
            }
        });
        return future;
    }

    private static <T> void appendChildren(StringBuilder sb, Callback<T> callback, String indent) {
        if (callback == null) {
            return;
        }
        if (callback instanceof CallbackList) {
            CallbackList callbackList = (CallbackList)callback;
            for (int i = 0; i < callbackList.index; ++i) {
                AbstractPromise.appendChildren(sb, callbackList.callbacks[i], indent);
            }
        } else {
            indent = indent + "\t";
            sb.append("\n");
            if (callback instanceof AbstractPromise) {
                sb.append(((AbstractPromise)callback).toString(indent));
            } else if (!(callback instanceof SimpleCallback)) {
                sb.append(indent).append(".whenComplete(").append(AbstractPromise.formatToString(callback)).append(')');
            } else {
                sb.append(indent + callback);
            }
        }
    }

    private static String formatToString(Object object) {
        return PACKAGE_NAME_AND_LAMBDA_PART.matcher(object.toString()).replaceAll("$1");
    }

    private String toString(String indent) {
        StringBuilder sb = new StringBuilder(indent);
        sb.append(this.describe());
        if (this.isComplete()) {
            sb.append('{');
            if (this.exception == null) {
                sb.append(this.result);
            } else {
                sb.append("exception=");
                sb.append(this.exception.getClass().getSimpleName());
            }
            sb.append('}');
        }
        AbstractPromise.appendChildren(sb, this.next, indent);
        return sb.toString();
    }

    protected String describe() {
        return "AbstractPromise";
    }

    public String toString() {
        return this.toString("");
    }

    static {
        Recyclers.register(AbstractPromise.class, promise -> promise.whenResult(Recyclers::recycle));
        CHECK = Checks.isEnabled(AbstractPromise.class);
        PROMISE_NOT_SET = new Object();
        RESET_CALLBACKS = ApplicationSettings.getBoolean(AbstractPromise.class, (String)"resetCallbacks", (boolean)false);
        NO_RESULT = new Object();
        PACKAGE_NAME_AND_LAMBDA_PART = Pattern.compile("^(?:\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*\\.)*((?:\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*?)\\$\\$Lambda\\$\\d+)/.*$");
    }

    private static class CallbackList<T>
    implements Callback<T> {
        private int index = 2;
        private Callback<? super T>[] callbacks = new Callback[4];

        public CallbackList(Callback<? super T> first, Callback<? super T> second) {
            this.callbacks[0] = first;
            this.callbacks[1] = second;
        }

        public void add(Callback<? super T> callback) {
            if (this.index == this.callbacks.length) {
                this.callbacks = Arrays.copyOf(this.callbacks, this.callbacks.length * 2);
            }
            this.callbacks[this.index++] = callback;
        }

        public void accept(T result, @Nullable Exception e) {
            for (int i = 0; i < this.index; ++i) {
                this.callbacks[i].accept(result, e);
            }
        }
    }

    private static class PromiseCombine<T, V, U>
    extends NextPromise<T, V> {
        final BiFunctionEx<? super T, ? super U, ? extends V> fn;
        @Nullable
        T thisResult = AbstractPromise.access$100();
        @Nullable
        U otherResult = AbstractPromise.access$100();

        PromiseCombine(BiFunctionEx<? super T, ? super U, ? extends V> fn) {
            this.fn = fn;
        }

        public void accept(T result, @Nullable Exception e) {
            if (e == null) {
                if (this.otherResult != NO_RESULT) {
                    this.onBothResults(result, this.otherResult);
                } else {
                    this.thisResult = result;
                }
            } else {
                this.onAnyException(e);
            }
        }

        public void acceptOther(U result, @Nullable Exception e) {
            if (e == null) {
                if (this.thisResult != NO_RESULT) {
                    this.onBothResults(this.thisResult, result);
                } else {
                    this.otherResult = result;
                }
            } else {
                this.onAnyException(e);
            }
        }

        void onBothResults(@Nullable T thisResult, @Nullable U otherResult) {
            try {
                this.tryComplete(this.fn.apply(thisResult, otherResult));
            }
            catch (Exception e) {
                FatalErrorHandlers.handleError((Throwable)e, this.fn);
                this.tryCompleteExceptionally(e);
            }
        }

        void onAnyException(@NotNull Exception e) {
            if (this.tryCompleteExceptionally(e)) {
                if (this.thisResult != NO_RESULT) {
                    Recyclers.recycle(this.thisResult);
                }
                if (this.otherResult != NO_RESULT) {
                    Recyclers.recycle(this.otherResult);
                }
            }
        }

        @Override
        public String describe() {
            return ".combine(" + AbstractPromise.formatToString(this.fn) + ')';
        }
    }

    private static class PromiseBoth<T>
    extends NextPromise<T, Void> {
        int counter = 2;

        private PromiseBoth() {
        }

        public void accept(T result, @Nullable Exception e) {
            if (e == null) {
                Recyclers.recycle(result);
                if (--this.counter == 0) {
                    this.complete(null);
                }
            } else {
                this.tryCompleteExceptionally(e);
            }
        }

        @Override
        public String describe() {
            return ".both()";
        }
    }

    private static final class EitherPromise<T>
    extends NextPromise<T, T> {
        int errors = 2;

        private EitherPromise() {
        }

        public void accept(T result, @Nullable Exception e) {
            if (e == null) {
                if (!this.tryComplete(result)) {
                    Recyclers.recycle(result);
                }
            } else if (--this.errors == 0) {
                this.completeExceptionally(new Exception("Both promises completed exceptionally"));
            }
        }

        @Override
        public String describe() {
            return ".either()";
        }
    }
}

