/*
 * Decompiled with CFR 0.152.
 */
package io.activej.trigger;

import io.activej.common.builder.AbstractBuilder;
import io.activej.common.initializer.Initializer;
import io.activej.inject.Injector;
import io.activej.inject.Key;
import io.activej.inject.annotation.Provides;
import io.activej.inject.annotation.ProvidesIntoSet;
import io.activej.inject.binding.Binding;
import io.activej.inject.binding.BindingType;
import io.activej.inject.binding.OptionalDependency;
import io.activej.inject.module.AbstractModule;
import io.activej.launcher.LauncherService;
import io.activej.trigger.HasTriggers;
import io.activej.trigger.Severity;
import io.activej.trigger.TriggerRegistry;
import io.activej.trigger.TriggerResult;
import io.activej.trigger.Triggers;
import io.activej.trigger.TriggersModuleSettings;
import io.activej.trigger.util.KeyWithWorkerData;
import io.activej.trigger.util.Utils;
import io.activej.worker.WorkerPool;
import io.activej.worker.WorkerPools;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.function.Supplier;

public final class TriggersModule
extends AbstractModule {
    private Function<Key<?>, String> keyToString = Utils::prettyPrintSimpleKeyName;
    private final Map<Class<?>, Set<TriggerConfig<?>>> classSettings = new LinkedHashMap();
    private final Map<Key<?>, Set<TriggerConfig<?>>> keySettings = new LinkedHashMap();

    private TriggersModule() {
    }

    public static TriggersModule create() {
        return (TriggersModule)((Object)TriggersModule.builder().build());
    }

    public static Builder builder() {
        return new TriggersModule().new Builder();
    }

    @Provides
    Triggers triggers() {
        return Triggers.create();
    }

    @ProvidesIntoSet
    LauncherService service(final Injector injector, final Triggers triggers, OptionalDependency<Set<Initializer<TriggersModuleSettings>>> initializers) {
        Builder builder = new Builder();
        for (Initializer initializer : (Set)initializers.orElse(Set.of())) {
            initializer.initialize((Object)builder);
        }
        return new LauncherService(){

            public CompletableFuture<?> start() {
                TriggersModule.this.doStart(injector, triggers);
                return CompletableFuture.completedFuture(null);
            }

            public CompletableFuture<?> stop() {
                return CompletableFuture.completedFuture(null);
            }
        };
    }

    private void doStart(Injector injector, Triggers triggers) {
        LinkedHashMap<KeyWithWorkerData, List<TriggerRegistryRecord>> triggersMap = new LinkedHashMap<KeyWithWorkerData, List<TriggerRegistryRecord>>();
        for (Map.Entry entry : injector.peekInstances().entrySet()) {
            Key key = (Key)entry.getKey();
            Object instance = entry.getValue();
            if (instance == null) continue;
            this.scanSingleton(injector, triggersMap, key, instance);
        }
        WorkerPools workerPools = (WorkerPools)injector.peekInstance(WorkerPools.class);
        if (workerPools != null) {
            for (WorkerPool workerPool : workerPools.getWorkerPools()) {
                if (workerPool.getSize() == 0) continue;
                for (Map.Entry entry : workerPool.peekInstances().entrySet()) {
                    Key key = (Key)entry.getKey();
                    List instances = ((WorkerPool.Instances)entry.getValue()).getList();
                    this.scanWorkers(workerPool, triggersMap, key, instances);
                }
            }
        }
        for (KeyWithWorkerData keyWithWorkerData : triggersMap.keySet()) {
            for (TriggerRegistryRecord triggerRegistryRecord : triggersMap.getOrDefault(keyWithWorkerData, List.of())) {
                triggers.addTrigger(triggerRegistryRecord.severity, Utils.prettyPrintSimpleKeyName(keyWithWorkerData.getKey()), triggerRegistryRecord.name, triggerRegistryRecord.triggerFunction);
            }
        }
    }

    private void scanSingleton(Injector injector, Map<KeyWithWorkerData, List<TriggerRegistryRecord>> triggersMap, Key<?> key, Object instance) {
        if (key.getRawType() == OptionalDependency.class) {
            OptionalDependency optional = (OptionalDependency)instance;
            if (!optional.isPresent()) {
                return;
            }
            Binding binding = injector.getBinding(key);
            if (binding == null || binding.getType() == BindingType.SYNTHETIC) {
                return;
            }
            instance = optional.get();
            key = key.getTypeParameter(0).qualified(key.getQualifier());
        }
        KeyWithWorkerData internalKey = new KeyWithWorkerData(key);
        this.scanHasTriggers(triggersMap, internalKey, instance);
        this.scanClassSettings(triggersMap, internalKey, instance);
        this.scanKeySettings(triggersMap, internalKey, instance);
    }

    private void scanWorkers(WorkerPool workerPool, Map<KeyWithWorkerData, List<TriggerRegistryRecord>> triggersMap, Key<?> key, List<?> workerInstances) {
        Injector injector = workerPool.getScopeInjectors()[0];
        if (key.getRawType() == OptionalDependency.class) {
            Binding binding = injector.getBinding(key);
            if (binding == null || binding.getType() == BindingType.SYNTHETIC) {
                return;
            }
            ArrayList instances = new ArrayList(workerInstances.size());
            for (Object workerInstance : workerInstances) {
                instances.add(((OptionalDependency)workerInstance).orElse(null));
            }
            key = key.getTypeParameter(0).qualified(key.getQualifier());
            workerInstances = instances;
        }
        for (int i = 0; i < workerInstances.size(); ++i) {
            Object instance = workerInstances.get(i);
            if (instance == null) continue;
            KeyWithWorkerData internalKey = new KeyWithWorkerData(key, workerPool, i);
            this.scanHasTriggers(triggersMap, internalKey, instance);
            this.scanClassSettings(triggersMap, internalKey, instance);
            this.scanKeySettings(triggersMap, internalKey, instance);
        }
    }

    private void scanHasTriggers(final Map<KeyWithWorkerData, List<TriggerRegistryRecord>> triggers, final KeyWithWorkerData internalKey, Object instance) {
        if (instance instanceof HasTriggers) {
            ((HasTriggers)instance).registerTriggers(new TriggerRegistry(){

                @Override
                public Key<?> getComponentKey() {
                    return internalKey.getKey();
                }

                @Override
                public String getComponentName() {
                    return TriggersModule.this.keyToString.apply(internalKey.getKey());
                }

                @Override
                public void add(Severity severity, String name, Supplier<TriggerResult> triggerFunction) {
                    triggers.computeIfAbsent(internalKey, $ -> new ArrayList()).add(new TriggerRegistryRecord(severity, name, triggerFunction));
                }
            });
        }
    }

    private void scanClassSettings(Map<KeyWithWorkerData, List<TriggerRegistryRecord>> triggers, KeyWithWorkerData internalKey, Object instance) {
        for (Map.Entry<Class<?>, Set<TriggerConfig<?>>> entry : this.classSettings.entrySet()) {
            for (TriggerConfig<?> config : entry.getValue()) {
                if (!entry.getKey().isAssignableFrom(instance.getClass())) continue;
                triggers.computeIfAbsent(internalKey, $ -> new ArrayList()).add(new TriggerRegistryRecord(config.severity, config.name, () -> config.triggerFunction.apply(instance)));
            }
        }
    }

    private void scanKeySettings(Map<KeyWithWorkerData, List<TriggerRegistryRecord>> triggers, KeyWithWorkerData internalKey, Object instance) {
        Key<?> key = internalKey.getKey();
        for (TriggerConfig config : this.keySettings.getOrDefault(key, Set.of())) {
            triggers.computeIfAbsent(internalKey, $ -> new ArrayList()).add(new TriggerRegistryRecord(config.severity, config.name, () -> config.triggerFunction.apply(instance)));
        }
    }

    public final class Builder
    extends AbstractBuilder<Builder, TriggersModule>
    implements TriggersModuleSettings {
        private Builder() {
        }

        @Override
        public Builder withNaming(Function<Key<?>, String> keyToString) {
            Builder.checkNotBuilt((AbstractBuilder)this);
            TriggersModule.this.keyToString = keyToString;
            return this;
        }

        @Override
        public <T> Builder with(Class<T> type, Severity severity, String name, Function<T, TriggerResult> triggerFunction) {
            Builder.checkNotBuilt((AbstractBuilder)this);
            Set triggerConfigs = TriggersModule.this.classSettings.computeIfAbsent(type, $ -> new LinkedHashSet());
            if (!triggerConfigs.add(new TriggerConfig<T>(severity, name, triggerFunction))) {
                throw new IllegalArgumentException("Cannot assign duplicate trigger");
            }
            return this;
        }

        @Override
        public <T> Builder with(Key<T> key, Severity severity, String name, Function<T, TriggerResult> triggerFunction) {
            Builder.checkNotBuilt((AbstractBuilder)this);
            Set triggerConfigs = TriggersModule.this.keySettings.computeIfAbsent(key, $ -> new LinkedHashSet());
            if (!triggerConfigs.add(new TriggerConfig<T>(severity, name, triggerFunction))) {
                throw new IllegalArgumentException("Cannot assign duplicate trigger");
            }
            return this;
        }

        protected TriggersModule doBuild() {
            return TriggersModule.this;
        }
    }

    public record TriggerRegistryRecord(Severity severity, String name, Supplier<TriggerResult> triggerFunction) {
    }

    public record TriggerConfig<T>(Severity severity, String name, Function<T, TriggerResult> triggerFunction) {
        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TriggerConfig that = (TriggerConfig)o;
            return this.severity == that.severity && Objects.equals(this.name, that.name);
        }

        @Override
        public int hashCode() {
            return Objects.hash(new Object[]{this.severity, this.name});
        }
    }
}

