/*
 * Decompiled with CFR 0.152.
 */
package io.activej.trigger.util;

import io.activej.inject.Key;
import io.activej.worker.WorkerPool;
import java.util.Objects;
import org.jetbrains.annotations.Nullable;

public final class KeyWithWorkerData {
    private final Key<?> key;
    @Nullable
    private final WorkerPool pool;
    private final int workerId;

    public KeyWithWorkerData(Key<?> key) {
        this(key, null, -1);
    }

    public KeyWithWorkerData(Key<?> key, @Nullable WorkerPool pool, int workerId) {
        this.key = key;
        this.pool = pool;
        this.workerId = workerId;
    }

    public Key<?> getKey() {
        return this.key;
    }

    @Nullable
    public WorkerPool getPool() {
        return this.pool;
    }

    public int getWorkerId() {
        return this.workerId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        KeyWithWorkerData that = (KeyWithWorkerData)o;
        return this.workerId == that.workerId && this.key.equals(that.key) && Objects.equals(this.pool, that.pool);
    }

    public int hashCode() {
        return 31 * (31 * this.key.hashCode() + (this.pool != null ? this.pool.hashCode() : 0)) + this.workerId;
    }

    public String toString() {
        return "KeyWithWorkerData{key=" + this.key + ", pool=" + this.pool + ", workerId=" + this.workerId + "}";
    }
}

