/*
 * Decompiled with CFR 0.152.
 */
package io.activej.trigger.util;

import io.activej.inject.Key;
import io.activej.types.Types;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Type;

public final class Utils {
    public static String prettyPrintQualifier(Object qualifier) {
        if (qualifier instanceof Annotation) {
            return Utils.prettyPrintAnnotation((Annotation)qualifier);
        }
        if (qualifier instanceof Class && ((Class)qualifier).isAnnotation()) {
            return "@" + ((Class)qualifier).getSimpleName();
        }
        return qualifier.toString();
    }

    public static String prettyPrintAnnotation(Annotation annotation) {
        String simpleName;
        StringBuilder sb = new StringBuilder();
        Method[] methods = annotation.annotationType().getDeclaredMethods();
        boolean first = true;
        if (methods.length != 0) {
            for (Method m : methods) {
                try {
                    Object value = m.invoke((Object)annotation, new Object[0]);
                    if (value.equals(m.getDefaultValue())) continue;
                    Object valueStr = value instanceof String ? "\"" + value + "\"" : value.toString();
                    String methodName = m.getName();
                    if ("value".equals(methodName) && first) {
                        sb.append((String)valueStr);
                    } else {
                        sb.append((first ? "" : ",") + methodName + "=" + (String)valueStr);
                    }
                    first = false;
                }
                catch (ReflectiveOperationException reflectiveOperationException) {
                    // empty catch block
                }
            }
        }
        return "@" + ("NamedImpl".equals(simpleName = annotation.annotationType().getSimpleName()) ? "Named" : simpleName) + (String)(first ? "" : "(" + sb + ")");
    }

    public static String prettyPrintSimpleKeyName(Key<?> key) {
        Type type = key.getType();
        return (String)(key.getQualifier() != null ? Utils.prettyPrintQualifier(key.getQualifier()) + " " : "") + Types.getSimpleName((Type)type);
    }
}

