/* Generated SBE (Simple Binary Encoding) message codec. */
package io.aeron.archive.codecs;

import org.agrona.DirectBuffer;


/**
 * Used as first element in Catalog to set the version and alignment of entries.
 */
@SuppressWarnings("all")
public final class CatalogHeaderDecoder
{
    public static final int BLOCK_LENGTH = 32;
    public static final int TEMPLATE_ID = 20;
    public static final int SCHEMA_ID = 101;
    public static final int SCHEMA_VERSION = 7;
    public static final java.nio.ByteOrder BYTE_ORDER = java.nio.ByteOrder.LITTLE_ENDIAN;

    private final CatalogHeaderDecoder parentMessage = this;
    private DirectBuffer buffer;
    private int initialOffset;
    private int offset;
    private int limit;
    int actingBlockLength;
    int actingVersion;

    public int sbeBlockLength()
    {
        return BLOCK_LENGTH;
    }

    public int sbeTemplateId()
    {
        return TEMPLATE_ID;
    }

    public int sbeSchemaId()
    {
        return SCHEMA_ID;
    }

    public int sbeSchemaVersion()
    {
        return SCHEMA_VERSION;
    }

    public String sbeSemanticType()
    {
        return "";
    }

    public DirectBuffer buffer()
    {
        return buffer;
    }

    public int initialOffset()
    {
        return initialOffset;
    }

    public int offset()
    {
        return offset;
    }

    public CatalogHeaderDecoder wrap(
        final DirectBuffer buffer,
        final int offset,
        final int actingBlockLength,
        final int actingVersion)
    {
        if (buffer != this.buffer)
        {
            this.buffer = buffer;
        }
        this.initialOffset = offset;
        this.offset = offset;
        this.actingBlockLength = actingBlockLength;
        this.actingVersion = actingVersion;
        limit(offset + actingBlockLength);

        return this;
    }

    public CatalogHeaderDecoder wrapAndApplyHeader(
        final DirectBuffer buffer,
        final int offset,
        final MessageHeaderDecoder headerDecoder)
    {
        headerDecoder.wrap(buffer, offset);

        final int templateId = headerDecoder.templateId();
        if (TEMPLATE_ID != templateId)
        {
            throw new IllegalStateException("Invalid TEMPLATE_ID: " + templateId);
        }

        return wrap(
            buffer,
            offset + MessageHeaderDecoder.ENCODED_LENGTH,
            headerDecoder.blockLength(),
            headerDecoder.version());
    }

    public CatalogHeaderDecoder sbeRewind()
    {
        return wrap(buffer, initialOffset, actingBlockLength, actingVersion);
    }

    public int sbeDecodedLength()
    {
        final int currentLimit = limit();
        sbeSkip();
        final int decodedLength = encodedLength();
        limit(currentLimit);

        return decodedLength;
    }

    public int encodedLength()
    {
        return limit - offset;
    }

    public int limit()
    {
        return limit;
    }

    public void limit(final int limit)
    {
        this.limit = limit;
    }

    public static int versionId()
    {
        return 1;
    }

    public static int versionSinceVersion()
    {
        return 0;
    }

    public static int versionEncodingOffset()
    {
        return 0;
    }

    public static int versionEncodingLength()
    {
        return 4;
    }

    public static String versionMetaAttribute(final MetaAttribute metaAttribute)
    {
        if (MetaAttribute.PRESENCE == metaAttribute)
        {
            return "required";
        }

        return "";
    }

    public static int versionNullValue()
    {
        return -2147483648;
    }

    public static int versionMinValue()
    {
        return -2147483647;
    }

    public static int versionMaxValue()
    {
        return 2147483647;
    }

    public int version()
    {
        return buffer.getInt(offset + 0, java.nio.ByteOrder.LITTLE_ENDIAN);
    }


    public static int lengthId()
    {
        return 2;
    }

    public static int lengthSinceVersion()
    {
        return 0;
    }

    public static int lengthEncodingOffset()
    {
        return 4;
    }

    public static int lengthEncodingLength()
    {
        return 4;
    }

    public static String lengthMetaAttribute(final MetaAttribute metaAttribute)
    {
        if (MetaAttribute.PRESENCE == metaAttribute)
        {
            return "required";
        }

        return "";
    }

    public static int lengthNullValue()
    {
        return -2147483648;
    }

    public static int lengthMinValue()
    {
        return -2147483647;
    }

    public static int lengthMaxValue()
    {
        return 2147483647;
    }

    public int length()
    {
        return buffer.getInt(offset + 4, java.nio.ByteOrder.LITTLE_ENDIAN);
    }


    public static int nextRecordingIdId()
    {
        return 3;
    }

    public static int nextRecordingIdSinceVersion()
    {
        return 0;
    }

    public static int nextRecordingIdEncodingOffset()
    {
        return 8;
    }

    public static int nextRecordingIdEncodingLength()
    {
        return 8;
    }

    public static String nextRecordingIdMetaAttribute(final MetaAttribute metaAttribute)
    {
        if (MetaAttribute.PRESENCE == metaAttribute)
        {
            return "required";
        }

        return "";
    }

    public static long nextRecordingIdNullValue()
    {
        return -9223372036854775808L;
    }

    public static long nextRecordingIdMinValue()
    {
        return -9223372036854775807L;
    }

    public static long nextRecordingIdMaxValue()
    {
        return 9223372036854775807L;
    }

    public long nextRecordingId()
    {
        return buffer.getLong(offset + 8, java.nio.ByteOrder.LITTLE_ENDIAN);
    }


    public static int alignmentId()
    {
        return 4;
    }

    public static int alignmentSinceVersion()
    {
        return 0;
    }

    public static int alignmentEncodingOffset()
    {
        return 16;
    }

    public static int alignmentEncodingLength()
    {
        return 4;
    }

    public static String alignmentMetaAttribute(final MetaAttribute metaAttribute)
    {
        if (MetaAttribute.PRESENCE == metaAttribute)
        {
            return "required";
        }

        return "";
    }

    public static int alignmentNullValue()
    {
        return -2147483648;
    }

    public static int alignmentMinValue()
    {
        return -2147483647;
    }

    public static int alignmentMaxValue()
    {
        return 2147483647;
    }

    public int alignment()
    {
        return buffer.getInt(offset + 16, java.nio.ByteOrder.LITTLE_ENDIAN);
    }


    public static int reservedId()
    {
        return 5;
    }

    public static int reservedSinceVersion()
    {
        return 0;
    }

    public static int reservedEncodingOffset()
    {
        return 31;
    }

    public static int reservedEncodingLength()
    {
        return 1;
    }

    public static String reservedMetaAttribute(final MetaAttribute metaAttribute)
    {
        if (MetaAttribute.PRESENCE == metaAttribute)
        {
            return "required";
        }

        return "";
    }

    public static byte reservedNullValue()
    {
        return (byte)-128;
    }

    public static byte reservedMinValue()
    {
        return (byte)-127;
    }

    public static byte reservedMaxValue()
    {
        return (byte)127;
    }

    public byte reserved()
    {
        return buffer.getByte(offset + 31);
    }


    public String toString()
    {
        if (null == buffer)
        {
            return "";
        }

        final CatalogHeaderDecoder decoder = new CatalogHeaderDecoder();
        decoder.wrap(buffer, initialOffset, actingBlockLength, actingVersion);

        return decoder.appendTo(new StringBuilder()).toString();
    }

    public StringBuilder appendTo(final StringBuilder builder)
    {
        if (null == buffer)
        {
            return builder;
        }

        final int originalLimit = limit();
        limit(initialOffset + actingBlockLength);
        builder.append("[CatalogHeader](sbeTemplateId=");
        builder.append(TEMPLATE_ID);
        builder.append("|sbeSchemaId=");
        builder.append(SCHEMA_ID);
        builder.append("|sbeSchemaVersion=");
        if (parentMessage.actingVersion != SCHEMA_VERSION)
        {
            builder.append(parentMessage.actingVersion);
            builder.append('/');
        }
        builder.append(SCHEMA_VERSION);
        builder.append("|sbeBlockLength=");
        if (actingBlockLength != BLOCK_LENGTH)
        {
            builder.append(actingBlockLength);
            builder.append('/');
        }
        builder.append(BLOCK_LENGTH);
        builder.append("):");
        builder.append("version=");
        builder.append(this.version());
        builder.append('|');
        builder.append("length=");
        builder.append(this.length());
        builder.append('|');
        builder.append("nextRecordingId=");
        builder.append(this.nextRecordingId());
        builder.append('|');
        builder.append("alignment=");
        builder.append(this.alignment());
        builder.append('|');
        builder.append("reserved=");
        builder.append(this.reserved());

        limit(originalLimit);

        return builder;
    }
    
    public CatalogHeaderDecoder sbeSkip()
    {
        sbeRewind();

        return this;
    }
}
