/* Generated SBE (Simple Binary Encoding) message codec. */
package io.aeron.archive.codecs;

import org.agrona.MutableDirectBuffer;
import org.agrona.DirectBuffer;


/**
 * Describes a recording in the catalog.
 */
@SuppressWarnings("all")
public final class RecordingDescriptorDecoder
{
    public static final int BLOCK_LENGTH = 80;
    public static final int TEMPLATE_ID = 22;
    public static final int SCHEMA_ID = 101;
    public static final int SCHEMA_VERSION = 7;
    public static final java.nio.ByteOrder BYTE_ORDER = java.nio.ByteOrder.LITTLE_ENDIAN;

    private final RecordingDescriptorDecoder parentMessage = this;
    private DirectBuffer buffer;
    private int initialOffset;
    private int offset;
    private int limit;
    int actingBlockLength;
    int actingVersion;

    public int sbeBlockLength()
    {
        return BLOCK_LENGTH;
    }

    public int sbeTemplateId()
    {
        return TEMPLATE_ID;
    }

    public int sbeSchemaId()
    {
        return SCHEMA_ID;
    }

    public int sbeSchemaVersion()
    {
        return SCHEMA_VERSION;
    }

    public String sbeSemanticType()
    {
        return "";
    }

    public DirectBuffer buffer()
    {
        return buffer;
    }

    public int initialOffset()
    {
        return initialOffset;
    }

    public int offset()
    {
        return offset;
    }

    public RecordingDescriptorDecoder wrap(
        final DirectBuffer buffer,
        final int offset,
        final int actingBlockLength,
        final int actingVersion)
    {
        if (buffer != this.buffer)
        {
            this.buffer = buffer;
        }
        this.initialOffset = offset;
        this.offset = offset;
        this.actingBlockLength = actingBlockLength;
        this.actingVersion = actingVersion;
        limit(offset + actingBlockLength);

        return this;
    }

    public RecordingDescriptorDecoder wrapAndApplyHeader(
        final DirectBuffer buffer,
        final int offset,
        final MessageHeaderDecoder headerDecoder)
    {
        headerDecoder.wrap(buffer, offset);

        final int templateId = headerDecoder.templateId();
        if (TEMPLATE_ID != templateId)
        {
            throw new IllegalStateException("Invalid TEMPLATE_ID: " + templateId);
        }

        return wrap(
            buffer,
            offset + MessageHeaderDecoder.ENCODED_LENGTH,
            headerDecoder.blockLength(),
            headerDecoder.version());
    }

    public RecordingDescriptorDecoder sbeRewind()
    {
        return wrap(buffer, initialOffset, actingBlockLength, actingVersion);
    }

    public int sbeDecodedLength()
    {
        final int currentLimit = limit();
        sbeSkip();
        final int decodedLength = encodedLength();
        limit(currentLimit);

        return decodedLength;
    }

    public int encodedLength()
    {
        return limit - offset;
    }

    public int limit()
    {
        return limit;
    }

    public void limit(final int limit)
    {
        this.limit = limit;
    }

    public static int controlSessionIdId()
    {
        return 1;
    }

    public static int controlSessionIdSinceVersion()
    {
        return 0;
    }

    public static int controlSessionIdEncodingOffset()
    {
        return 0;
    }

    public static int controlSessionIdEncodingLength()
    {
        return 8;
    }

    public static String controlSessionIdMetaAttribute(final MetaAttribute metaAttribute)
    {
        if (MetaAttribute.PRESENCE == metaAttribute)
        {
            return "required";
        }

        return "";
    }

    public static long controlSessionIdNullValue()
    {
        return -9223372036854775808L;
    }

    public static long controlSessionIdMinValue()
    {
        return -9223372036854775807L;
    }

    public static long controlSessionIdMaxValue()
    {
        return 9223372036854775807L;
    }

    public long controlSessionId()
    {
        return buffer.getLong(offset + 0, java.nio.ByteOrder.LITTLE_ENDIAN);
    }


    public static int correlationIdId()
    {
        return 2;
    }

    public static int correlationIdSinceVersion()
    {
        return 0;
    }

    public static int correlationIdEncodingOffset()
    {
        return 8;
    }

    public static int correlationIdEncodingLength()
    {
        return 8;
    }

    public static String correlationIdMetaAttribute(final MetaAttribute metaAttribute)
    {
        if (MetaAttribute.PRESENCE == metaAttribute)
        {
            return "required";
        }

        return "";
    }

    public static long correlationIdNullValue()
    {
        return -9223372036854775808L;
    }

    public static long correlationIdMinValue()
    {
        return -9223372036854775807L;
    }

    public static long correlationIdMaxValue()
    {
        return 9223372036854775807L;
    }

    public long correlationId()
    {
        return buffer.getLong(offset + 8, java.nio.ByteOrder.LITTLE_ENDIAN);
    }


    public static int recordingIdId()
    {
        return 3;
    }

    public static int recordingIdSinceVersion()
    {
        return 0;
    }

    public static int recordingIdEncodingOffset()
    {
        return 16;
    }

    public static int recordingIdEncodingLength()
    {
        return 8;
    }

    public static String recordingIdMetaAttribute(final MetaAttribute metaAttribute)
    {
        if (MetaAttribute.PRESENCE == metaAttribute)
        {
            return "required";
        }

        return "";
    }

    public static long recordingIdNullValue()
    {
        return -9223372036854775808L;
    }

    public static long recordingIdMinValue()
    {
        return -9223372036854775807L;
    }

    public static long recordingIdMaxValue()
    {
        return 9223372036854775807L;
    }

    public long recordingId()
    {
        return buffer.getLong(offset + 16, java.nio.ByteOrder.LITTLE_ENDIAN);
    }


    public static int startTimestampId()
    {
        return 4;
    }

    public static int startTimestampSinceVersion()
    {
        return 0;
    }

    public static int startTimestampEncodingOffset()
    {
        return 24;
    }

    public static int startTimestampEncodingLength()
    {
        return 8;
    }

    public static String startTimestampMetaAttribute(final MetaAttribute metaAttribute)
    {
        if (MetaAttribute.PRESENCE == metaAttribute)
        {
            return "required";
        }

        return "";
    }

    public static long startTimestampNullValue()
    {
        return -9223372036854775808L;
    }

    public static long startTimestampMinValue()
    {
        return -9223372036854775807L;
    }

    public static long startTimestampMaxValue()
    {
        return 9223372036854775807L;
    }

    public long startTimestamp()
    {
        return buffer.getLong(offset + 24, java.nio.ByteOrder.LITTLE_ENDIAN);
    }


    public static int stopTimestampId()
    {
        return 5;
    }

    public static int stopTimestampSinceVersion()
    {
        return 0;
    }

    public static int stopTimestampEncodingOffset()
    {
        return 32;
    }

    public static int stopTimestampEncodingLength()
    {
        return 8;
    }

    public static String stopTimestampMetaAttribute(final MetaAttribute metaAttribute)
    {
        if (MetaAttribute.PRESENCE == metaAttribute)
        {
            return "required";
        }

        return "";
    }

    public static long stopTimestampNullValue()
    {
        return -9223372036854775808L;
    }

    public static long stopTimestampMinValue()
    {
        return -9223372036854775807L;
    }

    public static long stopTimestampMaxValue()
    {
        return 9223372036854775807L;
    }

    public long stopTimestamp()
    {
        return buffer.getLong(offset + 32, java.nio.ByteOrder.LITTLE_ENDIAN);
    }


    public static int startPositionId()
    {
        return 6;
    }

    public static int startPositionSinceVersion()
    {
        return 0;
    }

    public static int startPositionEncodingOffset()
    {
        return 40;
    }

    public static int startPositionEncodingLength()
    {
        return 8;
    }

    public static String startPositionMetaAttribute(final MetaAttribute metaAttribute)
    {
        if (MetaAttribute.PRESENCE == metaAttribute)
        {
            return "required";
        }

        return "";
    }

    public static long startPositionNullValue()
    {
        return -9223372036854775808L;
    }

    public static long startPositionMinValue()
    {
        return -9223372036854775807L;
    }

    public static long startPositionMaxValue()
    {
        return 9223372036854775807L;
    }

    public long startPosition()
    {
        return buffer.getLong(offset + 40, java.nio.ByteOrder.LITTLE_ENDIAN);
    }


    public static int stopPositionId()
    {
        return 7;
    }

    public static int stopPositionSinceVersion()
    {
        return 0;
    }

    public static int stopPositionEncodingOffset()
    {
        return 48;
    }

    public static int stopPositionEncodingLength()
    {
        return 8;
    }

    public static String stopPositionMetaAttribute(final MetaAttribute metaAttribute)
    {
        if (MetaAttribute.PRESENCE == metaAttribute)
        {
            return "required";
        }

        return "";
    }

    public static long stopPositionNullValue()
    {
        return -9223372036854775808L;
    }

    public static long stopPositionMinValue()
    {
        return -9223372036854775807L;
    }

    public static long stopPositionMaxValue()
    {
        return 9223372036854775807L;
    }

    public long stopPosition()
    {
        return buffer.getLong(offset + 48, java.nio.ByteOrder.LITTLE_ENDIAN);
    }


    public static int initialTermIdId()
    {
        return 8;
    }

    public static int initialTermIdSinceVersion()
    {
        return 0;
    }

    public static int initialTermIdEncodingOffset()
    {
        return 56;
    }

    public static int initialTermIdEncodingLength()
    {
        return 4;
    }

    public static String initialTermIdMetaAttribute(final MetaAttribute metaAttribute)
    {
        if (MetaAttribute.PRESENCE == metaAttribute)
        {
            return "required";
        }

        return "";
    }

    public static int initialTermIdNullValue()
    {
        return -2147483648;
    }

    public static int initialTermIdMinValue()
    {
        return -2147483647;
    }

    public static int initialTermIdMaxValue()
    {
        return 2147483647;
    }

    public int initialTermId()
    {
        return buffer.getInt(offset + 56, java.nio.ByteOrder.LITTLE_ENDIAN);
    }


    public static int segmentFileLengthId()
    {
        return 9;
    }

    public static int segmentFileLengthSinceVersion()
    {
        return 0;
    }

    public static int segmentFileLengthEncodingOffset()
    {
        return 60;
    }

    public static int segmentFileLengthEncodingLength()
    {
        return 4;
    }

    public static String segmentFileLengthMetaAttribute(final MetaAttribute metaAttribute)
    {
        if (MetaAttribute.PRESENCE == metaAttribute)
        {
            return "required";
        }

        return "";
    }

    public static int segmentFileLengthNullValue()
    {
        return -2147483648;
    }

    public static int segmentFileLengthMinValue()
    {
        return -2147483647;
    }

    public static int segmentFileLengthMaxValue()
    {
        return 2147483647;
    }

    public int segmentFileLength()
    {
        return buffer.getInt(offset + 60, java.nio.ByteOrder.LITTLE_ENDIAN);
    }


    public static int termBufferLengthId()
    {
        return 10;
    }

    public static int termBufferLengthSinceVersion()
    {
        return 0;
    }

    public static int termBufferLengthEncodingOffset()
    {
        return 64;
    }

    public static int termBufferLengthEncodingLength()
    {
        return 4;
    }

    public static String termBufferLengthMetaAttribute(final MetaAttribute metaAttribute)
    {
        if (MetaAttribute.PRESENCE == metaAttribute)
        {
            return "required";
        }

        return "";
    }

    public static int termBufferLengthNullValue()
    {
        return -2147483648;
    }

    public static int termBufferLengthMinValue()
    {
        return -2147483647;
    }

    public static int termBufferLengthMaxValue()
    {
        return 2147483647;
    }

    public int termBufferLength()
    {
        return buffer.getInt(offset + 64, java.nio.ByteOrder.LITTLE_ENDIAN);
    }


    public static int mtuLengthId()
    {
        return 11;
    }

    public static int mtuLengthSinceVersion()
    {
        return 0;
    }

    public static int mtuLengthEncodingOffset()
    {
        return 68;
    }

    public static int mtuLengthEncodingLength()
    {
        return 4;
    }

    public static String mtuLengthMetaAttribute(final MetaAttribute metaAttribute)
    {
        if (MetaAttribute.PRESENCE == metaAttribute)
        {
            return "required";
        }

        return "";
    }

    public static int mtuLengthNullValue()
    {
        return -2147483648;
    }

    public static int mtuLengthMinValue()
    {
        return -2147483647;
    }

    public static int mtuLengthMaxValue()
    {
        return 2147483647;
    }

    public int mtuLength()
    {
        return buffer.getInt(offset + 68, java.nio.ByteOrder.LITTLE_ENDIAN);
    }


    public static int sessionIdId()
    {
        return 12;
    }

    public static int sessionIdSinceVersion()
    {
        return 0;
    }

    public static int sessionIdEncodingOffset()
    {
        return 72;
    }

    public static int sessionIdEncodingLength()
    {
        return 4;
    }

    public static String sessionIdMetaAttribute(final MetaAttribute metaAttribute)
    {
        if (MetaAttribute.PRESENCE == metaAttribute)
        {
            return "required";
        }

        return "";
    }

    public static int sessionIdNullValue()
    {
        return -2147483648;
    }

    public static int sessionIdMinValue()
    {
        return -2147483647;
    }

    public static int sessionIdMaxValue()
    {
        return 2147483647;
    }

    public int sessionId()
    {
        return buffer.getInt(offset + 72, java.nio.ByteOrder.LITTLE_ENDIAN);
    }


    public static int streamIdId()
    {
        return 13;
    }

    public static int streamIdSinceVersion()
    {
        return 0;
    }

    public static int streamIdEncodingOffset()
    {
        return 76;
    }

    public static int streamIdEncodingLength()
    {
        return 4;
    }

    public static String streamIdMetaAttribute(final MetaAttribute metaAttribute)
    {
        if (MetaAttribute.PRESENCE == metaAttribute)
        {
            return "required";
        }

        return "";
    }

    public static int streamIdNullValue()
    {
        return -2147483648;
    }

    public static int streamIdMinValue()
    {
        return -2147483647;
    }

    public static int streamIdMaxValue()
    {
        return 2147483647;
    }

    public int streamId()
    {
        return buffer.getInt(offset + 76, java.nio.ByteOrder.LITTLE_ENDIAN);
    }


    public static int strippedChannelId()
    {
        return 14;
    }

    public static int strippedChannelSinceVersion()
    {
        return 0;
    }

    public static String strippedChannelCharacterEncoding()
    {
        return java.nio.charset.StandardCharsets.US_ASCII.name();
    }

    public static String strippedChannelMetaAttribute(final MetaAttribute metaAttribute)
    {
        if (MetaAttribute.PRESENCE == metaAttribute)
        {
            return "required";
        }

        return "";
    }

    public static int strippedChannelHeaderLength()
    {
        return 4;
    }

    public int strippedChannelLength()
    {
        final int limit = parentMessage.limit();
        return (int)(buffer.getInt(limit, java.nio.ByteOrder.LITTLE_ENDIAN) & 0xFFFF_FFFFL);
    }

    public int skipStrippedChannel()
    {
        final int headerLength = 4;
        final int limit = parentMessage.limit();
        final int dataLength = (int)(buffer.getInt(limit, java.nio.ByteOrder.LITTLE_ENDIAN) & 0xFFFF_FFFFL);
        final int dataOffset = limit + headerLength;
        parentMessage.limit(dataOffset + dataLength);

        return dataLength;
    }

    public int getStrippedChannel(final MutableDirectBuffer dst, final int dstOffset, final int length)
    {
        final int headerLength = 4;
        final int limit = parentMessage.limit();
        final int dataLength = (int)(buffer.getInt(limit, java.nio.ByteOrder.LITTLE_ENDIAN) & 0xFFFF_FFFFL);
        final int bytesCopied = Math.min(length, dataLength);
        parentMessage.limit(limit + headerLength + dataLength);
        buffer.getBytes(limit + headerLength, dst, dstOffset, bytesCopied);

        return bytesCopied;
    }

    public int getStrippedChannel(final byte[] dst, final int dstOffset, final int length)
    {
        final int headerLength = 4;
        final int limit = parentMessage.limit();
        final int dataLength = (int)(buffer.getInt(limit, java.nio.ByteOrder.LITTLE_ENDIAN) & 0xFFFF_FFFFL);
        final int bytesCopied = Math.min(length, dataLength);
        parentMessage.limit(limit + headerLength + dataLength);
        buffer.getBytes(limit + headerLength, dst, dstOffset, bytesCopied);

        return bytesCopied;
    }

    public void wrapStrippedChannel(final DirectBuffer wrapBuffer)
    {
        final int headerLength = 4;
        final int limit = parentMessage.limit();
        final int dataLength = (int)(buffer.getInt(limit, java.nio.ByteOrder.LITTLE_ENDIAN) & 0xFFFF_FFFFL);
        parentMessage.limit(limit + headerLength + dataLength);
        wrapBuffer.wrap(buffer, limit + headerLength, dataLength);
    }

    public String strippedChannel()
    {
        final int headerLength = 4;
        final int limit = parentMessage.limit();
        final int dataLength = (int)(buffer.getInt(limit, java.nio.ByteOrder.LITTLE_ENDIAN) & 0xFFFF_FFFFL);
        parentMessage.limit(limit + headerLength + dataLength);

        if (0 == dataLength)
        {
            return "";
        }

        final byte[] tmp = new byte[dataLength];
        buffer.getBytes(limit + headerLength, tmp, 0, dataLength);

        return new String(tmp, java.nio.charset.StandardCharsets.US_ASCII);
    }

    public int getStrippedChannel(final Appendable appendable)
    {
        final int headerLength = 4;
        final int limit = parentMessage.limit();
        final int dataLength = (int)(buffer.getInt(limit, java.nio.ByteOrder.LITTLE_ENDIAN) & 0xFFFF_FFFFL);
        final int dataOffset = limit + headerLength;

        parentMessage.limit(dataOffset + dataLength);
        buffer.getStringWithoutLengthAscii(dataOffset, dataLength, appendable);

        return dataLength;
    }

    public static int originalChannelId()
    {
        return 15;
    }

    public static int originalChannelSinceVersion()
    {
        return 0;
    }

    public static String originalChannelCharacterEncoding()
    {
        return java.nio.charset.StandardCharsets.US_ASCII.name();
    }

    public static String originalChannelMetaAttribute(final MetaAttribute metaAttribute)
    {
        if (MetaAttribute.PRESENCE == metaAttribute)
        {
            return "required";
        }

        return "";
    }

    public static int originalChannelHeaderLength()
    {
        return 4;
    }

    public int originalChannelLength()
    {
        final int limit = parentMessage.limit();
        return (int)(buffer.getInt(limit, java.nio.ByteOrder.LITTLE_ENDIAN) & 0xFFFF_FFFFL);
    }

    public int skipOriginalChannel()
    {
        final int headerLength = 4;
        final int limit = parentMessage.limit();
        final int dataLength = (int)(buffer.getInt(limit, java.nio.ByteOrder.LITTLE_ENDIAN) & 0xFFFF_FFFFL);
        final int dataOffset = limit + headerLength;
        parentMessage.limit(dataOffset + dataLength);

        return dataLength;
    }

    public int getOriginalChannel(final MutableDirectBuffer dst, final int dstOffset, final int length)
    {
        final int headerLength = 4;
        final int limit = parentMessage.limit();
        final int dataLength = (int)(buffer.getInt(limit, java.nio.ByteOrder.LITTLE_ENDIAN) & 0xFFFF_FFFFL);
        final int bytesCopied = Math.min(length, dataLength);
        parentMessage.limit(limit + headerLength + dataLength);
        buffer.getBytes(limit + headerLength, dst, dstOffset, bytesCopied);

        return bytesCopied;
    }

    public int getOriginalChannel(final byte[] dst, final int dstOffset, final int length)
    {
        final int headerLength = 4;
        final int limit = parentMessage.limit();
        final int dataLength = (int)(buffer.getInt(limit, java.nio.ByteOrder.LITTLE_ENDIAN) & 0xFFFF_FFFFL);
        final int bytesCopied = Math.min(length, dataLength);
        parentMessage.limit(limit + headerLength + dataLength);
        buffer.getBytes(limit + headerLength, dst, dstOffset, bytesCopied);

        return bytesCopied;
    }

    public void wrapOriginalChannel(final DirectBuffer wrapBuffer)
    {
        final int headerLength = 4;
        final int limit = parentMessage.limit();
        final int dataLength = (int)(buffer.getInt(limit, java.nio.ByteOrder.LITTLE_ENDIAN) & 0xFFFF_FFFFL);
        parentMessage.limit(limit + headerLength + dataLength);
        wrapBuffer.wrap(buffer, limit + headerLength, dataLength);
    }

    public String originalChannel()
    {
        final int headerLength = 4;
        final int limit = parentMessage.limit();
        final int dataLength = (int)(buffer.getInt(limit, java.nio.ByteOrder.LITTLE_ENDIAN) & 0xFFFF_FFFFL);
        parentMessage.limit(limit + headerLength + dataLength);

        if (0 == dataLength)
        {
            return "";
        }

        final byte[] tmp = new byte[dataLength];
        buffer.getBytes(limit + headerLength, tmp, 0, dataLength);

        return new String(tmp, java.nio.charset.StandardCharsets.US_ASCII);
    }

    public int getOriginalChannel(final Appendable appendable)
    {
        final int headerLength = 4;
        final int limit = parentMessage.limit();
        final int dataLength = (int)(buffer.getInt(limit, java.nio.ByteOrder.LITTLE_ENDIAN) & 0xFFFF_FFFFL);
        final int dataOffset = limit + headerLength;

        parentMessage.limit(dataOffset + dataLength);
        buffer.getStringWithoutLengthAscii(dataOffset, dataLength, appendable);

        return dataLength;
    }

    public static int sourceIdentityId()
    {
        return 16;
    }

    public static int sourceIdentitySinceVersion()
    {
        return 0;
    }

    public static String sourceIdentityCharacterEncoding()
    {
        return java.nio.charset.StandardCharsets.US_ASCII.name();
    }

    public static String sourceIdentityMetaAttribute(final MetaAttribute metaAttribute)
    {
        if (MetaAttribute.PRESENCE == metaAttribute)
        {
            return "required";
        }

        return "";
    }

    public static int sourceIdentityHeaderLength()
    {
        return 4;
    }

    public int sourceIdentityLength()
    {
        final int limit = parentMessage.limit();
        return (int)(buffer.getInt(limit, java.nio.ByteOrder.LITTLE_ENDIAN) & 0xFFFF_FFFFL);
    }

    public int skipSourceIdentity()
    {
        final int headerLength = 4;
        final int limit = parentMessage.limit();
        final int dataLength = (int)(buffer.getInt(limit, java.nio.ByteOrder.LITTLE_ENDIAN) & 0xFFFF_FFFFL);
        final int dataOffset = limit + headerLength;
        parentMessage.limit(dataOffset + dataLength);

        return dataLength;
    }

    public int getSourceIdentity(final MutableDirectBuffer dst, final int dstOffset, final int length)
    {
        final int headerLength = 4;
        final int limit = parentMessage.limit();
        final int dataLength = (int)(buffer.getInt(limit, java.nio.ByteOrder.LITTLE_ENDIAN) & 0xFFFF_FFFFL);
        final int bytesCopied = Math.min(length, dataLength);
        parentMessage.limit(limit + headerLength + dataLength);
        buffer.getBytes(limit + headerLength, dst, dstOffset, bytesCopied);

        return bytesCopied;
    }

    public int getSourceIdentity(final byte[] dst, final int dstOffset, final int length)
    {
        final int headerLength = 4;
        final int limit = parentMessage.limit();
        final int dataLength = (int)(buffer.getInt(limit, java.nio.ByteOrder.LITTLE_ENDIAN) & 0xFFFF_FFFFL);
        final int bytesCopied = Math.min(length, dataLength);
        parentMessage.limit(limit + headerLength + dataLength);
        buffer.getBytes(limit + headerLength, dst, dstOffset, bytesCopied);

        return bytesCopied;
    }

    public void wrapSourceIdentity(final DirectBuffer wrapBuffer)
    {
        final int headerLength = 4;
        final int limit = parentMessage.limit();
        final int dataLength = (int)(buffer.getInt(limit, java.nio.ByteOrder.LITTLE_ENDIAN) & 0xFFFF_FFFFL);
        parentMessage.limit(limit + headerLength + dataLength);
        wrapBuffer.wrap(buffer, limit + headerLength, dataLength);
    }

    public String sourceIdentity()
    {
        final int headerLength = 4;
        final int limit = parentMessage.limit();
        final int dataLength = (int)(buffer.getInt(limit, java.nio.ByteOrder.LITTLE_ENDIAN) & 0xFFFF_FFFFL);
        parentMessage.limit(limit + headerLength + dataLength);

        if (0 == dataLength)
        {
            return "";
        }

        final byte[] tmp = new byte[dataLength];
        buffer.getBytes(limit + headerLength, tmp, 0, dataLength);

        return new String(tmp, java.nio.charset.StandardCharsets.US_ASCII);
    }

    public int getSourceIdentity(final Appendable appendable)
    {
        final int headerLength = 4;
        final int limit = parentMessage.limit();
        final int dataLength = (int)(buffer.getInt(limit, java.nio.ByteOrder.LITTLE_ENDIAN) & 0xFFFF_FFFFL);
        final int dataOffset = limit + headerLength;

        parentMessage.limit(dataOffset + dataLength);
        buffer.getStringWithoutLengthAscii(dataOffset, dataLength, appendable);

        return dataLength;
    }

    public String toString()
    {
        if (null == buffer)
        {
            return "";
        }

        final RecordingDescriptorDecoder decoder = new RecordingDescriptorDecoder();
        decoder.wrap(buffer, initialOffset, actingBlockLength, actingVersion);

        return decoder.appendTo(new StringBuilder()).toString();
    }

    public StringBuilder appendTo(final StringBuilder builder)
    {
        if (null == buffer)
        {
            return builder;
        }

        final int originalLimit = limit();
        limit(initialOffset + actingBlockLength);
        builder.append("[RecordingDescriptor](sbeTemplateId=");
        builder.append(TEMPLATE_ID);
        builder.append("|sbeSchemaId=");
        builder.append(SCHEMA_ID);
        builder.append("|sbeSchemaVersion=");
        if (parentMessage.actingVersion != SCHEMA_VERSION)
        {
            builder.append(parentMessage.actingVersion);
            builder.append('/');
        }
        builder.append(SCHEMA_VERSION);
        builder.append("|sbeBlockLength=");
        if (actingBlockLength != BLOCK_LENGTH)
        {
            builder.append(actingBlockLength);
            builder.append('/');
        }
        builder.append(BLOCK_LENGTH);
        builder.append("):");
        builder.append("controlSessionId=");
        builder.append(this.controlSessionId());
        builder.append('|');
        builder.append("correlationId=");
        builder.append(this.correlationId());
        builder.append('|');
        builder.append("recordingId=");
        builder.append(this.recordingId());
        builder.append('|');
        builder.append("startTimestamp=");
        builder.append(this.startTimestamp());
        builder.append('|');
        builder.append("stopTimestamp=");
        builder.append(this.stopTimestamp());
        builder.append('|');
        builder.append("startPosition=");
        builder.append(this.startPosition());
        builder.append('|');
        builder.append("stopPosition=");
        builder.append(this.stopPosition());
        builder.append('|');
        builder.append("initialTermId=");
        builder.append(this.initialTermId());
        builder.append('|');
        builder.append("segmentFileLength=");
        builder.append(this.segmentFileLength());
        builder.append('|');
        builder.append("termBufferLength=");
        builder.append(this.termBufferLength());
        builder.append('|');
        builder.append("mtuLength=");
        builder.append(this.mtuLength());
        builder.append('|');
        builder.append("sessionId=");
        builder.append(this.sessionId());
        builder.append('|');
        builder.append("streamId=");
        builder.append(this.streamId());
        builder.append('|');
        builder.append("strippedChannel=");
        builder.append('\'');
        getStrippedChannel(builder);
        builder.append('\'');
        builder.append('|');
        builder.append("originalChannel=");
        builder.append('\'');
        getOriginalChannel(builder);
        builder.append('\'');
        builder.append('|');
        builder.append("sourceIdentity=");
        builder.append('\'');
        getSourceIdentity(builder);
        builder.append('\'');

        limit(originalLimit);

        return builder;
    }
    
    public RecordingDescriptorDecoder sbeSkip()
    {
        sbeRewind();
        skipStrippedChannel();
        skipOriginalChannel();
        skipSourceIdentity();

        return this;
    }
}
