/* Generated SBE (Simple Binary Encoding) message codec. */
package io.aeron.archive.codecs;

import org.agrona.DirectBuffer;


/**
 * Recording progress notification for an Image.
 */
@SuppressWarnings("all")
public final class RecordingProgressDecoder
{
    public static final int BLOCK_LENGTH = 24;
    public static final int TEMPLATE_ID = 102;
    public static final int SCHEMA_ID = 101;
    public static final int SCHEMA_VERSION = 7;
    public static final java.nio.ByteOrder BYTE_ORDER = java.nio.ByteOrder.LITTLE_ENDIAN;

    private final RecordingProgressDecoder parentMessage = this;
    private DirectBuffer buffer;
    private int initialOffset;
    private int offset;
    private int limit;
    int actingBlockLength;
    int actingVersion;

    public int sbeBlockLength()
    {
        return BLOCK_LENGTH;
    }

    public int sbeTemplateId()
    {
        return TEMPLATE_ID;
    }

    public int sbeSchemaId()
    {
        return SCHEMA_ID;
    }

    public int sbeSchemaVersion()
    {
        return SCHEMA_VERSION;
    }

    public String sbeSemanticType()
    {
        return "";
    }

    public DirectBuffer buffer()
    {
        return buffer;
    }

    public int initialOffset()
    {
        return initialOffset;
    }

    public int offset()
    {
        return offset;
    }

    public RecordingProgressDecoder wrap(
        final DirectBuffer buffer,
        final int offset,
        final int actingBlockLength,
        final int actingVersion)
    {
        if (buffer != this.buffer)
        {
            this.buffer = buffer;
        }
        this.initialOffset = offset;
        this.offset = offset;
        this.actingBlockLength = actingBlockLength;
        this.actingVersion = actingVersion;
        limit(offset + actingBlockLength);

        return this;
    }

    public RecordingProgressDecoder wrapAndApplyHeader(
        final DirectBuffer buffer,
        final int offset,
        final MessageHeaderDecoder headerDecoder)
    {
        headerDecoder.wrap(buffer, offset);

        final int templateId = headerDecoder.templateId();
        if (TEMPLATE_ID != templateId)
        {
            throw new IllegalStateException("Invalid TEMPLATE_ID: " + templateId);
        }

        return wrap(
            buffer,
            offset + MessageHeaderDecoder.ENCODED_LENGTH,
            headerDecoder.blockLength(),
            headerDecoder.version());
    }

    public RecordingProgressDecoder sbeRewind()
    {
        return wrap(buffer, initialOffset, actingBlockLength, actingVersion);
    }

    public int sbeDecodedLength()
    {
        final int currentLimit = limit();
        sbeSkip();
        final int decodedLength = encodedLength();
        limit(currentLimit);

        return decodedLength;
    }

    public int encodedLength()
    {
        return limit - offset;
    }

    public int limit()
    {
        return limit;
    }

    public void limit(final int limit)
    {
        this.limit = limit;
    }

    public static int recordingIdId()
    {
        return 1;
    }

    public static int recordingIdSinceVersion()
    {
        return 0;
    }

    public static int recordingIdEncodingOffset()
    {
        return 0;
    }

    public static int recordingIdEncodingLength()
    {
        return 8;
    }

    public static String recordingIdMetaAttribute(final MetaAttribute metaAttribute)
    {
        if (MetaAttribute.PRESENCE == metaAttribute)
        {
            return "required";
        }

        return "";
    }

    public static long recordingIdNullValue()
    {
        return -9223372036854775808L;
    }

    public static long recordingIdMinValue()
    {
        return -9223372036854775807L;
    }

    public static long recordingIdMaxValue()
    {
        return 9223372036854775807L;
    }

    public long recordingId()
    {
        return buffer.getLong(offset + 0, java.nio.ByteOrder.LITTLE_ENDIAN);
    }


    public static int startPositionId()
    {
        return 2;
    }

    public static int startPositionSinceVersion()
    {
        return 0;
    }

    public static int startPositionEncodingOffset()
    {
        return 8;
    }

    public static int startPositionEncodingLength()
    {
        return 8;
    }

    public static String startPositionMetaAttribute(final MetaAttribute metaAttribute)
    {
        if (MetaAttribute.PRESENCE == metaAttribute)
        {
            return "required";
        }

        return "";
    }

    public static long startPositionNullValue()
    {
        return -9223372036854775808L;
    }

    public static long startPositionMinValue()
    {
        return -9223372036854775807L;
    }

    public static long startPositionMaxValue()
    {
        return 9223372036854775807L;
    }

    public long startPosition()
    {
        return buffer.getLong(offset + 8, java.nio.ByteOrder.LITTLE_ENDIAN);
    }


    public static int positionId()
    {
        return 3;
    }

    public static int positionSinceVersion()
    {
        return 0;
    }

    public static int positionEncodingOffset()
    {
        return 16;
    }

    public static int positionEncodingLength()
    {
        return 8;
    }

    public static String positionMetaAttribute(final MetaAttribute metaAttribute)
    {
        if (MetaAttribute.PRESENCE == metaAttribute)
        {
            return "required";
        }

        return "";
    }

    public static long positionNullValue()
    {
        return -9223372036854775808L;
    }

    public static long positionMinValue()
    {
        return -9223372036854775807L;
    }

    public static long positionMaxValue()
    {
        return 9223372036854775807L;
    }

    public long position()
    {
        return buffer.getLong(offset + 16, java.nio.ByteOrder.LITTLE_ENDIAN);
    }


    public String toString()
    {
        if (null == buffer)
        {
            return "";
        }

        final RecordingProgressDecoder decoder = new RecordingProgressDecoder();
        decoder.wrap(buffer, initialOffset, actingBlockLength, actingVersion);

        return decoder.appendTo(new StringBuilder()).toString();
    }

    public StringBuilder appendTo(final StringBuilder builder)
    {
        if (null == buffer)
        {
            return builder;
        }

        final int originalLimit = limit();
        limit(initialOffset + actingBlockLength);
        builder.append("[RecordingProgress](sbeTemplateId=");
        builder.append(TEMPLATE_ID);
        builder.append("|sbeSchemaId=");
        builder.append(SCHEMA_ID);
        builder.append("|sbeSchemaVersion=");
        if (parentMessage.actingVersion != SCHEMA_VERSION)
        {
            builder.append(parentMessage.actingVersion);
            builder.append('/');
        }
        builder.append(SCHEMA_VERSION);
        builder.append("|sbeBlockLength=");
        if (actingBlockLength != BLOCK_LENGTH)
        {
            builder.append(actingBlockLength);
            builder.append('/');
        }
        builder.append(BLOCK_LENGTH);
        builder.append("):");
        builder.append("recordingId=");
        builder.append(this.recordingId());
        builder.append('|');
        builder.append("startPosition=");
        builder.append(this.startPosition());
        builder.append('|');
        builder.append("position=");
        builder.append(this.position());

        limit(originalLimit);

        return builder;
    }
    
    public RecordingProgressDecoder sbeSkip()
    {
        sbeRewind();

        return this;
    }
}
