/* Generated SBE (Simple Binary Encoding) message codec. */
package io.aeron.cluster.codecs;


/**
 * Reason why a session was closed.
 */
@SuppressWarnings("all")
public enum CloseReason
{

    /**
     * Client closed the session.
     */
    CLIENT_ACTION(0),


    /**
     * Service closed the session.
     */
    SERVICE_ACTION(1),


    /**
     * Session timed out due to inactivity.
     */
    TIMEOUT(2),

    /**
     * To be used to represent not present or null.
     */
    NULL_VAL(-2147483648);

    private final int value;

    CloseReason(final int value)
    {
        this.value = value;
    }

    /**
     * The raw encoded value in the Java type representation.
     *
     * @return the raw value encoded.
     */
    public int value()
    {
        return value;
    }

    /**
     * Lookup the enum value representing the value.
     *
     * @param value encoded to be looked up.
     * @return the enum value representing the value.
     */
    public static CloseReason get(final int value)
    {
        switch (value)
        {
            case 0: return CLIENT_ACTION;
            case 1: return SERVICE_ACTION;
            case 2: return TIMEOUT;
            case -2147483648: return NULL_VAL;
        }

        throw new IllegalArgumentException("Unknown value: " + value);
    }
}
