/* Generated SBE (Simple Binary Encoding) message codec. */
package io.aeron.cluster.codecs;

import org.agrona.DirectBuffer;


/**
 * Event for the start of a new leadership term.
 */
@SuppressWarnings("all")
public final class NewLeadershipTermEventDecoder
{
    public static final int BLOCK_LENGTH = 48;
    public static final int TEMPLATE_ID = 24;
    public static final int SCHEMA_ID = 111;
    public static final int SCHEMA_VERSION = 9;
    public static final java.nio.ByteOrder BYTE_ORDER = java.nio.ByteOrder.LITTLE_ENDIAN;

    private final NewLeadershipTermEventDecoder parentMessage = this;
    private DirectBuffer buffer;
    private int initialOffset;
    private int offset;
    private int limit;
    int actingBlockLength;
    int actingVersion;

    public int sbeBlockLength()
    {
        return BLOCK_LENGTH;
    }

    public int sbeTemplateId()
    {
        return TEMPLATE_ID;
    }

    public int sbeSchemaId()
    {
        return SCHEMA_ID;
    }

    public int sbeSchemaVersion()
    {
        return SCHEMA_VERSION;
    }

    public String sbeSemanticType()
    {
        return "";
    }

    public DirectBuffer buffer()
    {
        return buffer;
    }

    public int initialOffset()
    {
        return initialOffset;
    }

    public int offset()
    {
        return offset;
    }

    public NewLeadershipTermEventDecoder wrap(
        final DirectBuffer buffer,
        final int offset,
        final int actingBlockLength,
        final int actingVersion)
    {
        if (buffer != this.buffer)
        {
            this.buffer = buffer;
        }
        this.initialOffset = offset;
        this.offset = offset;
        this.actingBlockLength = actingBlockLength;
        this.actingVersion = actingVersion;
        limit(offset + actingBlockLength);

        return this;
    }

    public NewLeadershipTermEventDecoder wrapAndApplyHeader(
        final DirectBuffer buffer,
        final int offset,
        final MessageHeaderDecoder headerDecoder)
    {
        headerDecoder.wrap(buffer, offset);

        final int templateId = headerDecoder.templateId();
        if (TEMPLATE_ID != templateId)
        {
            throw new IllegalStateException("Invalid TEMPLATE_ID: " + templateId);
        }

        return wrap(
            buffer,
            offset + MessageHeaderDecoder.ENCODED_LENGTH,
            headerDecoder.blockLength(),
            headerDecoder.version());
    }

    public NewLeadershipTermEventDecoder sbeRewind()
    {
        return wrap(buffer, initialOffset, actingBlockLength, actingVersion);
    }

    public int sbeDecodedLength()
    {
        final int currentLimit = limit();
        sbeSkip();
        final int decodedLength = encodedLength();
        limit(currentLimit);

        return decodedLength;
    }

    public int encodedLength()
    {
        return limit - offset;
    }

    public int limit()
    {
        return limit;
    }

    public void limit(final int limit)
    {
        this.limit = limit;
    }

    public static int leadershipTermIdId()
    {
        return 1;
    }

    public static int leadershipTermIdSinceVersion()
    {
        return 0;
    }

    public static int leadershipTermIdEncodingOffset()
    {
        return 0;
    }

    public static int leadershipTermIdEncodingLength()
    {
        return 8;
    }

    public static String leadershipTermIdMetaAttribute(final MetaAttribute metaAttribute)
    {
        if (MetaAttribute.PRESENCE == metaAttribute)
        {
            return "required";
        }

        return "";
    }

    public static long leadershipTermIdNullValue()
    {
        return -9223372036854775808L;
    }

    public static long leadershipTermIdMinValue()
    {
        return -9223372036854775807L;
    }

    public static long leadershipTermIdMaxValue()
    {
        return 9223372036854775807L;
    }

    public long leadershipTermId()
    {
        return buffer.getLong(offset + 0, java.nio.ByteOrder.LITTLE_ENDIAN);
    }


    public static int logPositionId()
    {
        return 2;
    }

    public static int logPositionSinceVersion()
    {
        return 0;
    }

    public static int logPositionEncodingOffset()
    {
        return 8;
    }

    public static int logPositionEncodingLength()
    {
        return 8;
    }

    public static String logPositionMetaAttribute(final MetaAttribute metaAttribute)
    {
        if (MetaAttribute.PRESENCE == metaAttribute)
        {
            return "required";
        }

        return "";
    }

    public static long logPositionNullValue()
    {
        return -9223372036854775808L;
    }

    public static long logPositionMinValue()
    {
        return -9223372036854775807L;
    }

    public static long logPositionMaxValue()
    {
        return 9223372036854775807L;
    }

    public long logPosition()
    {
        return buffer.getLong(offset + 8, java.nio.ByteOrder.LITTLE_ENDIAN);
    }


    public static int timestampId()
    {
        return 3;
    }

    public static int timestampSinceVersion()
    {
        return 0;
    }

    public static int timestampEncodingOffset()
    {
        return 16;
    }

    public static int timestampEncodingLength()
    {
        return 8;
    }

    public static String timestampMetaAttribute(final MetaAttribute metaAttribute)
    {
        if (MetaAttribute.PRESENCE == metaAttribute)
        {
            return "required";
        }

        return "";
    }

    public static long timestampNullValue()
    {
        return -9223372036854775808L;
    }

    public static long timestampMinValue()
    {
        return -9223372036854775807L;
    }

    public static long timestampMaxValue()
    {
        return 9223372036854775807L;
    }

    public long timestamp()
    {
        return buffer.getLong(offset + 16, java.nio.ByteOrder.LITTLE_ENDIAN);
    }


    public static int termBaseLogPositionId()
    {
        return 4;
    }

    public static int termBaseLogPositionSinceVersion()
    {
        return 0;
    }

    public static int termBaseLogPositionEncodingOffset()
    {
        return 24;
    }

    public static int termBaseLogPositionEncodingLength()
    {
        return 8;
    }

    public static String termBaseLogPositionMetaAttribute(final MetaAttribute metaAttribute)
    {
        if (MetaAttribute.PRESENCE == metaAttribute)
        {
            return "required";
        }

        return "";
    }

    public static long termBaseLogPositionNullValue()
    {
        return -9223372036854775808L;
    }

    public static long termBaseLogPositionMinValue()
    {
        return -9223372036854775807L;
    }

    public static long termBaseLogPositionMaxValue()
    {
        return 9223372036854775807L;
    }

    public long termBaseLogPosition()
    {
        return buffer.getLong(offset + 24, java.nio.ByteOrder.LITTLE_ENDIAN);
    }


    public static int leaderMemberIdId()
    {
        return 5;
    }

    public static int leaderMemberIdSinceVersion()
    {
        return 0;
    }

    public static int leaderMemberIdEncodingOffset()
    {
        return 32;
    }

    public static int leaderMemberIdEncodingLength()
    {
        return 4;
    }

    public static String leaderMemberIdMetaAttribute(final MetaAttribute metaAttribute)
    {
        if (MetaAttribute.PRESENCE == metaAttribute)
        {
            return "required";
        }

        return "";
    }

    public static int leaderMemberIdNullValue()
    {
        return -2147483648;
    }

    public static int leaderMemberIdMinValue()
    {
        return -2147483647;
    }

    public static int leaderMemberIdMaxValue()
    {
        return 2147483647;
    }

    public int leaderMemberId()
    {
        return buffer.getInt(offset + 32, java.nio.ByteOrder.LITTLE_ENDIAN);
    }


    public static int logSessionIdId()
    {
        return 6;
    }

    public static int logSessionIdSinceVersion()
    {
        return 0;
    }

    public static int logSessionIdEncodingOffset()
    {
        return 36;
    }

    public static int logSessionIdEncodingLength()
    {
        return 4;
    }

    public static String logSessionIdMetaAttribute(final MetaAttribute metaAttribute)
    {
        if (MetaAttribute.PRESENCE == metaAttribute)
        {
            return "required";
        }

        return "";
    }

    public static int logSessionIdNullValue()
    {
        return -2147483648;
    }

    public static int logSessionIdMinValue()
    {
        return -2147483647;
    }

    public static int logSessionIdMaxValue()
    {
        return 2147483647;
    }

    public int logSessionId()
    {
        return buffer.getInt(offset + 36, java.nio.ByteOrder.LITTLE_ENDIAN);
    }


    public static int timeUnitId()
    {
        return 7;
    }

    public static int timeUnitSinceVersion()
    {
        return 4;
    }

    public static int timeUnitEncodingOffset()
    {
        return 40;
    }

    public static int timeUnitEncodingLength()
    {
        return 4;
    }

    public static String timeUnitMetaAttribute(final MetaAttribute metaAttribute)
    {
        if (MetaAttribute.PRESENCE == metaAttribute)
        {
            return "optional";
        }

        return "";
    }

    public int timeUnitRaw()
    {
        if (parentMessage.actingVersion < 4)
        {
            return -2147483648;
        }

        return buffer.getInt(offset + 40, java.nio.ByteOrder.LITTLE_ENDIAN);
    }

    public ClusterTimeUnit timeUnit()
    {
        if (parentMessage.actingVersion < 4)
        {
            return ClusterTimeUnit.NULL_VAL;
        }

        return ClusterTimeUnit.get(buffer.getInt(offset + 40, java.nio.ByteOrder.LITTLE_ENDIAN));
    }


    public static int appVersionId()
    {
        return 8;
    }

    public static int appVersionSinceVersion()
    {
        return 4;
    }

    public static int appVersionEncodingOffset()
    {
        return 44;
    }

    public static int appVersionEncodingLength()
    {
        return 4;
    }

    public static String appVersionMetaAttribute(final MetaAttribute metaAttribute)
    {
        if (MetaAttribute.PRESENCE == metaAttribute)
        {
            return "optional";
        }

        return "";
    }

    public static int appVersionNullValue()
    {
        return 0;
    }

    public static int appVersionMinValue()
    {
        return 1;
    }

    public static int appVersionMaxValue()
    {
        return 16777215;
    }

    public int appVersion()
    {
        if (parentMessage.actingVersion < 4)
        {
            return 0;
        }

        return buffer.getInt(offset + 44, java.nio.ByteOrder.LITTLE_ENDIAN);
    }


    public String toString()
    {
        if (null == buffer)
        {
            return "";
        }

        final NewLeadershipTermEventDecoder decoder = new NewLeadershipTermEventDecoder();
        decoder.wrap(buffer, initialOffset, actingBlockLength, actingVersion);

        return decoder.appendTo(new StringBuilder()).toString();
    }

    public StringBuilder appendTo(final StringBuilder builder)
    {
        if (null == buffer)
        {
            return builder;
        }

        final int originalLimit = limit();
        limit(initialOffset + actingBlockLength);
        builder.append("[NewLeadershipTermEvent](sbeTemplateId=");
        builder.append(TEMPLATE_ID);
        builder.append("|sbeSchemaId=");
        builder.append(SCHEMA_ID);
        builder.append("|sbeSchemaVersion=");
        if (parentMessage.actingVersion != SCHEMA_VERSION)
        {
            builder.append(parentMessage.actingVersion);
            builder.append('/');
        }
        builder.append(SCHEMA_VERSION);
        builder.append("|sbeBlockLength=");
        if (actingBlockLength != BLOCK_LENGTH)
        {
            builder.append(actingBlockLength);
            builder.append('/');
        }
        builder.append(BLOCK_LENGTH);
        builder.append("):");
        builder.append("leadershipTermId=");
        builder.append(this.leadershipTermId());
        builder.append('|');
        builder.append("logPosition=");
        builder.append(this.logPosition());
        builder.append('|');
        builder.append("timestamp=");
        builder.append(this.timestamp());
        builder.append('|');
        builder.append("termBaseLogPosition=");
        builder.append(this.termBaseLogPosition());
        builder.append('|');
        builder.append("leaderMemberId=");
        builder.append(this.leaderMemberId());
        builder.append('|');
        builder.append("logSessionId=");
        builder.append(this.logSessionId());
        builder.append('|');
        builder.append("timeUnit=");
        builder.append(this.timeUnit());
        builder.append('|');
        builder.append("appVersion=");
        builder.append(this.appVersion());

        limit(originalLimit);

        return builder;
    }
    
    public NewLeadershipTermEventDecoder sbeSkip()
    {
        sbeRewind();

        return this;
    }
}
