/* Generated SBE (Simple Binary Encoding) message codec. */
package io.aeron.cluster.codecs;

import org.agrona.DirectBuffer;


/**
 * Request the vote from another member to become the cluster leader.
 */
@SuppressWarnings("all")
public final class RequestVoteDecoder
{
    public static final int BLOCK_LENGTH = 32;
    public static final int TEMPLATE_ID = 51;
    public static final int SCHEMA_ID = 111;
    public static final int SCHEMA_VERSION = 9;
    public static final java.nio.ByteOrder BYTE_ORDER = java.nio.ByteOrder.LITTLE_ENDIAN;

    private final RequestVoteDecoder parentMessage = this;
    private DirectBuffer buffer;
    private int initialOffset;
    private int offset;
    private int limit;
    int actingBlockLength;
    int actingVersion;

    public int sbeBlockLength()
    {
        return BLOCK_LENGTH;
    }

    public int sbeTemplateId()
    {
        return TEMPLATE_ID;
    }

    public int sbeSchemaId()
    {
        return SCHEMA_ID;
    }

    public int sbeSchemaVersion()
    {
        return SCHEMA_VERSION;
    }

    public String sbeSemanticType()
    {
        return "";
    }

    public DirectBuffer buffer()
    {
        return buffer;
    }

    public int initialOffset()
    {
        return initialOffset;
    }

    public int offset()
    {
        return offset;
    }

    public RequestVoteDecoder wrap(
        final DirectBuffer buffer,
        final int offset,
        final int actingBlockLength,
        final int actingVersion)
    {
        if (buffer != this.buffer)
        {
            this.buffer = buffer;
        }
        this.initialOffset = offset;
        this.offset = offset;
        this.actingBlockLength = actingBlockLength;
        this.actingVersion = actingVersion;
        limit(offset + actingBlockLength);

        return this;
    }

    public RequestVoteDecoder wrapAndApplyHeader(
        final DirectBuffer buffer,
        final int offset,
        final MessageHeaderDecoder headerDecoder)
    {
        headerDecoder.wrap(buffer, offset);

        final int templateId = headerDecoder.templateId();
        if (TEMPLATE_ID != templateId)
        {
            throw new IllegalStateException("Invalid TEMPLATE_ID: " + templateId);
        }

        return wrap(
            buffer,
            offset + MessageHeaderDecoder.ENCODED_LENGTH,
            headerDecoder.blockLength(),
            headerDecoder.version());
    }

    public RequestVoteDecoder sbeRewind()
    {
        return wrap(buffer, initialOffset, actingBlockLength, actingVersion);
    }

    public int sbeDecodedLength()
    {
        final int currentLimit = limit();
        sbeSkip();
        final int decodedLength = encodedLength();
        limit(currentLimit);

        return decodedLength;
    }

    public int encodedLength()
    {
        return limit - offset;
    }

    public int limit()
    {
        return limit;
    }

    public void limit(final int limit)
    {
        this.limit = limit;
    }

    public static int logLeadershipTermIdId()
    {
        return 1;
    }

    public static int logLeadershipTermIdSinceVersion()
    {
        return 0;
    }

    public static int logLeadershipTermIdEncodingOffset()
    {
        return 0;
    }

    public static int logLeadershipTermIdEncodingLength()
    {
        return 8;
    }

    public static String logLeadershipTermIdMetaAttribute(final MetaAttribute metaAttribute)
    {
        if (MetaAttribute.PRESENCE == metaAttribute)
        {
            return "required";
        }

        return "";
    }

    public static long logLeadershipTermIdNullValue()
    {
        return -9223372036854775808L;
    }

    public static long logLeadershipTermIdMinValue()
    {
        return -9223372036854775807L;
    }

    public static long logLeadershipTermIdMaxValue()
    {
        return 9223372036854775807L;
    }

    public long logLeadershipTermId()
    {
        return buffer.getLong(offset + 0, java.nio.ByteOrder.LITTLE_ENDIAN);
    }


    public static int logPositionId()
    {
        return 2;
    }

    public static int logPositionSinceVersion()
    {
        return 0;
    }

    public static int logPositionEncodingOffset()
    {
        return 8;
    }

    public static int logPositionEncodingLength()
    {
        return 8;
    }

    public static String logPositionMetaAttribute(final MetaAttribute metaAttribute)
    {
        if (MetaAttribute.PRESENCE == metaAttribute)
        {
            return "required";
        }

        return "";
    }

    public static long logPositionNullValue()
    {
        return -9223372036854775808L;
    }

    public static long logPositionMinValue()
    {
        return -9223372036854775807L;
    }

    public static long logPositionMaxValue()
    {
        return 9223372036854775807L;
    }

    public long logPosition()
    {
        return buffer.getLong(offset + 8, java.nio.ByteOrder.LITTLE_ENDIAN);
    }


    public static int candidateTermIdId()
    {
        return 3;
    }

    public static int candidateTermIdSinceVersion()
    {
        return 0;
    }

    public static int candidateTermIdEncodingOffset()
    {
        return 16;
    }

    public static int candidateTermIdEncodingLength()
    {
        return 8;
    }

    public static String candidateTermIdMetaAttribute(final MetaAttribute metaAttribute)
    {
        if (MetaAttribute.PRESENCE == metaAttribute)
        {
            return "required";
        }

        return "";
    }

    public static long candidateTermIdNullValue()
    {
        return -9223372036854775808L;
    }

    public static long candidateTermIdMinValue()
    {
        return -9223372036854775807L;
    }

    public static long candidateTermIdMaxValue()
    {
        return 9223372036854775807L;
    }

    public long candidateTermId()
    {
        return buffer.getLong(offset + 16, java.nio.ByteOrder.LITTLE_ENDIAN);
    }


    public static int candidateMemberIdId()
    {
        return 4;
    }

    public static int candidateMemberIdSinceVersion()
    {
        return 0;
    }

    public static int candidateMemberIdEncodingOffset()
    {
        return 24;
    }

    public static int candidateMemberIdEncodingLength()
    {
        return 4;
    }

    public static String candidateMemberIdMetaAttribute(final MetaAttribute metaAttribute)
    {
        if (MetaAttribute.PRESENCE == metaAttribute)
        {
            return "required";
        }

        return "";
    }

    public static int candidateMemberIdNullValue()
    {
        return -2147483648;
    }

    public static int candidateMemberIdMinValue()
    {
        return -2147483647;
    }

    public static int candidateMemberIdMaxValue()
    {
        return 2147483647;
    }

    public int candidateMemberId()
    {
        return buffer.getInt(offset + 24, java.nio.ByteOrder.LITTLE_ENDIAN);
    }


    public static int protocolVersionId()
    {
        return 5;
    }

    public static int protocolVersionSinceVersion()
    {
        return 9;
    }

    public static int protocolVersionEncodingOffset()
    {
        return 28;
    }

    public static int protocolVersionEncodingLength()
    {
        return 4;
    }

    public static String protocolVersionMetaAttribute(final MetaAttribute metaAttribute)
    {
        if (MetaAttribute.PRESENCE == metaAttribute)
        {
            return "optional";
        }

        return "";
    }

    public static int protocolVersionNullValue()
    {
        return 0;
    }

    public static int protocolVersionMinValue()
    {
        return 1;
    }

    public static int protocolVersionMaxValue()
    {
        return 16777215;
    }

    public int protocolVersion()
    {
        if (parentMessage.actingVersion < 9)
        {
            return 0;
        }

        return buffer.getInt(offset + 28, java.nio.ByteOrder.LITTLE_ENDIAN);
    }


    public String toString()
    {
        if (null == buffer)
        {
            return "";
        }

        final RequestVoteDecoder decoder = new RequestVoteDecoder();
        decoder.wrap(buffer, initialOffset, actingBlockLength, actingVersion);

        return decoder.appendTo(new StringBuilder()).toString();
    }

    public StringBuilder appendTo(final StringBuilder builder)
    {
        if (null == buffer)
        {
            return builder;
        }

        final int originalLimit = limit();
        limit(initialOffset + actingBlockLength);
        builder.append("[RequestVote](sbeTemplateId=");
        builder.append(TEMPLATE_ID);
        builder.append("|sbeSchemaId=");
        builder.append(SCHEMA_ID);
        builder.append("|sbeSchemaVersion=");
        if (parentMessage.actingVersion != SCHEMA_VERSION)
        {
            builder.append(parentMessage.actingVersion);
            builder.append('/');
        }
        builder.append(SCHEMA_VERSION);
        builder.append("|sbeBlockLength=");
        if (actingBlockLength != BLOCK_LENGTH)
        {
            builder.append(actingBlockLength);
            builder.append('/');
        }
        builder.append(BLOCK_LENGTH);
        builder.append("):");
        builder.append("logLeadershipTermId=");
        builder.append(this.logLeadershipTermId());
        builder.append('|');
        builder.append("logPosition=");
        builder.append(this.logPosition());
        builder.append('|');
        builder.append("candidateTermId=");
        builder.append(this.candidateTermId());
        builder.append('|');
        builder.append("candidateMemberId=");
        builder.append(this.candidateMemberId());
        builder.append('|');
        builder.append("protocolVersion=");
        builder.append(this.protocolVersion());

        limit(originalLimit);

        return builder;
    }
    
    public RequestVoteDecoder sbeSkip()
    {
        sbeRewind();

        return this;
    }
}
