/*
 * Copyright © 2017 camunda services GmbH (info@camunda.com)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package io.camunda.client.impl.search.filter.builder;

import io.camunda.client.api.search.filter.builder.BasicLongProperty;
import io.camunda.client.impl.search.request.TypedSearchRequestPropertyProvider;
import io.camunda.client.impl.util.CollectionUtil;
import io.camunda.client.protocol.rest.BasicStringFilterProperty;
import java.util.List;
import java.util.stream.Collectors;

public class BasicLongPropertyImpl
    extends TypedSearchRequestPropertyProvider<BasicStringFilterProperty>
    implements BasicLongProperty {
  private final BasicStringFilterProperty filterProperty = new BasicStringFilterProperty();

  @Override
  public BasicLongProperty eq(final Long value) {
    filterProperty.set$Eq(String.valueOf(value));
    return this;
  }

  @Override
  public BasicLongProperty neq(final Long value) {
    filterProperty.set$Neq(String.valueOf(value));
    return this;
  }

  @Override
  public BasicLongProperty exists(final boolean value) {
    filterProperty.set$Exists(value);
    return this;
  }

  @Override
  public BasicLongProperty in(final List<Long> values) {
    filterProperty.set$In(values.stream().map(String::valueOf).collect(Collectors.toList()));
    return this;
  }

  @Override
  public BasicLongProperty in(final Long... values) {
    return in(CollectionUtil.toList(values));
  }

  public BasicStringFilterProperty build() {
    return filterProperty;
  }

  @Override
  public BasicLongProperty notIn(final List<Long> values) {
    filterProperty.set$NotIn(values.stream().map(String::valueOf).collect(Collectors.toList()));
    return this;
  }

  @Override
  public BasicLongProperty notIn(final Long... value) {
    return notIn(CollectionUtil.toList(value));
  }

  @Override
  protected BasicStringFilterProperty getSearchRequestProperty() {
    return filterProperty;
  }
}
