/*
 * Orchestration Cluster API
 * API for communicating with a Camunda 8 cluster.
 *
 * The version of the OpenAPI document: 0.1
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package io.camunda.client.protocol.rest;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.StringJoiner;

/**
 * CreateProcessInstanceResult
 */
@JsonPropertyOrder({
  CreateProcessInstanceResult.JSON_PROPERTY_PROCESS_DEFINITION_ID,
  CreateProcessInstanceResult.JSON_PROPERTY_PROCESS_DEFINITION_VERSION,
  CreateProcessInstanceResult.JSON_PROPERTY_TENANT_ID,
  CreateProcessInstanceResult.JSON_PROPERTY_VARIABLES,
  CreateProcessInstanceResult.JSON_PROPERTY_PROCESS_DEFINITION_KEY,
  CreateProcessInstanceResult.JSON_PROPERTY_PROCESS_INSTANCE_KEY,
  CreateProcessInstanceResult.JSON_PROPERTY_TAGS
})
@com.fasterxml.jackson.annotation.JsonInclude(com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL)
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-12-11T14:03:07.865311160Z[GMT]", comments = "Generator version: 7.12.0")
public class CreateProcessInstanceResult {
  public static final String JSON_PROPERTY_PROCESS_DEFINITION_ID = "processDefinitionId";
  @javax.annotation.Nullable
  private String processDefinitionId;

  public static final String JSON_PROPERTY_PROCESS_DEFINITION_VERSION = "processDefinitionVersion";
  @javax.annotation.Nullable
  private Integer processDefinitionVersion;

  public static final String JSON_PROPERTY_TENANT_ID = "tenantId";
  @javax.annotation.Nullable
  private String tenantId;

  public static final String JSON_PROPERTY_VARIABLES = "variables";
  @javax.annotation.Nullable
  private Map<String, Object> variables = new HashMap<>();

  public static final String JSON_PROPERTY_PROCESS_DEFINITION_KEY = "processDefinitionKey";
  @javax.annotation.Nullable
  private String processDefinitionKey;

  public static final String JSON_PROPERTY_PROCESS_INSTANCE_KEY = "processInstanceKey";
  @javax.annotation.Nullable
  private String processInstanceKey;

  public static final String JSON_PROPERTY_TAGS = "tags";
  @javax.annotation.Nullable
  private Set<String> tags = new LinkedHashSet<>();

  public CreateProcessInstanceResult() {
  }

  public CreateProcessInstanceResult processDefinitionId(@javax.annotation.Nullable String processDefinitionId) {
    
    this.processDefinitionId = processDefinitionId;
    return this;
  }

  /**
   * The BPMN process ID of the process definition which was used to create the process. instance 
   * @return processDefinitionId
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_PROCESS_DEFINITION_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getProcessDefinitionId() {
    return processDefinitionId;
  }


  @JsonProperty(JSON_PROPERTY_PROCESS_DEFINITION_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setProcessDefinitionId(@javax.annotation.Nullable String processDefinitionId) {
    this.processDefinitionId = processDefinitionId;
  }

  public CreateProcessInstanceResult processDefinitionVersion(@javax.annotation.Nullable Integer processDefinitionVersion) {
    
    this.processDefinitionVersion = processDefinitionVersion;
    return this;
  }

  /**
   * The version of the process definition which was used to create the process instance. 
   * @return processDefinitionVersion
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_PROCESS_DEFINITION_VERSION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getProcessDefinitionVersion() {
    return processDefinitionVersion;
  }


  @JsonProperty(JSON_PROPERTY_PROCESS_DEFINITION_VERSION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setProcessDefinitionVersion(@javax.annotation.Nullable Integer processDefinitionVersion) {
    this.processDefinitionVersion = processDefinitionVersion;
  }

  public CreateProcessInstanceResult tenantId(@javax.annotation.Nullable String tenantId) {
    
    this.tenantId = tenantId;
    return this;
  }

  /**
   * The tenant ID of the created process instance.
   * @return tenantId
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_TENANT_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getTenantId() {
    return tenantId;
  }


  @JsonProperty(JSON_PROPERTY_TENANT_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTenantId(@javax.annotation.Nullable String tenantId) {
    this.tenantId = tenantId;
  }

  public CreateProcessInstanceResult variables(@javax.annotation.Nullable Map<String, Object> variables) {
    
    this.variables = variables;
    return this;
  }

  public CreateProcessInstanceResult putVariablesItem(String key, Object variablesItem) {
    if (this.variables == null) {
      this.variables = new HashMap<>();
    }
    this.variables.put(key, variablesItem);
    return this;
  }

  /**
   * All the variables visible in the root scope.
   * @return variables
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_VARIABLES)
  @JsonInclude(content = JsonInclude.Include.ALWAYS, value = JsonInclude.Include.USE_DEFAULTS)

  public Map<String, Object> getVariables() {
    return variables;
  }


  @JsonProperty(JSON_PROPERTY_VARIABLES)
  @JsonInclude(content = JsonInclude.Include.ALWAYS, value = JsonInclude.Include.USE_DEFAULTS)
  public void setVariables(@javax.annotation.Nullable Map<String, Object> variables) {
    this.variables = variables;
  }

  public CreateProcessInstanceResult processDefinitionKey(@javax.annotation.Nullable String processDefinitionKey) {
    
    this.processDefinitionKey = processDefinitionKey;
    return this;
  }

  /**
   * The key of the process definition which was used to create the process instance. 
   * @return processDefinitionKey
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_PROCESS_DEFINITION_KEY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getProcessDefinitionKey() {
    return processDefinitionKey;
  }


  @JsonProperty(JSON_PROPERTY_PROCESS_DEFINITION_KEY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setProcessDefinitionKey(@javax.annotation.Nullable String processDefinitionKey) {
    this.processDefinitionKey = processDefinitionKey;
  }

  public CreateProcessInstanceResult processInstanceKey(@javax.annotation.Nullable String processInstanceKey) {
    
    this.processInstanceKey = processInstanceKey;
    return this;
  }

  /**
   * The unique identifier of the created process instance; to be used wherever a request needs a process instance key (e.g. CancelProcessInstanceRequest). 
   * @return processInstanceKey
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_PROCESS_INSTANCE_KEY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getProcessInstanceKey() {
    return processInstanceKey;
  }


  @JsonProperty(JSON_PROPERTY_PROCESS_INSTANCE_KEY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setProcessInstanceKey(@javax.annotation.Nullable String processInstanceKey) {
    this.processInstanceKey = processInstanceKey;
  }

  public CreateProcessInstanceResult tags(@javax.annotation.Nullable Set<String> tags) {
    
    this.tags = tags;
    return this;
  }

  public CreateProcessInstanceResult addTagsItem(String tagsItem) {
    if (this.tags == null) {
      this.tags = new LinkedHashSet<>();
    }
    this.tags.add(tagsItem);
    return this;
  }

  /**
   * List of tags
   * @return tags
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_TAGS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Set<String> getTags() {
    return tags;
  }


  @JsonDeserialize(as = LinkedHashSet.class)
  @JsonProperty(JSON_PROPERTY_TAGS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTags(@javax.annotation.Nullable Set<String> tags) {
    this.tags = tags;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    CreateProcessInstanceResult createProcessInstanceResult = (CreateProcessInstanceResult) o;
    return Objects.equals(this.processDefinitionId, createProcessInstanceResult.processDefinitionId) &&
        Objects.equals(this.processDefinitionVersion, createProcessInstanceResult.processDefinitionVersion) &&
        Objects.equals(this.tenantId, createProcessInstanceResult.tenantId) &&
        Objects.equals(this.variables, createProcessInstanceResult.variables) &&
        Objects.equals(this.processDefinitionKey, createProcessInstanceResult.processDefinitionKey) &&
        Objects.equals(this.processInstanceKey, createProcessInstanceResult.processInstanceKey) &&
        Objects.equals(this.tags, createProcessInstanceResult.tags);
  }

  @Override
  public int hashCode() {
    return Objects.hash(processDefinitionId, processDefinitionVersion, tenantId, variables, processDefinitionKey, processInstanceKey, tags);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class CreateProcessInstanceResult {\n");
    sb.append("    processDefinitionId: ").append(toIndentedString(processDefinitionId)).append("\n");
    sb.append("    processDefinitionVersion: ").append(toIndentedString(processDefinitionVersion)).append("\n");
    sb.append("    tenantId: ").append(toIndentedString(tenantId)).append("\n");
    sb.append("    variables: ").append(toIndentedString(variables)).append("\n");
    sb.append("    processDefinitionKey: ").append(toIndentedString(processDefinitionKey)).append("\n");
    sb.append("    processInstanceKey: ").append(toIndentedString(processInstanceKey)).append("\n");
    sb.append("    tags: ").append(toIndentedString(tags)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Convert the instance into URL query string.
   *
   * @return URL query string
   */
  public String toUrlQueryString() {
    return toUrlQueryString(null);
  }

  /**
   * Convert the instance into URL query string.
   *
   * @param prefix prefix of the query string
   * @return URL query string
   */
  public String toUrlQueryString(String prefix) {
    String suffix = "";
    String containerSuffix = "";
    String containerPrefix = "";
    if (prefix == null) {
      // style=form, explode=true, e.g. /pet?name=cat&type=manx
      prefix = "";
    } else {
      // deepObject style e.g. /pet?id[name]=cat&id[type]=manx
      prefix = prefix + "[";
      suffix = "]";
      containerSuffix = "]";
      containerPrefix = "[";
    }

    StringJoiner joiner = new StringJoiner("&");

    // add `processDefinitionId` to the URL query string
    if (getProcessDefinitionId() != null) {
      try {
        joiner.add(String.format("%sprocessDefinitionId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getProcessDefinitionId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `processDefinitionVersion` to the URL query string
    if (getProcessDefinitionVersion() != null) {
      try {
        joiner.add(String.format("%sprocessDefinitionVersion%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getProcessDefinitionVersion()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `tenantId` to the URL query string
    if (getTenantId() != null) {
      try {
        joiner.add(String.format("%stenantId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getTenantId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `variables` to the URL query string
    if (getVariables() != null) {
      for (String _key : getVariables().keySet()) {
        try {
          joiner.add(String.format("%svariables%s%s=%s", prefix, suffix,
              "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, _key, containerSuffix),
              getVariables().get(_key), URLEncoder.encode(String.valueOf(getVariables().get(_key)), "UTF-8").replaceAll("\\+", "%20")));
        } catch (UnsupportedEncodingException e) {
          // Should never happen, UTF-8 is always supported
          throw new RuntimeException(e);
        }
      }
    }

    // add `processDefinitionKey` to the URL query string
    if (getProcessDefinitionKey() != null) {
      try {
        joiner.add(String.format("%sprocessDefinitionKey%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getProcessDefinitionKey()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `processInstanceKey` to the URL query string
    if (getProcessInstanceKey() != null) {
      try {
        joiner.add(String.format("%sprocessInstanceKey%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getProcessInstanceKey()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `tags` to the URL query string
    if (getTags() != null) {
      int i = 0;
      for (String _item : getTags()) {
        try {
          joiner.add(String.format("%stags%s%s=%s", prefix, suffix,
              "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix),
              URLEncoder.encode(String.valueOf(_item), "UTF-8").replaceAll("\\+", "%20")));
        } catch (UnsupportedEncodingException e) {
          // Should never happen, UTF-8 is always supported
          throw new RuntimeException(e);
        }
      }
      i++;
    }

    return joiner.toString();
  }

}

