/*
 * Orchestration Cluster API
 * API for communicating with a Camunda 8 cluster.
 *
 * The version of the OpenAPI document: 0.1
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package io.camunda.client.protocol.rest;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.camunda.client.protocol.rest.BasicStringFilterProperty;
import io.camunda.client.protocol.rest.DateTimeFilterProperty;
import io.camunda.client.protocol.rest.IntegerFilterProperty;
import io.camunda.client.protocol.rest.JobKindFilterProperty;
import io.camunda.client.protocol.rest.JobListenerEventTypeFilterProperty;
import io.camunda.client.protocol.rest.JobStateFilterProperty;
import io.camunda.client.protocol.rest.StringFilterProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.StringJoiner;

/**
 * Job search filter.
 */
@JsonPropertyOrder({
  JobFilter.JSON_PROPERTY_DEADLINE,
  JobFilter.JSON_PROPERTY_DENIED_REASON,
  JobFilter.JSON_PROPERTY_ELEMENT_ID,
  JobFilter.JSON_PROPERTY_ELEMENT_INSTANCE_KEY,
  JobFilter.JSON_PROPERTY_END_TIME,
  JobFilter.JSON_PROPERTY_ERROR_CODE,
  JobFilter.JSON_PROPERTY_ERROR_MESSAGE,
  JobFilter.JSON_PROPERTY_HAS_FAILED_WITH_RETRIES_LEFT,
  JobFilter.JSON_PROPERTY_IS_DENIED,
  JobFilter.JSON_PROPERTY_JOB_KEY,
  JobFilter.JSON_PROPERTY_KIND,
  JobFilter.JSON_PROPERTY_LISTENER_EVENT_TYPE,
  JobFilter.JSON_PROPERTY_PROCESS_DEFINITION_ID,
  JobFilter.JSON_PROPERTY_PROCESS_DEFINITION_KEY,
  JobFilter.JSON_PROPERTY_PROCESS_INSTANCE_KEY,
  JobFilter.JSON_PROPERTY_RETRIES,
  JobFilter.JSON_PROPERTY_STATE,
  JobFilter.JSON_PROPERTY_TENANT_ID,
  JobFilter.JSON_PROPERTY_TYPE,
  JobFilter.JSON_PROPERTY_WORKER
})
@com.fasterxml.jackson.annotation.JsonInclude(com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL)
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-12-11T14:03:07.865311160Z[GMT]", comments = "Generator version: 7.12.0")
public class JobFilter {
  public static final String JSON_PROPERTY_DEADLINE = "deadline";
  @javax.annotation.Nullable
  private DateTimeFilterProperty deadline;

  public static final String JSON_PROPERTY_DENIED_REASON = "deniedReason";
  @javax.annotation.Nullable
  private StringFilterProperty deniedReason;

  public static final String JSON_PROPERTY_ELEMENT_ID = "elementId";
  @javax.annotation.Nullable
  private StringFilterProperty elementId;

  public static final String JSON_PROPERTY_ELEMENT_INSTANCE_KEY = "elementInstanceKey";
  @javax.annotation.Nullable
  private BasicStringFilterProperty elementInstanceKey;

  public static final String JSON_PROPERTY_END_TIME = "endTime";
  @javax.annotation.Nullable
  private DateTimeFilterProperty endTime;

  public static final String JSON_PROPERTY_ERROR_CODE = "errorCode";
  @javax.annotation.Nullable
  private StringFilterProperty errorCode;

  public static final String JSON_PROPERTY_ERROR_MESSAGE = "errorMessage";
  @javax.annotation.Nullable
  private StringFilterProperty errorMessage;

  public static final String JSON_PROPERTY_HAS_FAILED_WITH_RETRIES_LEFT = "hasFailedWithRetriesLeft";
  @javax.annotation.Nullable
  private Boolean hasFailedWithRetriesLeft;

  public static final String JSON_PROPERTY_IS_DENIED = "isDenied";
  @javax.annotation.Nullable
  private Boolean isDenied;

  public static final String JSON_PROPERTY_JOB_KEY = "jobKey";
  @javax.annotation.Nullable
  private BasicStringFilterProperty jobKey;

  public static final String JSON_PROPERTY_KIND = "kind";
  @javax.annotation.Nullable
  private JobKindFilterProperty kind;

  public static final String JSON_PROPERTY_LISTENER_EVENT_TYPE = "listenerEventType";
  @javax.annotation.Nullable
  private JobListenerEventTypeFilterProperty listenerEventType;

  public static final String JSON_PROPERTY_PROCESS_DEFINITION_ID = "processDefinitionId";
  @javax.annotation.Nullable
  private StringFilterProperty processDefinitionId;

  public static final String JSON_PROPERTY_PROCESS_DEFINITION_KEY = "processDefinitionKey";
  @javax.annotation.Nullable
  private BasicStringFilterProperty processDefinitionKey;

  public static final String JSON_PROPERTY_PROCESS_INSTANCE_KEY = "processInstanceKey";
  @javax.annotation.Nullable
  private BasicStringFilterProperty processInstanceKey;

  public static final String JSON_PROPERTY_RETRIES = "retries";
  @javax.annotation.Nullable
  private IntegerFilterProperty retries;

  public static final String JSON_PROPERTY_STATE = "state";
  @javax.annotation.Nullable
  private JobStateFilterProperty state;

  public static final String JSON_PROPERTY_TENANT_ID = "tenantId";
  @javax.annotation.Nullable
  private StringFilterProperty tenantId;

  public static final String JSON_PROPERTY_TYPE = "type";
  @javax.annotation.Nullable
  private StringFilterProperty type;

  public static final String JSON_PROPERTY_WORKER = "worker";
  @javax.annotation.Nullable
  private StringFilterProperty worker;

  public JobFilter() {
  }

  public JobFilter deadline(@javax.annotation.Nullable DateTimeFilterProperty deadline) {
    
    this.deadline = deadline;
    return this;
  }

  /**
   * When the job can be activated.
   * @return deadline
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_DEADLINE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public DateTimeFilterProperty getDeadline() {
    return deadline;
  }


  @JsonProperty(JSON_PROPERTY_DEADLINE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDeadline(@javax.annotation.Nullable DateTimeFilterProperty deadline) {
    this.deadline = deadline;
  }

  public JobFilter deniedReason(@javax.annotation.Nullable StringFilterProperty deniedReason) {
    
    this.deniedReason = deniedReason;
    return this;
  }

  /**
   * The reason provided by the user task listener for denying the work.
   * @return deniedReason
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_DENIED_REASON)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public StringFilterProperty getDeniedReason() {
    return deniedReason;
  }


  @JsonProperty(JSON_PROPERTY_DENIED_REASON)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDeniedReason(@javax.annotation.Nullable StringFilterProperty deniedReason) {
    this.deniedReason = deniedReason;
  }

  public JobFilter elementId(@javax.annotation.Nullable StringFilterProperty elementId) {
    
    this.elementId = elementId;
    return this;
  }

  /**
   * The element ID associated with the job.
   * @return elementId
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_ELEMENT_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public StringFilterProperty getElementId() {
    return elementId;
  }


  @JsonProperty(JSON_PROPERTY_ELEMENT_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setElementId(@javax.annotation.Nullable StringFilterProperty elementId) {
    this.elementId = elementId;
  }

  public JobFilter elementInstanceKey(@javax.annotation.Nullable BasicStringFilterProperty elementInstanceKey) {
    
    this.elementInstanceKey = elementInstanceKey;
    return this;
  }

  /**
   * The element instance key associated with the job.
   * @return elementInstanceKey
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_ELEMENT_INSTANCE_KEY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public BasicStringFilterProperty getElementInstanceKey() {
    return elementInstanceKey;
  }


  @JsonProperty(JSON_PROPERTY_ELEMENT_INSTANCE_KEY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setElementInstanceKey(@javax.annotation.Nullable BasicStringFilterProperty elementInstanceKey) {
    this.elementInstanceKey = elementInstanceKey;
  }

  public JobFilter endTime(@javax.annotation.Nullable DateTimeFilterProperty endTime) {
    
    this.endTime = endTime;
    return this;
  }

  /**
   * When the job ended.
   * @return endTime
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_END_TIME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public DateTimeFilterProperty getEndTime() {
    return endTime;
  }


  @JsonProperty(JSON_PROPERTY_END_TIME)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setEndTime(@javax.annotation.Nullable DateTimeFilterProperty endTime) {
    this.endTime = endTime;
  }

  public JobFilter errorCode(@javax.annotation.Nullable StringFilterProperty errorCode) {
    
    this.errorCode = errorCode;
    return this;
  }

  /**
   * The error code provided for the failed job.
   * @return errorCode
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_ERROR_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public StringFilterProperty getErrorCode() {
    return errorCode;
  }


  @JsonProperty(JSON_PROPERTY_ERROR_CODE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setErrorCode(@javax.annotation.Nullable StringFilterProperty errorCode) {
    this.errorCode = errorCode;
  }

  public JobFilter errorMessage(@javax.annotation.Nullable StringFilterProperty errorMessage) {
    
    this.errorMessage = errorMessage;
    return this;
  }

  /**
   * The error message that provides additional context for a failed job.
   * @return errorMessage
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_ERROR_MESSAGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public StringFilterProperty getErrorMessage() {
    return errorMessage;
  }


  @JsonProperty(JSON_PROPERTY_ERROR_MESSAGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setErrorMessage(@javax.annotation.Nullable StringFilterProperty errorMessage) {
    this.errorMessage = errorMessage;
  }

  public JobFilter hasFailedWithRetriesLeft(@javax.annotation.Nullable Boolean hasFailedWithRetriesLeft) {
    
    this.hasFailedWithRetriesLeft = hasFailedWithRetriesLeft;
    return this;
  }

  /**
   * Indicates whether the job has failed with retries left.
   * @return hasFailedWithRetriesLeft
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_HAS_FAILED_WITH_RETRIES_LEFT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getHasFailedWithRetriesLeft() {
    return hasFailedWithRetriesLeft;
  }


  @JsonProperty(JSON_PROPERTY_HAS_FAILED_WITH_RETRIES_LEFT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setHasFailedWithRetriesLeft(@javax.annotation.Nullable Boolean hasFailedWithRetriesLeft) {
    this.hasFailedWithRetriesLeft = hasFailedWithRetriesLeft;
  }

  public JobFilter isDenied(@javax.annotation.Nullable Boolean isDenied) {
    
    this.isDenied = isDenied;
    return this;
  }

  /**
   * Indicates whether the user task listener denies the work.
   * @return isDenied
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_IS_DENIED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getIsDenied() {
    return isDenied;
  }


  @JsonProperty(JSON_PROPERTY_IS_DENIED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIsDenied(@javax.annotation.Nullable Boolean isDenied) {
    this.isDenied = isDenied;
  }

  public JobFilter jobKey(@javax.annotation.Nullable BasicStringFilterProperty jobKey) {
    
    this.jobKey = jobKey;
    return this;
  }

  /**
   * The key, a unique identifier for the job.
   * @return jobKey
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_JOB_KEY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public BasicStringFilterProperty getJobKey() {
    return jobKey;
  }


  @JsonProperty(JSON_PROPERTY_JOB_KEY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setJobKey(@javax.annotation.Nullable BasicStringFilterProperty jobKey) {
    this.jobKey = jobKey;
  }

  public JobFilter kind(@javax.annotation.Nullable JobKindFilterProperty kind) {
    
    this.kind = kind;
    return this;
  }

  /**
   * The kind of the job.
   * @return kind
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_KIND)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JobKindFilterProperty getKind() {
    return kind;
  }


  @JsonProperty(JSON_PROPERTY_KIND)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setKind(@javax.annotation.Nullable JobKindFilterProperty kind) {
    this.kind = kind;
  }

  public JobFilter listenerEventType(@javax.annotation.Nullable JobListenerEventTypeFilterProperty listenerEventType) {
    
    this.listenerEventType = listenerEventType;
    return this;
  }

  /**
   * The listener event type of the job.
   * @return listenerEventType
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_LISTENER_EVENT_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JobListenerEventTypeFilterProperty getListenerEventType() {
    return listenerEventType;
  }


  @JsonProperty(JSON_PROPERTY_LISTENER_EVENT_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setListenerEventType(@javax.annotation.Nullable JobListenerEventTypeFilterProperty listenerEventType) {
    this.listenerEventType = listenerEventType;
  }

  public JobFilter processDefinitionId(@javax.annotation.Nullable StringFilterProperty processDefinitionId) {
    
    this.processDefinitionId = processDefinitionId;
    return this;
  }

  /**
   * The process definition ID associated with the job.
   * @return processDefinitionId
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_PROCESS_DEFINITION_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public StringFilterProperty getProcessDefinitionId() {
    return processDefinitionId;
  }


  @JsonProperty(JSON_PROPERTY_PROCESS_DEFINITION_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setProcessDefinitionId(@javax.annotation.Nullable StringFilterProperty processDefinitionId) {
    this.processDefinitionId = processDefinitionId;
  }

  public JobFilter processDefinitionKey(@javax.annotation.Nullable BasicStringFilterProperty processDefinitionKey) {
    
    this.processDefinitionKey = processDefinitionKey;
    return this;
  }

  /**
   * The process definition key associated with the job.
   * @return processDefinitionKey
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_PROCESS_DEFINITION_KEY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public BasicStringFilterProperty getProcessDefinitionKey() {
    return processDefinitionKey;
  }


  @JsonProperty(JSON_PROPERTY_PROCESS_DEFINITION_KEY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setProcessDefinitionKey(@javax.annotation.Nullable BasicStringFilterProperty processDefinitionKey) {
    this.processDefinitionKey = processDefinitionKey;
  }

  public JobFilter processInstanceKey(@javax.annotation.Nullable BasicStringFilterProperty processInstanceKey) {
    
    this.processInstanceKey = processInstanceKey;
    return this;
  }

  /**
   * The process instance key associated with the job.
   * @return processInstanceKey
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_PROCESS_INSTANCE_KEY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public BasicStringFilterProperty getProcessInstanceKey() {
    return processInstanceKey;
  }


  @JsonProperty(JSON_PROPERTY_PROCESS_INSTANCE_KEY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setProcessInstanceKey(@javax.annotation.Nullable BasicStringFilterProperty processInstanceKey) {
    this.processInstanceKey = processInstanceKey;
  }

  public JobFilter retries(@javax.annotation.Nullable IntegerFilterProperty retries) {
    
    this.retries = retries;
    return this;
  }

  /**
   * The number of retries left.
   * @return retries
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_RETRIES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public IntegerFilterProperty getRetries() {
    return retries;
  }


  @JsonProperty(JSON_PROPERTY_RETRIES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRetries(@javax.annotation.Nullable IntegerFilterProperty retries) {
    this.retries = retries;
  }

  public JobFilter state(@javax.annotation.Nullable JobStateFilterProperty state) {
    
    this.state = state;
    return this;
  }

  /**
   * The state of the job.
   * @return state
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_STATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public JobStateFilterProperty getState() {
    return state;
  }


  @JsonProperty(JSON_PROPERTY_STATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setState(@javax.annotation.Nullable JobStateFilterProperty state) {
    this.state = state;
  }

  public JobFilter tenantId(@javax.annotation.Nullable StringFilterProperty tenantId) {
    
    this.tenantId = tenantId;
    return this;
  }

  /**
   * The tenant ID.
   * @return tenantId
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_TENANT_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public StringFilterProperty getTenantId() {
    return tenantId;
  }


  @JsonProperty(JSON_PROPERTY_TENANT_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTenantId(@javax.annotation.Nullable StringFilterProperty tenantId) {
    this.tenantId = tenantId;
  }

  public JobFilter type(@javax.annotation.Nullable StringFilterProperty type) {
    
    this.type = type;
    return this;
  }

  /**
   * The type of the job.
   * @return type
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public StringFilterProperty getType() {
    return type;
  }


  @JsonProperty(JSON_PROPERTY_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setType(@javax.annotation.Nullable StringFilterProperty type) {
    this.type = type;
  }

  public JobFilter worker(@javax.annotation.Nullable StringFilterProperty worker) {
    
    this.worker = worker;
    return this;
  }

  /**
   * The name of the worker for this job.
   * @return worker
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_WORKER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public StringFilterProperty getWorker() {
    return worker;
  }


  @JsonProperty(JSON_PROPERTY_WORKER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setWorker(@javax.annotation.Nullable StringFilterProperty worker) {
    this.worker = worker;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    JobFilter jobFilter = (JobFilter) o;
    return Objects.equals(this.deadline, jobFilter.deadline) &&
        Objects.equals(this.deniedReason, jobFilter.deniedReason) &&
        Objects.equals(this.elementId, jobFilter.elementId) &&
        Objects.equals(this.elementInstanceKey, jobFilter.elementInstanceKey) &&
        Objects.equals(this.endTime, jobFilter.endTime) &&
        Objects.equals(this.errorCode, jobFilter.errorCode) &&
        Objects.equals(this.errorMessage, jobFilter.errorMessage) &&
        Objects.equals(this.hasFailedWithRetriesLeft, jobFilter.hasFailedWithRetriesLeft) &&
        Objects.equals(this.isDenied, jobFilter.isDenied) &&
        Objects.equals(this.jobKey, jobFilter.jobKey) &&
        Objects.equals(this.kind, jobFilter.kind) &&
        Objects.equals(this.listenerEventType, jobFilter.listenerEventType) &&
        Objects.equals(this.processDefinitionId, jobFilter.processDefinitionId) &&
        Objects.equals(this.processDefinitionKey, jobFilter.processDefinitionKey) &&
        Objects.equals(this.processInstanceKey, jobFilter.processInstanceKey) &&
        Objects.equals(this.retries, jobFilter.retries) &&
        Objects.equals(this.state, jobFilter.state) &&
        Objects.equals(this.tenantId, jobFilter.tenantId) &&
        Objects.equals(this.type, jobFilter.type) &&
        Objects.equals(this.worker, jobFilter.worker);
  }

  @Override
  public int hashCode() {
    return Objects.hash(deadline, deniedReason, elementId, elementInstanceKey, endTime, errorCode, errorMessage, hasFailedWithRetriesLeft, isDenied, jobKey, kind, listenerEventType, processDefinitionId, processDefinitionKey, processInstanceKey, retries, state, tenantId, type, worker);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class JobFilter {\n");
    sb.append("    deadline: ").append(toIndentedString(deadline)).append("\n");
    sb.append("    deniedReason: ").append(toIndentedString(deniedReason)).append("\n");
    sb.append("    elementId: ").append(toIndentedString(elementId)).append("\n");
    sb.append("    elementInstanceKey: ").append(toIndentedString(elementInstanceKey)).append("\n");
    sb.append("    endTime: ").append(toIndentedString(endTime)).append("\n");
    sb.append("    errorCode: ").append(toIndentedString(errorCode)).append("\n");
    sb.append("    errorMessage: ").append(toIndentedString(errorMessage)).append("\n");
    sb.append("    hasFailedWithRetriesLeft: ").append(toIndentedString(hasFailedWithRetriesLeft)).append("\n");
    sb.append("    isDenied: ").append(toIndentedString(isDenied)).append("\n");
    sb.append("    jobKey: ").append(toIndentedString(jobKey)).append("\n");
    sb.append("    kind: ").append(toIndentedString(kind)).append("\n");
    sb.append("    listenerEventType: ").append(toIndentedString(listenerEventType)).append("\n");
    sb.append("    processDefinitionId: ").append(toIndentedString(processDefinitionId)).append("\n");
    sb.append("    processDefinitionKey: ").append(toIndentedString(processDefinitionKey)).append("\n");
    sb.append("    processInstanceKey: ").append(toIndentedString(processInstanceKey)).append("\n");
    sb.append("    retries: ").append(toIndentedString(retries)).append("\n");
    sb.append("    state: ").append(toIndentedString(state)).append("\n");
    sb.append("    tenantId: ").append(toIndentedString(tenantId)).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("    worker: ").append(toIndentedString(worker)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Convert the instance into URL query string.
   *
   * @return URL query string
   */
  public String toUrlQueryString() {
    return toUrlQueryString(null);
  }

  /**
   * Convert the instance into URL query string.
   *
   * @param prefix prefix of the query string
   * @return URL query string
   */
  public String toUrlQueryString(String prefix) {
    String suffix = "";
    String containerSuffix = "";
    String containerPrefix = "";
    if (prefix == null) {
      // style=form, explode=true, e.g. /pet?name=cat&type=manx
      prefix = "";
    } else {
      // deepObject style e.g. /pet?id[name]=cat&id[type]=manx
      prefix = prefix + "[";
      suffix = "]";
      containerSuffix = "]";
      containerPrefix = "[";
    }

    StringJoiner joiner = new StringJoiner("&");

    // add `deadline` to the URL query string
    if (getDeadline() != null) {
      joiner.add(getDeadline().toUrlQueryString(prefix + "deadline" + suffix));
    }

    // add `deniedReason` to the URL query string
    if (getDeniedReason() != null) {
      joiner.add(getDeniedReason().toUrlQueryString(prefix + "deniedReason" + suffix));
    }

    // add `elementId` to the URL query string
    if (getElementId() != null) {
      joiner.add(getElementId().toUrlQueryString(prefix + "elementId" + suffix));
    }

    // add `elementInstanceKey` to the URL query string
    if (getElementInstanceKey() != null) {
      joiner.add(getElementInstanceKey().toUrlQueryString(prefix + "elementInstanceKey" + suffix));
    }

    // add `endTime` to the URL query string
    if (getEndTime() != null) {
      joiner.add(getEndTime().toUrlQueryString(prefix + "endTime" + suffix));
    }

    // add `errorCode` to the URL query string
    if (getErrorCode() != null) {
      joiner.add(getErrorCode().toUrlQueryString(prefix + "errorCode" + suffix));
    }

    // add `errorMessage` to the URL query string
    if (getErrorMessage() != null) {
      joiner.add(getErrorMessage().toUrlQueryString(prefix + "errorMessage" + suffix));
    }

    // add `hasFailedWithRetriesLeft` to the URL query string
    if (getHasFailedWithRetriesLeft() != null) {
      try {
        joiner.add(String.format("%shasFailedWithRetriesLeft%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getHasFailedWithRetriesLeft()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `isDenied` to the URL query string
    if (getIsDenied() != null) {
      try {
        joiner.add(String.format("%sisDenied%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getIsDenied()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `jobKey` to the URL query string
    if (getJobKey() != null) {
      joiner.add(getJobKey().toUrlQueryString(prefix + "jobKey" + suffix));
    }

    // add `kind` to the URL query string
    if (getKind() != null) {
      joiner.add(getKind().toUrlQueryString(prefix + "kind" + suffix));
    }

    // add `listenerEventType` to the URL query string
    if (getListenerEventType() != null) {
      joiner.add(getListenerEventType().toUrlQueryString(prefix + "listenerEventType" + suffix));
    }

    // add `processDefinitionId` to the URL query string
    if (getProcessDefinitionId() != null) {
      joiner.add(getProcessDefinitionId().toUrlQueryString(prefix + "processDefinitionId" + suffix));
    }

    // add `processDefinitionKey` to the URL query string
    if (getProcessDefinitionKey() != null) {
      joiner.add(getProcessDefinitionKey().toUrlQueryString(prefix + "processDefinitionKey" + suffix));
    }

    // add `processInstanceKey` to the URL query string
    if (getProcessInstanceKey() != null) {
      joiner.add(getProcessInstanceKey().toUrlQueryString(prefix + "processInstanceKey" + suffix));
    }

    // add `retries` to the URL query string
    if (getRetries() != null) {
      joiner.add(getRetries().toUrlQueryString(prefix + "retries" + suffix));
    }

    // add `state` to the URL query string
    if (getState() != null) {
      joiner.add(getState().toUrlQueryString(prefix + "state" + suffix));
    }

    // add `tenantId` to the URL query string
    if (getTenantId() != null) {
      joiner.add(getTenantId().toUrlQueryString(prefix + "tenantId" + suffix));
    }

    // add `type` to the URL query string
    if (getType() != null) {
      joiner.add(getType().toUrlQueryString(prefix + "type" + suffix));
    }

    // add `worker` to the URL query string
    if (getWorker() != null) {
      joiner.add(getWorker().toUrlQueryString(prefix + "worker" + suffix));
    }

    return joiner.toString();
  }

}

