/*
 * Orchestration Cluster API
 * API for communicating with a Camunda 8 cluster.
 *
 * The version of the OpenAPI document: 0.1
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package io.camunda.client.protocol.rest;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.camunda.client.protocol.rest.JobResult;
import io.camunda.client.protocol.rest.JobResultActivateElement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.StringJoiner;

/**
 * JobResultAdHocSubProcess
 */
@JsonPropertyOrder({
  JobResultAdHocSubProcess.JSON_PROPERTY_ACTIVATE_ELEMENTS,
  JobResultAdHocSubProcess.JSON_PROPERTY_IS_COMPLETION_CONDITION_FULFILLED,
  JobResultAdHocSubProcess.JSON_PROPERTY_IS_CANCEL_REMAINING_INSTANCES
})
@com.fasterxml.jackson.annotation.JsonInclude(com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL)
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-12-11T14:03:07.865311160Z[GMT]", comments = "Generator version: 7.12.0")
@JsonIgnoreProperties(
  value = "type", // ignore manually set type, it will be automatically generated by Jackson during serialization
  allowSetters = true // allows the type to be set during deserialization
)
@JsonTypeInfo(use = JsonTypeInfo.Id.NAME, include = JsonTypeInfo.As.PROPERTY, property = "type", visible = true)

public class JobResultAdHocSubProcess extends JobResult {
  public static final String JSON_PROPERTY_ACTIVATE_ELEMENTS = "activateElements";
  @javax.annotation.Nullable
  private List<JobResultActivateElement> activateElements = new ArrayList<>();

  public static final String JSON_PROPERTY_IS_COMPLETION_CONDITION_FULFILLED = "isCompletionConditionFulfilled";
  @javax.annotation.Nullable
  private Boolean isCompletionConditionFulfilled = false;

  public static final String JSON_PROPERTY_IS_CANCEL_REMAINING_INSTANCES = "isCancelRemainingInstances";
  @javax.annotation.Nullable
  private Boolean isCancelRemainingInstances = false;

  public JobResultAdHocSubProcess() {

  }

  public JobResultAdHocSubProcess activateElements(@javax.annotation.Nullable List<JobResultActivateElement> activateElements) {
    
    this.activateElements = activateElements;
    return this;
  }

  public JobResultAdHocSubProcess addActivateElementsItem(JobResultActivateElement activateElementsItem) {
    if (this.activateElements == null) {
      this.activateElements = new ArrayList<>();
    }
    this.activateElements.add(activateElementsItem);
    return this;
  }

  /**
   * Indicates which elements need to be activated in the ad-hoc subprocess.
   * @return activateElements
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_ACTIVATE_ELEMENTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<JobResultActivateElement> getActivateElements() {
    return activateElements;
  }


  @JsonProperty(JSON_PROPERTY_ACTIVATE_ELEMENTS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setActivateElements(@javax.annotation.Nullable List<JobResultActivateElement> activateElements) {
    this.activateElements = activateElements;
  }

  public JobResultAdHocSubProcess isCompletionConditionFulfilled(@javax.annotation.Nullable Boolean isCompletionConditionFulfilled) {
    
    this.isCompletionConditionFulfilled = isCompletionConditionFulfilled;
    return this;
  }

  /**
   * Indicates whether the completion condition of the ad-hoc subprocess is fulfilled.
   * @return isCompletionConditionFulfilled
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_IS_COMPLETION_CONDITION_FULFILLED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getIsCompletionConditionFulfilled() {
    return isCompletionConditionFulfilled;
  }


  @JsonProperty(JSON_PROPERTY_IS_COMPLETION_CONDITION_FULFILLED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIsCompletionConditionFulfilled(@javax.annotation.Nullable Boolean isCompletionConditionFulfilled) {
    this.isCompletionConditionFulfilled = isCompletionConditionFulfilled;
  }

  public JobResultAdHocSubProcess isCancelRemainingInstances(@javax.annotation.Nullable Boolean isCancelRemainingInstances) {
    
    this.isCancelRemainingInstances = isCancelRemainingInstances;
    return this;
  }

  /**
   * Indicates whether the remaining instances of the ad-hoc subprocess should be canceled.
   * @return isCancelRemainingInstances
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_IS_CANCEL_REMAINING_INSTANCES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getIsCancelRemainingInstances() {
    return isCancelRemainingInstances;
  }


  @JsonProperty(JSON_PROPERTY_IS_CANCEL_REMAINING_INSTANCES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIsCancelRemainingInstances(@javax.annotation.Nullable Boolean isCancelRemainingInstances) {
    this.isCancelRemainingInstances = isCancelRemainingInstances;
  }

  @Override
  public JobResultAdHocSubProcess type(@javax.annotation.Nonnull TypeEnum type) {
    this.setType(type);
    return this;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    JobResultAdHocSubProcess jobResultAdHocSubProcess = (JobResultAdHocSubProcess) o;
    return Objects.equals(this.activateElements, jobResultAdHocSubProcess.activateElements) &&
        Objects.equals(this.isCompletionConditionFulfilled, jobResultAdHocSubProcess.isCompletionConditionFulfilled) &&
        Objects.equals(this.isCancelRemainingInstances, jobResultAdHocSubProcess.isCancelRemainingInstances) &&
        super.equals(o);
  }

  @Override
  public int hashCode() {
    return Objects.hash(activateElements, isCompletionConditionFulfilled, isCancelRemainingInstances, super.hashCode());
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class JobResultAdHocSubProcess {\n");
    sb.append("    ").append(toIndentedString(super.toString())).append("\n");
    sb.append("    activateElements: ").append(toIndentedString(activateElements)).append("\n");
    sb.append("    isCompletionConditionFulfilled: ").append(toIndentedString(isCompletionConditionFulfilled)).append("\n");
    sb.append("    isCancelRemainingInstances: ").append(toIndentedString(isCancelRemainingInstances)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Convert the instance into URL query string.
   *
   * @return URL query string
   */
  public String toUrlQueryString() {
    return toUrlQueryString(null);
  }

  /**
   * Convert the instance into URL query string.
   *
   * @param prefix prefix of the query string
   * @return URL query string
   */
  public String toUrlQueryString(String prefix) {
    String suffix = "";
    String containerSuffix = "";
    String containerPrefix = "";
    if (prefix == null) {
      // style=form, explode=true, e.g. /pet?name=cat&type=manx
      prefix = "";
    } else {
      // deepObject style e.g. /pet?id[name]=cat&id[type]=manx
      prefix = prefix + "[";
      suffix = "]";
      containerSuffix = "]";
      containerPrefix = "[";
    }

    StringJoiner joiner = new StringJoiner("&");

    // add `type` to the URL query string
    if (getType() != null) {
      try {
        joiner.add(String.format("%stype%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getType()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `activateElements` to the URL query string
    if (getActivateElements() != null) {
      for (int i = 0; i < getActivateElements().size(); i++) {
        if (getActivateElements().get(i) != null) {
          joiner.add(getActivateElements().get(i).toUrlQueryString(String.format("%sactivateElements%s%s", prefix, suffix,
              "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix))));
        }
      }
    }

    // add `isCompletionConditionFulfilled` to the URL query string
    if (getIsCompletionConditionFulfilled() != null) {
      try {
        joiner.add(String.format("%sisCompletionConditionFulfilled%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getIsCompletionConditionFulfilled()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `isCancelRemainingInstances` to the URL query string
    if (getIsCancelRemainingInstances() != null) {
      try {
        joiner.add(String.format("%sisCancelRemainingInstances%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getIsCancelRemainingInstances()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    return joiner.toString();
  }

}

