/*
 * Orchestration Cluster API
 * API for communicating with a Camunda 8 cluster.
 *
 * The version of the OpenAPI document: 0.1
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package io.camunda.client.protocol.rest;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.camunda.client.protocol.rest.ProcessInstanceCreationRuntimeInstruction;
import io.camunda.client.protocol.rest.ProcessInstanceCreationStartInstruction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.StringJoiner;

/**
 * ProcessInstanceCreationInstruction
 */
@JsonPropertyOrder({
  ProcessInstanceCreationInstruction.JSON_PROPERTY_PROCESS_DEFINITION_ID,
  ProcessInstanceCreationInstruction.JSON_PROPERTY_PROCESS_DEFINITION_VERSION,
  ProcessInstanceCreationInstruction.JSON_PROPERTY_VARIABLES,
  ProcessInstanceCreationInstruction.JSON_PROPERTY_TENANT_ID,
  ProcessInstanceCreationInstruction.JSON_PROPERTY_TAGS,
  ProcessInstanceCreationInstruction.JSON_PROPERTY_OPERATION_REFERENCE,
  ProcessInstanceCreationInstruction.JSON_PROPERTY_START_INSTRUCTIONS,
  ProcessInstanceCreationInstruction.JSON_PROPERTY_RUNTIME_INSTRUCTIONS,
  ProcessInstanceCreationInstruction.JSON_PROPERTY_AWAIT_COMPLETION,
  ProcessInstanceCreationInstruction.JSON_PROPERTY_FETCH_VARIABLES,
  ProcessInstanceCreationInstruction.JSON_PROPERTY_REQUEST_TIMEOUT,
  ProcessInstanceCreationInstruction.JSON_PROPERTY_PROCESS_DEFINITION_KEY
})
@com.fasterxml.jackson.annotation.JsonInclude(com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL)
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-12-11T14:03:07.865311160Z[GMT]", comments = "Generator version: 7.12.0")
public class ProcessInstanceCreationInstruction {
  public static final String JSON_PROPERTY_PROCESS_DEFINITION_ID = "processDefinitionId";
  @javax.annotation.Nullable
  private String processDefinitionId;

  public static final String JSON_PROPERTY_PROCESS_DEFINITION_VERSION = "processDefinitionVersion";
  @javax.annotation.Nullable
  private Integer processDefinitionVersion = -1;

  public static final String JSON_PROPERTY_VARIABLES = "variables";
  @javax.annotation.Nullable
  private Map<String, Object> variables = new HashMap<>();

  public static final String JSON_PROPERTY_TENANT_ID = "tenantId";
  @javax.annotation.Nullable
  private String tenantId;

  public static final String JSON_PROPERTY_TAGS = "tags";
  @javax.annotation.Nullable
  private Set<String> tags = new LinkedHashSet<>();

  public static final String JSON_PROPERTY_OPERATION_REFERENCE = "operationReference";
  @javax.annotation.Nullable
  private Long operationReference;

  public static final String JSON_PROPERTY_START_INSTRUCTIONS = "startInstructions";
  @javax.annotation.Nullable
  private List<ProcessInstanceCreationStartInstruction> startInstructions = new ArrayList<>();

  public static final String JSON_PROPERTY_RUNTIME_INSTRUCTIONS = "runtimeInstructions";
  @javax.annotation.Nullable
  private List<ProcessInstanceCreationRuntimeInstruction> runtimeInstructions = new ArrayList<>();

  public static final String JSON_PROPERTY_AWAIT_COMPLETION = "awaitCompletion";
  @javax.annotation.Nullable
  private Boolean awaitCompletion = false;

  public static final String JSON_PROPERTY_FETCH_VARIABLES = "fetchVariables";
  @javax.annotation.Nullable
  private List<String> fetchVariables = new ArrayList<>();

  public static final String JSON_PROPERTY_REQUEST_TIMEOUT = "requestTimeout";
  @javax.annotation.Nullable
  private Long requestTimeout;

  public static final String JSON_PROPERTY_PROCESS_DEFINITION_KEY = "processDefinitionKey";
  @javax.annotation.Nullable
  private String processDefinitionKey;

  public ProcessInstanceCreationInstruction() {
  }

  public ProcessInstanceCreationInstruction processDefinitionId(@javax.annotation.Nullable String processDefinitionId) {
    
    this.processDefinitionId = processDefinitionId;
    return this;
  }

  /**
   * The BPMN process ID of the process definition to start an instance of. Cannot be used together with processDefinitionKey. 
   * @return processDefinitionId
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_PROCESS_DEFINITION_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getProcessDefinitionId() {
    return processDefinitionId;
  }


  @JsonProperty(JSON_PROPERTY_PROCESS_DEFINITION_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setProcessDefinitionId(@javax.annotation.Nullable String processDefinitionId) {
    this.processDefinitionId = processDefinitionId;
  }

  public ProcessInstanceCreationInstruction processDefinitionVersion(@javax.annotation.Nullable Integer processDefinitionVersion) {
    
    this.processDefinitionVersion = processDefinitionVersion;
    return this;
  }

  /**
   * The version of the process. Only considered when a processDefinitionId is provided. By default, the latest version of the process is used. 
   * @return processDefinitionVersion
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_PROCESS_DEFINITION_VERSION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getProcessDefinitionVersion() {
    return processDefinitionVersion;
  }


  @JsonProperty(JSON_PROPERTY_PROCESS_DEFINITION_VERSION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setProcessDefinitionVersion(@javax.annotation.Nullable Integer processDefinitionVersion) {
    this.processDefinitionVersion = processDefinitionVersion;
  }

  public ProcessInstanceCreationInstruction variables(@javax.annotation.Nullable Map<String, Object> variables) {
    
    this.variables = variables;
    return this;
  }

  public ProcessInstanceCreationInstruction putVariablesItem(String key, Object variablesItem) {
    if (this.variables == null) {
      this.variables = new HashMap<>();
    }
    this.variables.put(key, variablesItem);
    return this;
  }

  /**
   * JSON object that will instantiate the variables for the root variable scope of the process instance. 
   * @return variables
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_VARIABLES)
  @JsonInclude(content = JsonInclude.Include.ALWAYS, value = JsonInclude.Include.USE_DEFAULTS)

  public Map<String, Object> getVariables() {
    return variables;
  }


  @JsonProperty(JSON_PROPERTY_VARIABLES)
  @JsonInclude(content = JsonInclude.Include.ALWAYS, value = JsonInclude.Include.USE_DEFAULTS)
  public void setVariables(@javax.annotation.Nullable Map<String, Object> variables) {
    this.variables = variables;
  }

  public ProcessInstanceCreationInstruction tenantId(@javax.annotation.Nullable String tenantId) {
    
    this.tenantId = tenantId;
    return this;
  }

  /**
   * The tenant ID of the process definition.
   * @return tenantId
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_TENANT_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getTenantId() {
    return tenantId;
  }


  @JsonProperty(JSON_PROPERTY_TENANT_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTenantId(@javax.annotation.Nullable String tenantId) {
    this.tenantId = tenantId;
  }

  public ProcessInstanceCreationInstruction tags(@javax.annotation.Nullable Set<String> tags) {
    
    this.tags = tags;
    return this;
  }

  public ProcessInstanceCreationInstruction addTagsItem(String tagsItem) {
    if (this.tags == null) {
      this.tags = new LinkedHashSet<>();
    }
    this.tags.add(tagsItem);
    return this;
  }

  /**
   * List of tags
   * @return tags
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_TAGS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Set<String> getTags() {
    return tags;
  }


  @JsonDeserialize(as = LinkedHashSet.class)
  @JsonProperty(JSON_PROPERTY_TAGS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTags(@javax.annotation.Nullable Set<String> tags) {
    this.tags = tags;
  }

  public ProcessInstanceCreationInstruction operationReference(@javax.annotation.Nullable Long operationReference) {
    
    this.operationReference = operationReference;
    return this;
  }

  /**
   * A reference key chosen by the user that will be part of all records resulting from this operation. Must be &gt; 0 if provided. 
   * minimum: 1
   * @return operationReference
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_OPERATION_REFERENCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Long getOperationReference() {
    return operationReference;
  }


  @JsonProperty(JSON_PROPERTY_OPERATION_REFERENCE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setOperationReference(@javax.annotation.Nullable Long operationReference) {
    this.operationReference = operationReference;
  }

  public ProcessInstanceCreationInstruction startInstructions(@javax.annotation.Nullable List<ProcessInstanceCreationStartInstruction> startInstructions) {
    
    this.startInstructions = startInstructions;
    return this;
  }

  public ProcessInstanceCreationInstruction addStartInstructionsItem(ProcessInstanceCreationStartInstruction startInstructionsItem) {
    if (this.startInstructions == null) {
      this.startInstructions = new ArrayList<>();
    }
    this.startInstructions.add(startInstructionsItem);
    return this;
  }

  /**
   * List of start instructions. By default, the process instance will start at the start event. If provided, the process instance will apply start instructions after it has been created. 
   * @return startInstructions
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_START_INSTRUCTIONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<ProcessInstanceCreationStartInstruction> getStartInstructions() {
    return startInstructions;
  }


  @JsonProperty(JSON_PROPERTY_START_INSTRUCTIONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setStartInstructions(@javax.annotation.Nullable List<ProcessInstanceCreationStartInstruction> startInstructions) {
    this.startInstructions = startInstructions;
  }

  public ProcessInstanceCreationInstruction runtimeInstructions(@javax.annotation.Nullable List<ProcessInstanceCreationRuntimeInstruction> runtimeInstructions) {
    
    this.runtimeInstructions = runtimeInstructions;
    return this;
  }

  public ProcessInstanceCreationInstruction addRuntimeInstructionsItem(ProcessInstanceCreationRuntimeInstruction runtimeInstructionsItem) {
    if (this.runtimeInstructions == null) {
      this.runtimeInstructions = new ArrayList<>();
    }
    this.runtimeInstructions.add(runtimeInstructionsItem);
    return this;
  }

  /**
   * Runtime instructions (alpha). List of instructions that affect the runtime behavior of the process instance. Refer to specific instruction types for more details.  This parameter is an alpha feature and may be subject to change in future releases. 
   * @return runtimeInstructions
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_RUNTIME_INSTRUCTIONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<ProcessInstanceCreationRuntimeInstruction> getRuntimeInstructions() {
    return runtimeInstructions;
  }


  @JsonProperty(JSON_PROPERTY_RUNTIME_INSTRUCTIONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRuntimeInstructions(@javax.annotation.Nullable List<ProcessInstanceCreationRuntimeInstruction> runtimeInstructions) {
    this.runtimeInstructions = runtimeInstructions;
  }

  public ProcessInstanceCreationInstruction awaitCompletion(@javax.annotation.Nullable Boolean awaitCompletion) {
    
    this.awaitCompletion = awaitCompletion;
    return this;
  }

  /**
   * Wait for the process instance to complete. If the process instance completion does not occur within the requestTimeout, the request will be closed. This can lead to a 504 response status. Disabled by default. 
   * @return awaitCompletion
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_AWAIT_COMPLETION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getAwaitCompletion() {
    return awaitCompletion;
  }


  @JsonProperty(JSON_PROPERTY_AWAIT_COMPLETION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAwaitCompletion(@javax.annotation.Nullable Boolean awaitCompletion) {
    this.awaitCompletion = awaitCompletion;
  }

  public ProcessInstanceCreationInstruction fetchVariables(@javax.annotation.Nullable List<String> fetchVariables) {
    
    this.fetchVariables = fetchVariables;
    return this;
  }

  public ProcessInstanceCreationInstruction addFetchVariablesItem(String fetchVariablesItem) {
    if (this.fetchVariables == null) {
      this.fetchVariables = new ArrayList<>();
    }
    this.fetchVariables.add(fetchVariablesItem);
    return this;
  }

  /**
   * List of variables by name to be included in the response when awaitCompletion is set to true. If empty, all visible variables in the root scope will be returned. 
   * @return fetchVariables
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_FETCH_VARIABLES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<String> getFetchVariables() {
    return fetchVariables;
  }


  @JsonProperty(JSON_PROPERTY_FETCH_VARIABLES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setFetchVariables(@javax.annotation.Nullable List<String> fetchVariables) {
    this.fetchVariables = fetchVariables;
  }

  public ProcessInstanceCreationInstruction requestTimeout(@javax.annotation.Nullable Long requestTimeout) {
    
    this.requestTimeout = requestTimeout;
    return this;
  }

  /**
   * Timeout (in ms) the request waits for the process to complete. By default or when set to 0, the generic request timeout configured in the cluster is applied. 
   * @return requestTimeout
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_REQUEST_TIMEOUT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Long getRequestTimeout() {
    return requestTimeout;
  }


  @JsonProperty(JSON_PROPERTY_REQUEST_TIMEOUT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setRequestTimeout(@javax.annotation.Nullable Long requestTimeout) {
    this.requestTimeout = requestTimeout;
  }

  public ProcessInstanceCreationInstruction processDefinitionKey(@javax.annotation.Nullable String processDefinitionKey) {
    
    this.processDefinitionKey = processDefinitionKey;
    return this;
  }

  /**
   * The unique key identifying the process definition, for example, returned for a process in the deploy resources endpoint. Cannot be used together with processDefinitionId. 
   * @return processDefinitionKey
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_PROCESS_DEFINITION_KEY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getProcessDefinitionKey() {
    return processDefinitionKey;
  }


  @JsonProperty(JSON_PROPERTY_PROCESS_DEFINITION_KEY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setProcessDefinitionKey(@javax.annotation.Nullable String processDefinitionKey) {
    this.processDefinitionKey = processDefinitionKey;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ProcessInstanceCreationInstruction processInstanceCreationInstruction = (ProcessInstanceCreationInstruction) o;
    return Objects.equals(this.processDefinitionId, processInstanceCreationInstruction.processDefinitionId) &&
        Objects.equals(this.processDefinitionVersion, processInstanceCreationInstruction.processDefinitionVersion) &&
        Objects.equals(this.variables, processInstanceCreationInstruction.variables) &&
        Objects.equals(this.tenantId, processInstanceCreationInstruction.tenantId) &&
        Objects.equals(this.tags, processInstanceCreationInstruction.tags) &&
        Objects.equals(this.operationReference, processInstanceCreationInstruction.operationReference) &&
        Objects.equals(this.startInstructions, processInstanceCreationInstruction.startInstructions) &&
        Objects.equals(this.runtimeInstructions, processInstanceCreationInstruction.runtimeInstructions) &&
        Objects.equals(this.awaitCompletion, processInstanceCreationInstruction.awaitCompletion) &&
        Objects.equals(this.fetchVariables, processInstanceCreationInstruction.fetchVariables) &&
        Objects.equals(this.requestTimeout, processInstanceCreationInstruction.requestTimeout) &&
        Objects.equals(this.processDefinitionKey, processInstanceCreationInstruction.processDefinitionKey);
  }

  @Override
  public int hashCode() {
    return Objects.hash(processDefinitionId, processDefinitionVersion, variables, tenantId, tags, operationReference, startInstructions, runtimeInstructions, awaitCompletion, fetchVariables, requestTimeout, processDefinitionKey);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ProcessInstanceCreationInstruction {\n");
    sb.append("    processDefinitionId: ").append(toIndentedString(processDefinitionId)).append("\n");
    sb.append("    processDefinitionVersion: ").append(toIndentedString(processDefinitionVersion)).append("\n");
    sb.append("    variables: ").append(toIndentedString(variables)).append("\n");
    sb.append("    tenantId: ").append(toIndentedString(tenantId)).append("\n");
    sb.append("    tags: ").append(toIndentedString(tags)).append("\n");
    sb.append("    operationReference: ").append(toIndentedString(operationReference)).append("\n");
    sb.append("    startInstructions: ").append(toIndentedString(startInstructions)).append("\n");
    sb.append("    runtimeInstructions: ").append(toIndentedString(runtimeInstructions)).append("\n");
    sb.append("    awaitCompletion: ").append(toIndentedString(awaitCompletion)).append("\n");
    sb.append("    fetchVariables: ").append(toIndentedString(fetchVariables)).append("\n");
    sb.append("    requestTimeout: ").append(toIndentedString(requestTimeout)).append("\n");
    sb.append("    processDefinitionKey: ").append(toIndentedString(processDefinitionKey)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Convert the instance into URL query string.
   *
   * @return URL query string
   */
  public String toUrlQueryString() {
    return toUrlQueryString(null);
  }

  /**
   * Convert the instance into URL query string.
   *
   * @param prefix prefix of the query string
   * @return URL query string
   */
  public String toUrlQueryString(String prefix) {
    String suffix = "";
    String containerSuffix = "";
    String containerPrefix = "";
    if (prefix == null) {
      // style=form, explode=true, e.g. /pet?name=cat&type=manx
      prefix = "";
    } else {
      // deepObject style e.g. /pet?id[name]=cat&id[type]=manx
      prefix = prefix + "[";
      suffix = "]";
      containerSuffix = "]";
      containerPrefix = "[";
    }

    StringJoiner joiner = new StringJoiner("&");

    // add `processDefinitionId` to the URL query string
    if (getProcessDefinitionId() != null) {
      try {
        joiner.add(String.format("%sprocessDefinitionId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getProcessDefinitionId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `processDefinitionVersion` to the URL query string
    if (getProcessDefinitionVersion() != null) {
      try {
        joiner.add(String.format("%sprocessDefinitionVersion%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getProcessDefinitionVersion()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `variables` to the URL query string
    if (getVariables() != null) {
      for (String _key : getVariables().keySet()) {
        try {
          joiner.add(String.format("%svariables%s%s=%s", prefix, suffix,
              "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, _key, containerSuffix),
              getVariables().get(_key), URLEncoder.encode(String.valueOf(getVariables().get(_key)), "UTF-8").replaceAll("\\+", "%20")));
        } catch (UnsupportedEncodingException e) {
          // Should never happen, UTF-8 is always supported
          throw new RuntimeException(e);
        }
      }
    }

    // add `tenantId` to the URL query string
    if (getTenantId() != null) {
      try {
        joiner.add(String.format("%stenantId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getTenantId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `tags` to the URL query string
    if (getTags() != null) {
      int i = 0;
      for (String _item : getTags()) {
        try {
          joiner.add(String.format("%stags%s%s=%s", prefix, suffix,
              "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix),
              URLEncoder.encode(String.valueOf(_item), "UTF-8").replaceAll("\\+", "%20")));
        } catch (UnsupportedEncodingException e) {
          // Should never happen, UTF-8 is always supported
          throw new RuntimeException(e);
        }
      }
      i++;
    }

    // add `operationReference` to the URL query string
    if (getOperationReference() != null) {
      try {
        joiner.add(String.format("%soperationReference%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getOperationReference()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `startInstructions` to the URL query string
    if (getStartInstructions() != null) {
      for (int i = 0; i < getStartInstructions().size(); i++) {
        if (getStartInstructions().get(i) != null) {
          joiner.add(getStartInstructions().get(i).toUrlQueryString(String.format("%sstartInstructions%s%s", prefix, suffix,
              "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix))));
        }
      }
    }

    // add `runtimeInstructions` to the URL query string
    if (getRuntimeInstructions() != null) {
      for (int i = 0; i < getRuntimeInstructions().size(); i++) {
        if (getRuntimeInstructions().get(i) != null) {
          joiner.add(getRuntimeInstructions().get(i).toUrlQueryString(String.format("%sruntimeInstructions%s%s", prefix, suffix,
              "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix))));
        }
      }
    }

    // add `awaitCompletion` to the URL query string
    if (getAwaitCompletion() != null) {
      try {
        joiner.add(String.format("%sawaitCompletion%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getAwaitCompletion()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `fetchVariables` to the URL query string
    if (getFetchVariables() != null) {
      for (int i = 0; i < getFetchVariables().size(); i++) {
        try {
          joiner.add(String.format("%sfetchVariables%s%s=%s", prefix, suffix,
              "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix),
              URLEncoder.encode(String.valueOf(getFetchVariables().get(i)), "UTF-8").replaceAll("\\+", "%20")));
        } catch (UnsupportedEncodingException e) {
          // Should never happen, UTF-8 is always supported
          throw new RuntimeException(e);
        }
      }
    }

    // add `requestTimeout` to the URL query string
    if (getRequestTimeout() != null) {
      try {
        joiner.add(String.format("%srequestTimeout%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getRequestTimeout()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `processDefinitionKey` to the URL query string
    if (getProcessDefinitionKey() != null) {
      try {
        joiner.add(String.format("%sprocessDefinitionKey%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getProcessDefinitionKey()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    return joiner.toString();
  }

}

