/*
 * Orchestration Cluster API
 * API for communicating with a Camunda 8 cluster.
 *
 * The version of the OpenAPI document: 0.1
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package io.camunda.client.protocol.rest;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.StringJoiner;

/**
 * SearchQueryPageRequest
 */
@JsonPropertyOrder({
  SearchQueryPageRequest.JSON_PROPERTY_FROM,
  SearchQueryPageRequest.JSON_PROPERTY_LIMIT,
  SearchQueryPageRequest.JSON_PROPERTY_AFTER,
  SearchQueryPageRequest.JSON_PROPERTY_BEFORE
})
@com.fasterxml.jackson.annotation.JsonInclude(com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL)
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-12-11T14:03:07.865311160Z[GMT]", comments = "Generator version: 7.12.0")
public class SearchQueryPageRequest {
  public static final String JSON_PROPERTY_FROM = "from";
  @javax.annotation.Nullable
  private Integer from;

  public static final String JSON_PROPERTY_LIMIT = "limit";
  @javax.annotation.Nullable
  private Integer limit = 100;

  public static final String JSON_PROPERTY_AFTER = "after";
  @javax.annotation.Nullable
  private String after;

  public static final String JSON_PROPERTY_BEFORE = "before";
  @javax.annotation.Nullable
  private String before;

  public SearchQueryPageRequest() {
  }

  public SearchQueryPageRequest from(@javax.annotation.Nullable Integer from) {
    
    this.from = from;
    return this;
  }

  /**
   * The index of items to start searching from.
   * @return from
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_FROM)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getFrom() {
    return from;
  }


  @JsonProperty(JSON_PROPERTY_FROM)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setFrom(@javax.annotation.Nullable Integer from) {
    this.from = from;
  }

  public SearchQueryPageRequest limit(@javax.annotation.Nullable Integer limit) {
    
    this.limit = limit;
    return this;
  }

  /**
   * The maximum number of items to return in one request.
   * @return limit
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_LIMIT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getLimit() {
    return limit;
  }


  @JsonProperty(JSON_PROPERTY_LIMIT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLimit(@javax.annotation.Nullable Integer limit) {
    this.limit = limit;
  }

  public SearchQueryPageRequest after(@javax.annotation.Nullable String after) {
    
    this.after = after;
    return this;
  }

  /**
   * Use the &#x60;endCursor&#x60; value from the previous response to fetch the next page of results.
   * @return after
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_AFTER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getAfter() {
    return after;
  }


  @JsonProperty(JSON_PROPERTY_AFTER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAfter(@javax.annotation.Nullable String after) {
    this.after = after;
  }

  public SearchQueryPageRequest before(@javax.annotation.Nullable String before) {
    
    this.before = before;
    return this;
  }

  /**
   * Use the &#x60;startCursor&#x60; value from the previous response to fetch the previous page of results.
   * @return before
   */
  @javax.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_BEFORE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getBefore() {
    return before;
  }


  @JsonProperty(JSON_PROPERTY_BEFORE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setBefore(@javax.annotation.Nullable String before) {
    this.before = before;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    SearchQueryPageRequest searchQueryPageRequest = (SearchQueryPageRequest) o;
    return Objects.equals(this.from, searchQueryPageRequest.from) &&
        Objects.equals(this.limit, searchQueryPageRequest.limit) &&
        Objects.equals(this.after, searchQueryPageRequest.after) &&
        Objects.equals(this.before, searchQueryPageRequest.before);
  }

  @Override
  public int hashCode() {
    return Objects.hash(from, limit, after, before);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class SearchQueryPageRequest {\n");
    sb.append("    from: ").append(toIndentedString(from)).append("\n");
    sb.append("    limit: ").append(toIndentedString(limit)).append("\n");
    sb.append("    after: ").append(toIndentedString(after)).append("\n");
    sb.append("    before: ").append(toIndentedString(before)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Convert the instance into URL query string.
   *
   * @return URL query string
   */
  public String toUrlQueryString() {
    return toUrlQueryString(null);
  }

  /**
   * Convert the instance into URL query string.
   *
   * @param prefix prefix of the query string
   * @return URL query string
   */
  public String toUrlQueryString(String prefix) {
    String suffix = "";
    String containerSuffix = "";
    String containerPrefix = "";
    if (prefix == null) {
      // style=form, explode=true, e.g. /pet?name=cat&type=manx
      prefix = "";
    } else {
      // deepObject style e.g. /pet?id[name]=cat&id[type]=manx
      prefix = prefix + "[";
      suffix = "]";
      containerSuffix = "]";
      containerPrefix = "[";
    }

    StringJoiner joiner = new StringJoiner("&");

    // add `from` to the URL query string
    if (getFrom() != null) {
      try {
        joiner.add(String.format("%sfrom%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getFrom()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `limit` to the URL query string
    if (getLimit() != null) {
      try {
        joiner.add(String.format("%slimit%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getLimit()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `after` to the URL query string
    if (getAfter() != null) {
      try {
        joiner.add(String.format("%safter%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getAfter()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `before` to the URL query string
    if (getBefore() != null) {
      try {
        joiner.add(String.format("%sbefore%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getBefore()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    return joiner.toString();
  }

}

