/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.client.impl.command;

import io.camunda.client.api.CamundaFuture;
import io.camunda.client.api.command.AssignClientToTenantCommandStep1;
import io.camunda.client.api.command.FinalCommandStep;
import io.camunda.client.api.response.AssignClientToTenantResponse;
import io.camunda.client.impl.command.ArgumentUtil;
import io.camunda.client.impl.http.HttpCamundaFuture;
import io.camunda.client.impl.http.HttpClient;
import io.camunda.client.impl.response.AssignClientToTenantResponseImpl;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import org.apache.hc.client5.http.config.RequestConfig;

public class AssignClientToTenantCommandImpl
implements AssignClientToTenantCommandStep1,
AssignClientToTenantCommandStep1.AssignClientToTenantCommandStep2,
AssignClientToTenantCommandStep1.AssignClientToTenantCommandStep3 {
    private final HttpClient httpClient;
    private final RequestConfig.Builder httpRequestConfig;
    private String clientId;
    private String tenantId;

    public AssignClientToTenantCommandImpl(HttpClient httpClient) {
        this.httpClient = httpClient;
        this.httpRequestConfig = httpClient.newRequestConfig();
    }

    @Override
    public AssignClientToTenantCommandStep1.AssignClientToTenantCommandStep2 clientId(String clientId) {
        this.clientId = clientId;
        return this;
    }

    @Override
    public AssignClientToTenantCommandStep1.AssignClientToTenantCommandStep3 tenantId(String tenantId) {
        this.tenantId = tenantId;
        return this;
    }

    @Override
    public FinalCommandStep<AssignClientToTenantResponse> requestTimeout(Duration requestTimeout) {
        this.httpRequestConfig.setResponseTimeout(requestTimeout.toMillis(), TimeUnit.MILLISECONDS);
        return this;
    }

    @Override
    public CamundaFuture<AssignClientToTenantResponse> send() {
        ArgumentUtil.ensureNotNullNorEmpty("clientId", this.clientId);
        ArgumentUtil.ensureNotNullNorEmpty("tenantId", this.tenantId);
        HttpCamundaFuture<AssignClientToTenantResponse> result = new HttpCamundaFuture<AssignClientToTenantResponse>();
        this.httpClient.put("/tenants/" + this.tenantId + "/clients/" + this.clientId, null, this.httpRequestConfig.build(), AssignClientToTenantResponseImpl::new, result);
        return result;
    }
}

