/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.client.impl.search.request;

import io.camunda.client.api.CamundaFuture;
import io.camunda.client.api.JsonMapper;
import io.camunda.client.api.search.filter.ClientFilter;
import io.camunda.client.api.search.request.ClientsByRoleSearchRequest;
import io.camunda.client.api.search.request.FinalSearchRequestStep;
import io.camunda.client.api.search.request.SearchRequestBuilders;
import io.camunda.client.api.search.request.SearchRequestPage;
import io.camunda.client.api.search.response.Client;
import io.camunda.client.api.search.response.SearchResponse;
import io.camunda.client.api.search.sort.ClientSort;
import io.camunda.client.impl.command.ArgumentUtil;
import io.camunda.client.impl.http.HttpCamundaFuture;
import io.camunda.client.impl.http.HttpClient;
import io.camunda.client.impl.search.request.SearchRequestSortMapper;
import io.camunda.client.impl.search.request.TypedSearchRequestPropertyProvider;
import io.camunda.client.impl.search.response.SearchResponseMapper;
import io.camunda.client.protocol.rest.RoleClientSearchQueryRequest;
import io.camunda.client.protocol.rest.RoleClientSearchResult;
import io.camunda.client.protocol.rest.SearchQueryPageRequest;
import java.time.Duration;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.apache.hc.client5.http.config.RequestConfig;

public class ClientsByRoleSearchRequestImpl
extends TypedSearchRequestPropertyProvider<RoleClientSearchQueryRequest>
implements ClientsByRoleSearchRequest {
    private final RoleClientSearchQueryRequest request;
    private final String roleId;
    private final HttpClient httpClient;
    private final JsonMapper jsonMapper;
    private final RequestConfig.Builder httpRequestConfig;

    public ClientsByRoleSearchRequestImpl(HttpClient httpClient, JsonMapper jsonMapper, String roleId) {
        this.httpClient = httpClient;
        this.jsonMapper = jsonMapper;
        this.roleId = roleId;
        this.httpRequestConfig = httpClient.newRequestConfig();
        this.request = new RoleClientSearchQueryRequest();
    }

    @Override
    public FinalSearchRequestStep<Client> requestTimeout(Duration requestTimeout) {
        this.httpRequestConfig.setResponseTimeout(requestTimeout.toMillis(), TimeUnit.MILLISECONDS);
        return this;
    }

    @Override
    public CamundaFuture<SearchResponse<Client>> send() {
        ArgumentUtil.ensureNotNullNorEmpty("roleId", this.roleId);
        HttpCamundaFuture<SearchResponse<Client>> result = new HttpCamundaFuture<SearchResponse<Client>>();
        this.httpClient.post(String.format("/roles/%s/clients/search", this.roleId), this.jsonMapper.toJson(this.request), this.httpRequestConfig.build(), RoleClientSearchResult.class, SearchResponseMapper::toClientsResponse, result);
        return result;
    }

    @Override
    public ClientsByRoleSearchRequest filter(ClientFilter value) {
        throw new UnsupportedOperationException("This command does not support filtering");
    }

    @Override
    public ClientsByRoleSearchRequest filter(Consumer<ClientFilter> fn) {
        throw new UnsupportedOperationException("This command does not support filtering");
    }

    @Override
    public ClientsByRoleSearchRequest sort(ClientSort value) {
        this.request.setSort(SearchRequestSortMapper.toRoleClientSearchQuerySortRequest((List)ClientsByRoleSearchRequestImpl.provideSearchRequestProperty(value)));
        return this;
    }

    @Override
    public ClientsByRoleSearchRequest sort(Consumer<ClientSort> fn) {
        return this.sort(SearchRequestBuilders.clientSort(fn));
    }

    @Override
    public ClientsByRoleSearchRequest page(SearchRequestPage value) {
        this.request.setPage((SearchQueryPageRequest)ClientsByRoleSearchRequestImpl.provideSearchRequestProperty(value));
        return this;
    }

    @Override
    public ClientsByRoleSearchRequest page(Consumer<SearchRequestPage> fn) {
        return this.page(SearchRequestBuilders.searchRequestPage(fn));
    }

    @Override
    protected RoleClientSearchQueryRequest getSearchRequestProperty() {
        return this.request;
    }
}

