/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.client.impl.search.request;

import io.camunda.client.api.CamundaFuture;
import io.camunda.client.api.JsonMapper;
import io.camunda.client.api.search.filter.DecisionDefinitionFilter;
import io.camunda.client.api.search.request.DecisionDefinitionSearchRequest;
import io.camunda.client.api.search.request.FinalSearchRequestStep;
import io.camunda.client.api.search.request.SearchRequestBuilders;
import io.camunda.client.api.search.request.SearchRequestPage;
import io.camunda.client.api.search.response.DecisionDefinition;
import io.camunda.client.api.search.response.SearchResponse;
import io.camunda.client.api.search.sort.DecisionDefinitionSort;
import io.camunda.client.impl.http.HttpCamundaFuture;
import io.camunda.client.impl.http.HttpClient;
import io.camunda.client.impl.search.request.SearchRequestSortMapper;
import io.camunda.client.impl.search.request.TypedSearchRequestPropertyProvider;
import io.camunda.client.impl.search.response.SearchResponseMapper;
import io.camunda.client.protocol.rest.DecisionDefinitionSearchQuery;
import io.camunda.client.protocol.rest.DecisionDefinitionSearchQueryResult;
import io.camunda.client.protocol.rest.SearchQueryPageRequest;
import java.time.Duration;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.apache.hc.client5.http.config.RequestConfig;

public class DecisionDefinitionSearchRequestImpl
extends TypedSearchRequestPropertyProvider<DecisionDefinitionSearchQuery>
implements DecisionDefinitionSearchRequest {
    private final DecisionDefinitionSearchQuery request = new DecisionDefinitionSearchQuery();
    private final JsonMapper jsonMapper;
    private final HttpClient httpClient;
    private final RequestConfig.Builder httpRequestConfig;

    public DecisionDefinitionSearchRequestImpl(HttpClient httpClient, JsonMapper jsonMapper) {
        this.jsonMapper = jsonMapper;
        this.httpClient = httpClient;
        this.httpRequestConfig = httpClient.newRequestConfig();
    }

    @Override
    public DecisionDefinitionSearchRequest filter(DecisionDefinitionFilter value) {
        this.request.setFilter((io.camunda.client.protocol.rest.DecisionDefinitionFilter)DecisionDefinitionSearchRequestImpl.provideSearchRequestProperty(value));
        return this;
    }

    @Override
    public DecisionDefinitionSearchRequest filter(Consumer<DecisionDefinitionFilter> fn) {
        return this.filter(SearchRequestBuilders.decisionDefinitionFilter(fn));
    }

    @Override
    public DecisionDefinitionSearchRequest sort(DecisionDefinitionSort value) {
        this.request.setSort(SearchRequestSortMapper.toDecisionDefinitionSearchQuerySortRequest((List)DecisionDefinitionSearchRequestImpl.provideSearchRequestProperty(value)));
        return this;
    }

    @Override
    public DecisionDefinitionSearchRequest sort(Consumer<DecisionDefinitionSort> fn) {
        return this.sort(SearchRequestBuilders.decisionDefinitionSort(fn));
    }

    @Override
    public DecisionDefinitionSearchRequest page(SearchRequestPage value) {
        this.request.setPage((SearchQueryPageRequest)DecisionDefinitionSearchRequestImpl.provideSearchRequestProperty(value));
        return this;
    }

    @Override
    public DecisionDefinitionSearchRequest page(Consumer<SearchRequestPage> fn) {
        return this.page(SearchRequestBuilders.searchRequestPage(fn));
    }

    @Override
    protected DecisionDefinitionSearchQuery getSearchRequestProperty() {
        return this.request;
    }

    @Override
    public FinalSearchRequestStep<DecisionDefinition> requestTimeout(Duration requestTimeout) {
        this.httpRequestConfig.setResponseTimeout(requestTimeout.toMillis(), TimeUnit.MILLISECONDS);
        return this;
    }

    @Override
    public CamundaFuture<SearchResponse<DecisionDefinition>> send() {
        HttpCamundaFuture<SearchResponse<DecisionDefinition>> result = new HttpCamundaFuture<SearchResponse<DecisionDefinition>>();
        this.httpClient.post("/decision-definitions/search", this.jsonMapper.toJson(this.request), this.httpRequestConfig.build(), DecisionDefinitionSearchQueryResult.class, SearchResponseMapper::toDecisionDefinitionSearchResponse, result);
        return result;
    }
}

